/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.engine.impl;

import dev.amble.ait.api.ArtronHolder;
import dev.amble.ait.api.tardis.TardisEvents;
import dev.amble.ait.core.AITItems;
import dev.amble.ait.core.engine.StructureHolder;
import dev.amble.ait.core.engine.SubSystem;
import dev.amble.ait.core.engine.block.multi.MultiBlockStructure;
import dev.amble.ait.core.item.RiftScannerItem;
import dev.amble.ait.core.tardis.handler.travel.TravelHandler;
import dev.amble.lib.data.CachedDirectedGlobalPos;
import net.minecraft.class_1792;
import net.minecraft.class_1923;
import net.minecraft.class_3532;

public class EmergencyPower
extends SubSystem
implements ArtronHolder,
StructureHolder {
    private double fuel;

    public EmergencyPower() {
        super(SubSystem.Id.EMERGENCY_POWER);
    }

    @Override
    public double getCurrentFuel() {
        return this.fuel;
    }

    @Override
    public void setCurrentFuel(double var) {
        this.fuel = class_3532.method_15350((double)var, (double)0.0, (double)this.getMaxFuel());
        this.sync();
    }

    @Override
    public double getMaxFuel() {
        return 1000.0;
    }

    public boolean hasBackupPower() {
        return this.getCurrentFuel() > 0.0 && this.isEnabled();
    }

    @Override
    public MultiBlockStructure getStructure() {
        return MultiBlockStructure.EMPTY;
    }

    @Override
    public class_1792 asItem() {
        return AITItems.BACKUP_CIRCUIT;
    }

    static {
        TardisEvents.USE_BACKUP_POWER.register((tdis, power) -> {
            tdis.alarm().enable();
            if (power > 200.0) {
                return;
            }
            TravelHandler travel = tdis.travel();
            RiftScannerItem.findNearestRift(travel.position().getWorld(), new class_1923(travel.position().getPos()), pos -> {
                travel.destination(CachedDirectedGlobalPos.create(travel.position().getWorld(), pos.method_33943(70), (byte)0));
                travel.autopilot(true);
                travel.dematerialize();
            });
        });
    }
}

