/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.engine.link.block;

import dev.amble.ait.api.tardis.link.v2.block.InteriorLinkableBlockEntity;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.engine.link.IFluidLink;
import dev.amble.ait.core.engine.link.IFluidSource;
import dev.amble.ait.core.engine.link.tracker.WorldFluidTracker;
import dev.amble.ait.core.util.SoundData;
import java.util.HashMap;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_5712;
import org.jetbrains.annotations.Nullable;

public abstract class FluidLinkBlockEntity
extends InteriorLinkableBlockEntity
implements IFluidLink {
    private boolean powered = false;
    private IFluidLink last;
    private IFluidSource source;
    private class_2338 lastPos;

    protected FluidLinkBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10556("HasFluid", this.powered);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        if (nbt.method_10545("HasFluid")) {
            this.powered = nbt.method_10577("HasFluid");
        }
    }

    @Override
    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    @Override
    public void onGainFluid() {
        if (this.method_11002() && this.getGainPowerSound() != null) {
            this.getGainPowerSound().play((class_3218)this.method_10997(), this.method_11016());
        }
    }

    @Override
    public void onLoseFluid() {
        if (this.method_11002() && this.getLosePowerSound() != null) {
            this.getLosePowerSound().play((class_3218)this.method_10997(), this.method_11016());
        }
    }

    protected SoundData getLosePowerSound() {
        return new SoundData(AITSounds.SLOT_IN, class_3419.field_15245, 0.1f, 0.75f);
    }

    protected SoundData getGainPowerSound() {
        return new SoundData(AITSounds.FLUID_LINK_CONNECT, class_3419.field_15245, 0.1f, 0.75f);
    }

    public boolean isPowered() {
        return this.powered;
    }

    private void updatePowered() {
        boolean before = this.powered;
        boolean bl = this.powered = this.source(true) != null && this.source(true).level() > 0.0;
        if (before != this.powered) {
            this.syncToWorld();
            if (this.powered) {
                this.onGainFluid();
            } else {
                this.onLoseFluid();
            }
        }
    }

    @Override
    public IFluidSource source(boolean search) {
        if (this.source == null && search) {
            if (this.last() != null) {
                this.setSource(this.last().source(true));
            } else if (this.method_11002()) {
                this.search(this.method_10997(), this.method_11016());
            }
        }
        return this.source;
    }

    public IFluidSource source() {
        return this.source(true);
    }

    @Override
    public void setSource(IFluidSource source) {
        this.source = source;
        this.syncToWorld();
    }

    @Override
    public IFluidLink last() {
        return this.last;
    }

    @Override
    public void setLast(IFluidLink last) {
        this.last = last;
    }

    public class_2338 getLastPos() {
        return this.lastPos;
    }

    public void setLastPos(class_2338 lastPos) {
        this.lastPos = lastPos;
    }

    public void onBroken(class_1937 world, class_2338 pos) {
        if (world.method_8608()) {
            return;
        }
        if (this.isPowered()) {
            this.onLoseFluid();
        }
        this.clear();
    }

    public void onPlaced(class_1937 world, class_2338 pos, @Nullable class_1309 placer) {
        if (world.method_8608()) {
            return;
        }
        this.search(world, pos);
        this.updatePowered();
    }

    private void search(class_1937 world, class_2338 pos) {
        HashMap<class_2350, IFluidLink> connections = WorldFluidTracker.getConnections((class_3218)world, pos, null);
        for (class_2350 dir : connections.keySet()) {
            class_2350 inferredDirection;
            IFluidLink i = connections.get(dir);
            if (i == this || this.isCircular(i) || (inferredDirection = this.getDirectionFromPositions(pos, pos.method_10093(dir))) != null && this.isParallel(inferredDirection, this.getDirectionFromPositions(pos, this.getLastPos())) || i == null || i.source(false) == null) continue;
            this.setLast(i);
            this.setLastPos(pos.method_10093(dir));
            if (!(i instanceof IFluidSource)) break;
            this.setSource((IFluidSource)i);
            break;
        }
    }

    private void clear(boolean sync) {
        this.setLast(null);
        this.setLastPos(null);
        this.setSource(null);
        if (sync) {
            this.syncToWorld();
        }
    }

    private void clear() {
        this.clear(true);
    }

    public void onNeighborUpdate(class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos) {
        IFluidLink link;
        if (world.method_8608()) {
            return;
        }
        if (this.last() == null && (link = WorldFluidTracker.query((class_3218)world, sourcePos)) != null && link.source(false) != null && !this.isCircular(link)) {
            class_2350 inferredDirection = this.getDirectionFromPositions(pos, sourcePos);
            if (inferredDirection != null && this.isParallel(inferredDirection, this.getDirectionFromPositions(pos, this.getLastPos()))) {
                return;
            }
            this.setLast(link);
            this.setLastPos(sourcePos);
            this.setSource(link.source(false));
        }
        if (sourcePos.equals((Object)this.getLastPos())) {
            this.onLastUpdate(world, pos);
        }
        this.updatePowered();
    }

    private void onLastUpdate(class_1937 world, class_2338 pos) {
        if (world.method_8320(this.getLastPos()).method_26215() || this.last != null && this.last.source(false) == null) {
            this.clear();
        }
    }

    private void syncToWorld() {
        if (!this.method_11002()) {
            return;
        }
        this.field_11863.method_43276(class_5712.field_28733, this.method_11016(), class_5712.class_7397.method_43287((class_2680)this.method_11010()));
        this.method_5431();
        this.method_10997().method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
        this.method_10997().method_8452(this.method_11016(), this.method_11010().method_26204());
        for (class_2350 dir : class_2350.values()) {
            class_2586 class_25862 = this.method_10997().method_8321(this.method_11016().method_10093(dir));
            if (!(class_25862 instanceof FluidLinkBlockEntity)) continue;
            FluidLinkBlockEntity be = (FluidLinkBlockEntity)class_25862;
            be.onNeighborUpdate(this.method_10997(), this.method_11016().method_10093(dir), null, this.method_11016());
        }
    }

    private boolean isCircular(IFluidLink link) {
        return false;
    }

    private class_2350 getDirectionFromPositions(class_2338 from, class_2338 to) {
        for (class_2350 direction : class_2350.values()) {
            if (!from.method_10093(direction).equals((Object)to)) continue;
            return direction;
        }
        return null;
    }

    private boolean isParallel(class_2350 dir1, class_2350 dir2) {
        return false;
    }
}

