/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.engine.link.tracker;

import dev.amble.ait.core.engine.link.IFluidLink;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public class WorldFluidTracker {
    public static HashMap<class_2350, IFluidLink> getConnections(class_3218 world, class_2338 pos, @Nullable class_2350 ignore) {
        HashMap<class_2350, IFluidLink> connections = new HashMap<class_2350, IFluidLink>();
        for (class_2350 dir : class_2350.values()) {
            IFluidLink found;
            if (dir == ignore || (found = WorldFluidTracker.query(world, pos.method_10093(dir))) == null) continue;
            connections.put(dir, found);
        }
        return connections;
    }

    public static LinkedList<IFluidLink> getAllConnections(class_3218 world, class_2338 pos, @Nullable class_2350 ignore, HashSet<class_2338> checkedPositions) {
        LinkedList<IFluidLink> list = new LinkedList<IFluidLink>();
        IFluidLink here = WorldFluidTracker.query(world, pos);
        if (here == null) {
            return list;
        }
        if (checkedPositions == null) {
            checkedPositions = new HashSet();
        }
        checkedPositions.add(pos);
        LinkedList<class_2338> toCheck = new LinkedList<class_2338>();
        toCheck.add(pos);
        while (!toCheck.isEmpty()) {
            class_2338 currentPos = (class_2338)toCheck.poll();
            HashMap<class_2350, IFluidLink> connections = WorldFluidTracker.getConnections(world, currentPos, ignore);
            for (class_2350 direction : connections.keySet()) {
                class_2338 newPos;
                if (direction == ignore || checkedPositions.contains(newPos = currentPos.method_10093(direction)) || !checkedPositions.add(newPos)) continue;
                toCheck.add(newPos);
                list.add(connections.get(direction));
            }
        }
        return list;
    }

    public static IFluidLink query(class_3218 world, class_2338 pos) {
        class_2586 be = world.method_8321(pos);
        if (be instanceof IFluidLink) {
            IFluidLink link = (IFluidLink)be;
            if (!be.method_11015()) {
                return link;
            }
        }
        return null;
    }
}

