/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.engine.registry;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import dev.amble.ait.AITMod;
import dev.amble.ait.core.engine.SubSystem;
import dev.amble.lib.register.Registry;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public class SubSystemRegistry
implements Registry {
    private static final SubSystemRegistry instance = new SubSystemRegistry();
    private final Map<String, SubSystem.IdLike> REGISTRY = new HashMap<String, SubSystem.IdLike>();
    private SubSystem.IdLike[] LOOKUP;
    private boolean frozen = false;

    public void register(SubSystem.IdLike id) {
        if (!id.creatable()) {
            return;
        }
        id.index(this.REGISTRY.size());
        this.REGISTRY.put(id.name(), id);
        if (this.frozen) {
            AITMod.LOGGER.error("Tried to init a component id after the registry got frozen: {}", (Object)id);
        }
    }

    public void register(SubSystem.IdLike[] idLikes) {
        for (SubSystem.IdLike idLike : idLikes) {
            this.register(idLike);
        }
    }

    public void onCommonInit() {
        this.register(SubSystem.Id.ids());
        this.LOOKUP = new SubSystem.IdLike[this.REGISTRY.size()];
        this.REGISTRY.forEach((name, idLike) -> {
            this.LOOKUP[idLike.index()] = idLike;
        });
        this.frozen = true;
    }

    public void fill(Consumer<SubSystem> consumer) {
        for (SubSystem.IdLike id : this.LOOKUP) {
            consumer.accept(id.create());
        }
    }

    public SubSystem.IdLike get(String name) {
        return this.REGISTRY.get(name);
    }

    public String get(SubSystem component) {
        return component.getId().name();
    }

    public SubSystem.IdLike get(int index) {
        return this.LOOKUP[index];
    }

    public static SubSystem.IdLike[] values() {
        return SubSystemRegistry.instance.LOOKUP;
    }

    public Collection<SubSystem.IdLike> getValues() {
        return this.REGISTRY.values();
    }

    public static SubSystemRegistry getInstance() {
        return instance;
    }

    public static Object idSerializer() {
        return new Serializer();
    }

    private static class Serializer
    implements JsonSerializer<SubSystem.IdLike>,
    JsonDeserializer<SubSystem.IdLike> {
        private Serializer() {
        }

        public SubSystem.IdLike deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return SubSystemRegistry.getInstance().get(json.getAsString());
        }

        public JsonElement serialize(SubSystem.IdLike src, Type typeOfSrc, JsonSerializationContext context) {
            return context.serialize((Object)src.name());
        }
    }
}

