/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.entities;

import dev.amble.ait.client.tardis.ClientTardis;
import dev.amble.ait.core.AITBlocks;
import dev.amble.ait.core.AITDamageTypes;
import dev.amble.ait.core.AITEntityTypes;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.blockentities.ExteriorBlockEntity;
import dev.amble.ait.core.blocks.ExteriorBlock;
import dev.amble.ait.core.entities.base.LinkableDummyEntity;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.handler.travel.TravelHandler;
import dev.amble.ait.core.tardis.util.TardisUtil;
import dev.amble.ait.module.planet.core.space.planet.Planet;
import dev.amble.ait.module.planet.core.space.planet.PlanetRegistry;
import dev.amble.ait.module.planet.core.util.ISpaceImmune;
import java.util.function.Predicate;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1313;
import net.minecraft.class_1606;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3612;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class FallingTardisEntity
extends LinkableDummyEntity
implements ISpaceImmune {
    private static final int HURT_MAX = 100;
    private static final float HURT_AMOUNT = 40.0f;
    public int timeFalling;
    @Nullable
    public class_2487 blockEntityData;
    private class_2680 state;

    public FallingTardisEntity(class_1299<? extends class_1297> entityType, class_1937 world) {
        super(entityType, world);
    }

    private FallingTardisEntity(class_1937 world, class_243 pos, class_2680 state, Tardis tardis) {
        super(AITEntityTypes.FALLING_TARDIS_TYPE, world);
        this.field_23807 = true;
        this.state = state;
        this.link(tardis);
        this.method_33574(pos.method_1023(0.0, 0.5, 0.0));
        this.method_18799(class_243.field_1353);
    }

    public static void spawnFromBlock(class_1937 world, class_2338 pos, class_2680 state) {
        class_2586 class_25862 = world.method_8321(pos);
        if (!(class_25862 instanceof ExteriorBlockEntity)) {
            return;
        }
        ExteriorBlockEntity exterior = (ExteriorBlockEntity)class_25862;
        Tardis tardis = exterior.tardis().get();
        FallingTardisEntity fallingBlockEntity = new FallingTardisEntity(world, pos.method_46558(), state.method_28498((class_2769)class_2741.field_12508) ? (class_2680)state.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false)) : state, tardis);
        world.method_8652(pos, state.method_26227().method_15759(), 3);
        world.method_8649((class_1297)fallingBlockEntity);
    }

    protected class_1297.class_5799 method_33570() {
        return class_1297.class_5799.field_28630;
    }

    protected void method_5825() {
        this.stopFalling(true);
    }

    public void method_5773() {
        boolean cannotFall;
        ++this.timeFalling;
        if (!this.method_5740()) {
            this.method_18799(this.method_18798().method_1031(0.0, -0.04, 0.0));
        }
        this.method_5784(class_1313.field_6308, this.method_18798());
        if (!this.isLinked()) {
            return;
        }
        Tardis tardis = this.tardis().get();
        this.method_18799(this.method_18798().method_1021(tardis.travel().isCrashing() ? (double)1.05f : (double)0.98f));
        if (this.method_23318() <= (double)this.method_37908().method_31607() + 2.0) {
            this.method_5825();
        }
        if (this.method_37908().method_8608()) {
            return;
        }
        if (this.timeFalling % 20 == 0) {
            tardis.getDesktop().getConsolePos().forEach(console -> this.method_37908().method_8396(null, console, class_3417.field_14572, class_3419.field_15245, 0.25f, 1.0f));
        }
        Planet planet = PlanetRegistry.getInstance().get(this.method_37908());
        boolean bl = cannotFall = (Boolean)this.tardis().get().travel().antigravs().get() != false || planet != null && planet.zeroGravity();
        if (cannotFall) {
            this.stopFalling(true);
            return;
        }
        class_2338 blockPos = this.method_24515();
        if (blockPos == null) {
            return;
        }
        if (this.method_37908().method_8321(blockPos) instanceof ExteriorBlockEntity) {
            this.method_33574(blockPos.method_46558().method_1031(0.0, 2.0, 0.0));
            this.stopFalling(false);
            return;
        }
        tardis.travel().forcePosition(cached -> cached.pos(blockPos).world(this.method_37908().method_27983()));
        if (this.method_24828()) {
            this.stopFalling(false);
        }
    }

    public void stopFalling(boolean antigravs) {
        Tardis tardis = this.tardis().get();
        TravelHandler travel = tardis.travel();
        if (tardis instanceof ClientTardis) {
            return;
        }
        if (antigravs) {
            travel.antigravs().set(true);
        }
        class_2248 block = this.state.method_26204();
        class_2338 blockPos = this.method_24515();
        boolean isCrashing = travel.isCrashing();
        tardis.asServer().world().method_18456().forEach(player -> {
            class_3414 sound = isCrashing ? class_3417.field_15152 : AITSounds.LAND_CRASH;
            float volume = isCrashing ? 1.0f : 3.0f;
            player.method_5783(sound, volume, 1.0f);
        });
        if (isCrashing) {
            this.method_37908().method_46407((class_1297)this, null, TardisUtil.EXPLOSION_BEHAVIOR, this.method_19538(), 10.0f, TardisUtil.doCreateFire(this.method_37908()), class_1937.class_7867.field_40891);
            travel.setCrashing(false);
        }
        if (this.state.method_28498((class_2769)class_2741.field_12508) && this.method_37908().method_8316(blockPos).method_15772() == class_3612.field_15910) {
            this.state = (class_2680)this.state.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true));
        }
        if (block instanceof ExteriorBlock) {
            ExteriorBlock exterior = (ExteriorBlock)block;
            exterior.onLanding(tardis, (class_3218)this.method_37908(), blockPos);
        }
        travel.placeExterior(false);
        this.method_31472();
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        int i = class_3532.method_15386((float)(fallDistance - 1.0f));
        if (i >= 0) {
            Predicate predicate = class_1301.field_6156.and(class_1301.field_6157);
            class_1282 damageSource2 = AITDamageTypes.of(this.method_37908(), AITDamageTypes.TARDIS_SQUASH_DAMAGE_TYPE);
            float f = Math.min(class_3532.method_15375((float)((float)i * 40.0f)), 100);
            this.method_37908().method_8333((class_1297)this, this.method_5829(), predicate).forEach(entity -> {
                if (entity instanceof class_1606) {
                    class_1606 shulker = (class_1606)entity;
                    shulker.method_5768();
                }
                entity.method_5643(damageSource2, f);
            });
        }
        return false;
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10566("BlockState", (class_2520)class_2512.method_10686((class_2680)this.state));
        nbt.method_10569("Time", this.timeFalling);
        if (this.blockEntityData != null) {
            nbt.method_10566("TileEntityData", (class_2520)this.blockEntityData);
        }
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.state = class_2512.method_10681((class_7871)this.method_37908().method_45448(class_7924.field_41254), (class_2487)nbt.method_10562("BlockState"));
        this.timeFalling = nbt.method_10550("Time");
        if (nbt.method_10573("TileEntityData", 10)) {
            this.blockEntityData = nbt.method_10562("TileEntityData");
        }
        if (this.state.method_26215()) {
            this.state = AITBlocks.EXTERIOR_BLOCK.method_9564();
        }
    }

    public class_2680 getBlockState() {
        return this.state;
    }

    protected class_2561 method_23315() {
        return class_2561.method_43469((String)"entity.minecraft.falling_block_type", (Object[])new Object[]{AITBlocks.EXTERIOR_BLOCK.method_9518()});
    }

    public boolean method_5833() {
        return true;
    }

    @Override
    public boolean method_5740() {
        return false;
    }

    public class_2596<class_2602> method_18002() {
        return new class_2604((class_1297)this, class_2248.method_9507((class_2680)this.getBlockState()));
    }

    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        this.state = class_2248.method_9531((int)packet.method_11166());
        this.field_23807 = true;
        double d = packet.method_11175();
        double e = packet.method_11174();
        double f = packet.method_11176();
        this.method_5814(d, e, f);
    }
}

