/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.entities;

import dev.amble.ait.AITMod;
import dev.amble.ait.core.AITBlocks;
import dev.amble.ait.core.AITEntityTypes;
import dev.amble.ait.core.AITItems;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.AITTags;
import dev.amble.ait.core.advancement.TardisCriterions;
import dev.amble.ait.core.entities.base.DummyAmbientEntity;
import dev.amble.ait.core.item.SonicItem;
import dev.amble.ait.core.util.StackUtil;
import dev.amble.ait.core.util.TagsUtil;
import dev.amble.ait.core.util.WorldUtil;
import dev.amble.ait.core.world.RiftChunkManager;
import dev.amble.ait.module.planet.core.util.ISpaceImmune;
import dev.amble.lib.util.TeleportUtil;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2482;
import net.minecraft.class_2510;
import net.minecraft.class_2604;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_2778;
import net.minecraft.class_2791;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import net.minecraft.class_5819;

public class RiftEntity
extends DummyAmbientEntity
implements ISpaceImmune {
    private int interactAmount = 0;
    private int ambientSoundCooldown = 0;
    private int currentSoundIndex = 0;
    private static final class_3414[] RIFT_SOUNDS = new class_3414[]{AITSounds.RIFT1_AMBIENT, AITSounds.RIFT2_AMBIENT, AITSounds.RIFT3_AMBIENT};
    private static final int[] RIFT_DURATIONS = new int[]{300, 260, 280};

    public RiftEntity(class_1299<?> type, class_1937 world) {
        super(AITEntityTypes.RIFT_ENTITY, world);
    }

    public void method_5694(class_1657 player) {
        if (player.method_5829().method_994(this.method_5829().method_1002(0.5, 0.5, 0.5))) {
            if (WorldUtil.getTimeVortex() == null) {
                return;
            }
            TeleportUtil.teleport((class_1309)player, (class_3218)WorldUtil.getTimeVortex(), (class_243)player.method_19538(), (float)player.field_6283);
        }
    }

    public final class_1269 method_5992(class_1657 player, class_1268 hand) {
        if (this.method_37908().method_8608()) {
            return class_1269.field_5812;
        }
        class_1799 stack = player.method_5998(hand);
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof SonicItem) {
            SonicItem sonic = (SonicItem)class_17922;
            if (!this.method_37908().method_8608()) {
                sonic.addFuel(1000.0, stack);
                this.method_37908().method_8396(null, this.method_24515(), AITSounds.RIFT_SONIC, class_3419.field_15256, 1.0f, 1.0f);
                StackUtil.spawn(this.method_37908(), this.method_24515(), new class_1799((class_1935)AITItems.CORAL_FRAGMENT));
                this.method_31472();
            }
            return class_1269.field_5812;
        }
        ++this.interactAmount;
        if (this.interactAmount == 1) {
            TardisCriterions.FIRST_RIFT.trigger((class_3222)player);
        }
        if (this.interactAmount >= 3) {
            boolean gotFragment = this.method_37908().method_8409().method_43056();
            player.method_5643(this.method_37908().method_48963().method_48820(), 7.0f);
            if (gotFragment) {
                randomItem = TagsUtil.getRandomItemFromTag(this.method_37908(), AITTags.Items.RIFT_SUCCESS_EXTRA_ITEM);
                StackUtil.spawn(this.method_37908(), this.method_24515(), new class_1799((class_1935)AITItems.CORAL_FRAGMENT));
                StackUtil.spawn(this.method_37908(), this.method_24515(), new class_1799((class_1935)randomItem));
                this.method_37908().method_8396(null, player.method_24515(), AITSounds.RIFT_SUCCESS, class_3419.field_15256, 1.0f, 1.0f);
            } else {
                randomItem = TagsUtil.getRandomItemFromTag(this.method_37908(), AITTags.Items.RIFT_FAIL_ITEM);
                StackUtil.spawn(this.method_37908(), this.method_24515(), new class_1799((class_1935)randomItem));
                this.method_37908().method_8396(null, this.method_24515(), AITSounds.RIFT_FAIL, class_3419.field_15256, 1.0f, 1.0f);
                this.spreadTardisCoral(this.method_37908(), this.method_24515());
            }
            this.method_31472();
            return gotFragment ? class_1269.field_5812 : class_1269.field_5814;
        }
        return class_1269.field_21466;
    }

    private void spreadTardisCoral(class_1937 world, class_2338 pos) {
        int radius = 4;
        class_2791 chunk = world.method_22350(pos);
        for (class_2338 targetPos : class_2338.method_10097((class_2338)pos.method_10069(-radius, 0, -radius), (class_2338)pos.method_10069(radius, 0, radius))) {
            class_2680 currentState;
            class_2680 newState;
            if (world.field_9229.method_39332(0, 10) >= 3 || (newState = this.getReplacementBlock(currentState = world.method_8320(targetPos = targetPos.method_33096(chunk.method_12005(class_2902.class_2903.field_13203, targetPos.method_10263() & 0xF, targetPos.method_10260() & 0xF))))) == null) continue;
            world.method_8652(targetPos, newState, 3);
            world.method_8406((class_2394)AITMod.CORAL_PARTICLE, (double)targetPos.method_10263() + 0.5, (double)targetPos.method_10264() + 0.5, (double)targetPos.method_10260() + 0.5, 0.0, 0.0, 0.0);
            if (!newState.method_27852(AITBlocks.TARDIS_CORAL_BLOCK)) continue;
            this.placeCoralFans(world, targetPos);
        }
    }

    private class_2680 getReplacementBlock(class_2680 currentState) {
        class_2248 block = currentState.method_26204();
        if (block instanceof class_2482) {
            return (class_2680)AITBlocks.TARDIS_CORAL_SLAB.method_9564().method_11657((class_2769)class_2741.field_12485, (Comparable)((class_2771)currentState.method_11654((class_2769)class_2741.field_12485)));
        }
        if (block instanceof class_2510) {
            return (class_2680)((class_2680)((class_2680)AITBlocks.TARDIS_CORAL_STAIRS.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)((class_2350)currentState.method_11654((class_2769)class_2741.field_12481)))).method_11657((class_2769)class_2741.field_12485, (Comparable)((class_2771)currentState.method_11654((class_2769)class_2741.field_12485)))).method_11657((class_2769)class_2741.field_12503, (Comparable)((class_2778)currentState.method_11654((class_2769)class_2741.field_12503)));
        }
        if (this.canTransform(block)) {
            return AITBlocks.TARDIS_CORAL_BLOCK.method_9564();
        }
        return null;
    }

    private boolean canTransform(class_2248 block) {
        return block == class_2246.field_10340 || block == class_2246.field_10566 || block == class_2246.field_10219 || block == class_2246.field_10102 || block == class_2246.field_28888;
    }

    private void placeCoralFans(class_1937 world, class_2338 pos) {
        for (class_2350 dir : class_2350.values()) {
            class_2338 adjacent = pos.method_10093(dir);
            if (!world.method_8320(adjacent).method_26215() || !this.isCoralBlock(world.method_8320(pos))) continue;
            world.method_8652(adjacent, (class_2680)((class_2680)AITBlocks.TARDIS_CORAL_FAN.method_9564().method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)class_2741.field_12525, (Comparable)dir), 3);
        }
    }

    private boolean isCoralBlock(class_2680 state) {
        return state.method_27852(AITBlocks.TARDIS_CORAL_BLOCK);
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().method_8608()) {
            if (this.ambientSoundCooldown > 0) {
                --this.ambientSoundCooldown;
            } else {
                this.method_37908().method_8396(null, this.method_24515(), RIFT_SOUNDS[this.currentSoundIndex], class_3419.field_15256, 1.0f, 1.0f);
                this.ambientSoundCooldown = RIFT_DURATIONS[this.currentSoundIndex];
                this.currentSoundIndex = (this.currentSoundIndex + 1) % RIFT_SOUNDS.length;
            }
        }
    }

    public static boolean canSpawn(class_1299<RiftEntity> rift, class_5425 serverWorldAccess, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        class_2338 endPos;
        boolean canSpawn;
        if (!(serverWorldAccess instanceof class_5281)) {
            return false;
        }
        class_5281 worldAccess = (class_5281)serverWorldAccess;
        if (!WorldUtil.canRiftsSpawn(serverWorldAccess.method_8410())) {
            return false;
        }
        boolean bl = canSpawn = spawnReason == class_3730.field_16474 || random.method_43056() && random.method_43056() && RiftChunkManager.isRiftChunk(worldAccess, pos);
        if (!canSpawn) {
            return false;
        }
        class_2791 chunk = worldAccess.method_22350(pos);
        class_1923 chunkPos = chunk.method_12004();
        class_2338 startPos = new class_2338(chunkPos.method_8326(), chunk.method_31607(), chunkPos.method_8328());
        class_238 box = new class_238(startPos, endPos = new class_2338(chunkPos.method_8327(), worldAccess.method_31605(), chunkPos.method_8329()));
        if (serverWorldAccess.method_18023(rift, box, predicate -> true).isEmpty()) {
            return worldAccess.method_8320(pos).method_26215() && worldAccess.method_8320(pos.method_10074()).method_26215();
        }
        return false;
    }

    public void method_31471(class_2604 packet) {
        double d = packet.method_11175();
        double e = packet.method_11174();
        double f = packet.method_11176();
        float g = packet.method_11168();
        float h = packet.method_11171();
        this.method_43391(d, e, f);
        this.field_6283 = packet.method_43233();
        this.field_6241 = packet.method_43233();
        this.field_6220 = this.field_6283;
        this.field_6259 = this.field_6241;
        this.method_5838(packet.method_11167());
        this.method_5826(packet.method_11164());
        this.method_5641(d, e, f, g, h);
        this.method_18800(packet.method_11170(), packet.method_11172(), packet.method_11173());
        this.method_30634(d, e, f);
    }
}

