/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.item;

import dev.amble.ait.core.world.RiftChunkManager;
import dev.amble.ait.core.world.TardisServerWorld;
import java.util.function.Consumer;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3218;

public class RiftScannerItem
extends class_1792 {
    private static final int MAX_ITERATIONS = 32;

    public RiftScannerItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (!(world instanceof class_3218)) {
            return class_1271.method_22430((Object)user.method_5998(hand));
        }
        class_3218 serverWorld = (class_3218)world;
        if (TardisServerWorld.isTardisDimension(serverWorld)) {
            return class_1271.method_22431((Object)user.method_5998(hand));
        }
        user.method_7357().method_7906((class_1792)this, 100);
        RiftScannerItem.findNearestRift(serverWorld, new class_1923(user.method_24515()), chunk -> RiftScannerItem.setTarget(user.method_5998(hand), chunk));
        user.method_7353((class_2561)class_2561.method_43471((String)"riftchunk.ait.tracking"), true);
        return class_1271.method_22427((Object)user.method_5998(hand));
    }

    public static void findNearestRift(class_3218 world, class_1923 source, Consumer<class_1923> found) {
        int steps = 1;
        RiftChunkManager manager = RiftChunkManager.getInstance(world);
        for (int i = 0; i < 32; ++i) {
            if (steps % 2 != 0) {
                if (RiftScannerItem.trySearch(manager, steps, source, class_2350.field_11034, found)) {
                    return;
                }
                if (RiftScannerItem.trySearch(manager, steps, source, class_2350.field_11035, found)) {
                    return;
                }
            } else {
                if (RiftScannerItem.trySearch(manager, steps, source, class_2350.field_11039, found)) {
                    return;
                }
                if (RiftScannerItem.trySearch(manager, steps, source, class_2350.field_11043, found)) {
                    return;
                }
            }
            ++steps;
        }
    }

    private static boolean trySearch(RiftChunkManager manager, int limit, class_1923 source, class_2350 direction, Consumer<class_1923> found) {
        for (int b = 0; b <= limit; ++b) {
            if (!RiftScannerItem.isConsumable(manager, source = RiftScannerItem.getChunkInDirection(source, direction))) continue;
            found.accept(source);
            return true;
        }
        return false;
    }

    private static boolean isConsumable(RiftChunkManager manager, class_1923 pos) {
        return manager.isRiftChunk(pos) && manager.getArtron(pos) >= 250.0;
    }

    private static class_1923 getChunkInDirection(class_1923 pos, class_2350 dir) {
        return new class_1923(pos.field_9181 + dir.method_10148(), pos.field_9180 + dir.method_10165());
    }

    private static void setTarget(class_1799 stack, class_1923 pos) {
        class_2487 nbt = stack.method_7948();
        nbt.method_10569("X", pos.field_9181);
        nbt.method_10569("Z", pos.field_9180);
    }

    public static class_1923 getTarget(class_1799 stack) {
        class_2487 nbt = stack.method_7948();
        if (!nbt.method_10545("X") || !nbt.method_10545("Z")) {
            return class_1923.field_35107;
        }
        return new class_1923(nbt.method_10550("X"), nbt.method_10550("Z"));
    }
}

