/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.item;

import dev.amble.ait.api.AITUseActions;
import dev.amble.ait.api.ArtronHolderItem;
import dev.amble.ait.api.tardis.link.LinkableItem;
import dev.amble.ait.client.sounds.ClientSoundManager;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.item.sonic.SonicMode;
import dev.amble.ait.data.schema.sonic.SonicSchema;
import dev.amble.ait.registry.impl.SonicRegistry;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import net.minecraft.class_742;
import org.jetbrains.annotations.Nullable;

public class SonicItem
extends LinkableItem
implements ArtronHolderItem {
    public static final double MAX_FUEL = 1000.0;
    public static final String MODE_KEY = "mode";
    public static final String SONIC_TYPE = "sonic_type";
    private static final class_2561 TEXT_MODE = class_2561.method_43471((String)"message.ait.sonic.mode");
    private static final class_2561 TEXT_ARTRON = class_2561.method_43471((String)"message.ait.tooltips.artron_units").method_27692(class_124.field_1078);
    private static final class_2561 TEXT_CASING = class_2561.method_43471((String)"message.ait.sonic.currenttype").method_27695(new class_124[]{class_124.field_1063, class_124.field_1056});

    public SonicItem(class_1792.class_1793 settings) {
        super(settings, true);
    }

    public class_1799 method_7854() {
        class_1799 stack = new class_1799((class_1935)this);
        class_2487 nbt = stack.method_7948();
        nbt.method_10569(MODE_KEY, -1);
        nbt.method_10549("fuel", this.getMaxFuel(stack));
        if (SonicRegistry.DEFAULT != null) {
            nbt.method_10582(SONIC_TYPE, SonicRegistry.DEFAULT.id().toString());
        }
        return stack;
    }

    public class_1839 method_7853(class_1799 stack) {
        return AITUseActions.SONIC;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        SonicMode mode = SonicItem.mode(stack);
        if (mode == null) {
            return class_1271.method_22431((Object)stack);
        }
        if (!this.checkFuel(stack)) {
            return class_1271.method_22431((Object)stack);
        }
        if (user.method_5715()) {
            mode = mode.next();
            SonicItem.setMode(stack, mode);
            world.method_8396(user, user.method_24515(), AITSounds.SONIC_SWITCH, class_3419.field_15248, 1.0f, 1.0f);
            user.method_7353(mode.text(), true);
            return class_1271.method_22428((Object)stack);
        }
        if (mode.startUsing(stack, world, user, hand)) {
            user.method_6019(hand);
            return class_1271.method_22428((Object)stack);
        }
        return class_1271.method_22431((Object)stack);
    }

    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        int ticks;
        SonicMode mode = SonicItem.mode(stack);
        if (mode == SonicMode.Modes.INACTIVE) {
            return;
        }
        if (world.method_8608()) {
            ClientSoundManager.getSonicSound().onUse((class_742)user);
        }
        if ((ticks = mode.maxTime() - remainingUseTicks) % 10 == 0) {
            this.removeFuel(mode.fuelCost(), stack);
            if (!this.checkFuel(stack)) {
                return;
            }
        }
        mode.tick(stack, world, user, ticks, remainingUseTicks);
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        SonicMode mode = SonicItem.mode(stack);
        if (mode == SonicMode.Modes.INACTIVE) {
            return;
        }
        if (world.method_8608()) {
            ClientSoundManager.getSonicSound().onFinishUse((class_742)user);
        }
        mode.stopUsing(stack, world, user, mode.maxTime() - remainingUseTicks, remainingUseTicks);
    }

    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 user) {
        SonicMode mode = SonicItem.mode(stack);
        if (mode == SonicMode.Modes.INACTIVE) {
            return stack;
        }
        if (world.method_8608()) {
            ClientSoundManager.getSonicSound().onFinishUse((class_742)user);
        }
        mode.finishUsing(stack, world, user);
        return stack;
    }

    public int method_7881(class_1799 stack) {
        return SonicItem.mode(stack).maxTime();
    }

    private boolean checkFuel(class_1799 stack) {
        SonicMode mode = SonicItem.mode(stack);
        if (this.isOutOfFuel(stack) && mode != SonicMode.Modes.INACTIVE) {
            mode = SonicMode.Modes.INACTIVE;
            SonicItem.setMode(stack, mode);
            return false;
        }
        return true;
    }

    @Override
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        tooltip.add((class_2561)TEXT_MODE.method_27661().method_10852(SonicItem.mode(stack).text()));
        int fuel = (int)Math.round(this.getCurrentFuel(stack));
        boolean acceptableFuel = this.getCurrentFuel(stack) > this.getMaxFuel(stack) / 4.0;
        tooltip.add((class_2561)TEXT_ARTRON.method_27661().method_10852((class_2561)class_2561.method_43470((String)String.valueOf(fuel)).method_27692(acceptableFuel ? class_124.field_1060 : class_124.field_1061)));
        tooltip.add((class_2561)TEXT_CASING.method_27661().method_27693(SonicItem.schema(stack).name()));
        super.method_7851(stack, world, tooltip, context);
    }

    public static SonicMode mode(class_1799 stack) {
        class_2487 nbtCompound = stack.method_7948();
        return SonicMode.Modes.getAndWrap(nbtCompound.method_10550(MODE_KEY));
    }

    public static void setMode(class_1799 stack, SonicMode mode) {
        class_2487 nbtCompound = stack.method_7948();
        nbtCompound.method_10569(MODE_KEY, mode.index());
    }

    public static SonicSchema schema(class_1799 stack) {
        class_2487 nbt = stack.method_7948();
        String rawId = nbt.method_10558(SONIC_TYPE);
        if (rawId == null) {
            return SonicRegistry.DEFAULT;
        }
        class_2960 id = class_2960.method_12829((String)rawId);
        SonicSchema schema = (SonicSchema)SonicRegistry.getInstance().get(id);
        return schema == null ? SonicRegistry.DEFAULT : schema;
    }

    public static void setSchema(class_1799 stack, class_2960 id) {
        class_2487 nbt = stack.method_7948();
        nbt.method_10582(SONIC_TYPE, id.toString());
    }

    public static void setSchema(class_1799 stack, SonicSchema schema) {
        SonicItem.setSchema(stack, schema.id());
    }

    @Override
    public double getMaxFuel(class_1799 stack) {
        return 1000.0;
    }

    public static boolean isBeingUsed(class_1657 player, class_1799 stack) {
        return player.method_6115() && player.method_6030() == stack;
    }
}

