/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.item;

import dev.amble.ait.api.tardis.TardisComponent;
import dev.amble.ait.core.blockentities.ConsoleBlockEntity;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.control.impl.DirectionControl;
import dev.amble.ait.core.tardis.handler.SubSystemHandler;
import dev.amble.ait.core.tardis.handler.travel.TravelHandlerBase;
import dev.amble.ait.core.tardis.manager.ServerTardisManager;
import dev.amble.ait.core.tardis.manager.TardisBuilder;
import dev.amble.ait.core.tardis.util.DefaultThemes;
import dev.amble.ait.data.Loyalty;
import dev.amble.ait.data.schema.desktop.TardisDesktopSchema;
import dev.amble.ait.data.schema.exterior.ExteriorVariantSchema;
import dev.amble.ait.registry.impl.DesktopRegistry;
import dev.amble.ait.registry.impl.exterior.ExteriorVariantRegistry;
import dev.amble.lib.data.CachedDirectedGlobalPos;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7718;

public class TardisItemBuilder
extends class_1792 {
    private final class_2960 exterior;
    private final class_2960 desktop;

    public TardisItemBuilder(class_1792.class_1793 settings, class_2960 exterior, class_2960 desktopId) {
        super(settings);
        this.exterior = exterior;
        this.desktop = desktopId;
    }

    public TardisItemBuilder(class_1792.class_1793 settings, class_2960 exterior) {
        this(settings, exterior, null);
    }

    public TardisItemBuilder(class_1792.class_1793 settings) {
        this(settings, null);
    }

    public class_1269 method_7884(class_1838 context) {
        class_1937 world = context.method_8045();
        class_1657 player = context.method_8036();
        if (!(player instanceof class_3222)) {
            return class_1269.field_5811;
        }
        class_3222 serverPlayer = (class_3222)player;
        if (!(world instanceof class_3218)) {
            return class_1269.field_5811;
        }
        class_3218 serverWorld = (class_3218)world;
        if (player.method_7357().method_7904((class_1792)this)) {
            return class_1269.field_5814;
        }
        if (context.method_20287() != class_1268.field_5808) {
            return class_1269.field_5812;
        }
        CachedDirectedGlobalPos pos = CachedDirectedGlobalPos.create(serverWorld, serverWorld.method_8320(context.method_8037()).method_45474() ? context.method_8037() : context.method_8037().method_10084(), DirectionControl.getGeneralizedRotation(class_7718.method_45479((float)player.method_43078())));
        class_2586 entity = world.method_8321(context.method_8037());
        if (entity instanceof ConsoleBlockEntity) {
            ConsoleBlockEntity consoleBlock = (ConsoleBlockEntity)entity;
            Tardis tardis = consoleBlock.tardis().get();
            if (tardis == null) {
                return class_1269.field_5814;
            }
            TravelHandlerBase.State state = tardis.travel().getState();
            if (state != TravelHandlerBase.State.LANDED && state != TravelHandlerBase.State.FLIGHT) {
                return class_1269.field_5811;
            }
            consoleBlock.killControls();
            world.method_8650(context.method_8037(), false);
            world.method_8544(context.method_8037());
            return class_1269.field_5812;
        }
        TardisBuilder builder = new TardisBuilder().at(pos).owner(serverPlayer).with(TardisComponent.Id.FUEL, fuel -> {
            fuel.setCurrentFuel(fuel.getMaxFuel());
            fuel.enablePower();
        }).with(TardisComponent.Id.SUBSYSTEM, SubSystemHandler::repairAll).with(TardisComponent.Id.LOYALTY, loyalty -> {
            loyalty.setMessageEnabled(false);
            loyalty.set(serverPlayer, new Loyalty(Loyalty.Type.OWNER));
            loyalty.setMessageEnabled(true);
        });
        if (this.exterior == null || this.desktop == null) {
            DefaultThemes.getRandom().apply(builder);
        } else {
            builder.exterior((ExteriorVariantSchema)ExteriorVariantRegistry.getInstance().get(this.exterior));
            builder.desktop((TardisDesktopSchema)DesktopRegistry.getInstance().get(this.desktop));
        }
        ServerTardis created = ServerTardisManager.getInstance().create(builder);
        player.method_7353((class_2561)class_2561.method_43469((String)"message.ait.unlocked_all", (Object[])new Object[]{class_2561.method_43471((String)"message.ait.all_types").method_27692(class_124.field_1060)}).method_27692(class_124.field_1068), false);
        if (created == null) {
            player.method_7353((class_2561)class_2561.method_43471((String)"message.ait.max_tardises"), true);
            return class_1269.field_5814;
        }
        context.method_8041().method_7934(1);
        player.method_7357().method_7906((class_1792)this, 20);
        return class_1269.field_5812;
    }
}

