/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.item.blueprint;

import dev.amble.ait.core.item.blueprint.BlueprintRegistry;
import dev.amble.ait.core.item.blueprint.BlueprintSchema;
import dev.amble.ait.core.util.StackUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;

public class Blueprint {
    private final BlueprintSchema source;
    private final List<class_1799> requirements;
    private final List<class_1799> initialRequirements;

    public Blueprint(BlueprintSchema source) {
        this.source = source;
        this.initialRequirements = source.inputs().toStacks();
        this.requirements = StackUtil.cloneList(this.initialRequirements);
    }

    public Blueprint(class_2487 nbt) {
        this((BlueprintSchema)BlueprintRegistry.getInstance().get(new class_2960(nbt.method_10558("id"))));
        this.requirements.clear();
        this.fromNbt(nbt);
    }

    public boolean tryAdd(class_1799 stack) {
        for (class_1799 requirement : this.requirements) {
            if (!class_1799.method_7984((class_1799)requirement, (class_1799)stack)) continue;
            int deducted = Math.min(requirement.method_7947(), stack.method_7947());
            requirement.method_7934(deducted);
            stack.method_7934(deducted);
            if (requirement.method_7960()) {
                this.requirements.remove(requirement);
            }
            return true;
        }
        return false;
    }

    public int getCountLeftFor(class_1799 stack) {
        for (class_1799 requirement : this.requirements) {
            if (!class_1799.method_7984((class_1799)requirement, (class_1799)stack)) continue;
            return requirement.method_7947();
        }
        return 0;
    }

    public boolean isComplete() {
        return this.requirements.isEmpty();
    }

    public class_1799 getOutput() {
        return this.source.output().method_7972();
    }

    public Optional<class_1799> tryCraft() {
        if (!this.isComplete()) {
            return Optional.empty();
        }
        return Optional.of(this.getOutput());
    }

    public List<class_1799> getRequirements() {
        return this.requirements;
    }

    public List<class_1799> getInsertedItems() {
        ArrayList<class_1799> inserted = new ArrayList<class_1799>(this.initialRequirements);
        for (class_1799 j : this.requirements) {
            inserted.stream().filter(i -> class_1799.method_7984((class_1799)i, (class_1799)j)).forEach(i -> i.method_7934(j.method_7947()));
        }
        return inserted;
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        nbt.method_10582("id", this.source.id().toString());
        class_2499 list = new class_2499();
        for (class_1799 stack : this.requirements) {
            list.add((Object)stack.method_7953(new class_2487()));
        }
        nbt.method_10566("requirements", (class_2520)list);
        return nbt;
    }

    protected class_2487 fromNbt(class_2487 nbt) {
        class_2499 list = nbt.method_10554("requirements", 10);
        for (int i = 0; i < list.size(); ++i) {
            this.requirements.add(class_1799.method_7915((class_2487)list.method_10602(i)));
        }
        return nbt;
    }

    public BlueprintSchema getSource() {
        return this.source;
    }
}

