/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.item.blueprint;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.amble.ait.AITMod;
import dev.amble.ait.core.item.blueprint.Blueprint;
import dev.amble.lib.api.Identifiable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_7923;

public record BlueprintSchema(class_2960 id, class_2561 text, InputList inputs, class_1799 output) implements Identifiable
{
    public static Codec<BlueprintSchema> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1799.field_24671.fieldOf("output").forGetter(BlueprintSchema::output), (App)InputList.CODEC.fieldOf("inputs").forGetter(BlueprintSchema::inputs)).apply((Applicative)instance, BlueprintSchema::new));

    public BlueprintSchema(class_1799 output, InputList inputs) {
        this(class_7923.field_41178.method_10221((Object)output.method_7909()), (class_2561)class_2561.method_43471((String)output.method_7922()), inputs, output);
    }

    public Blueprint create() {
        return new Blueprint(this);
    }

    @Override
    public String toString() {
        return "BlueprintSchema{id=" + String.valueOf(this.id) + ", text=" + String.valueOf(this.text) + ", inputs=" + String.valueOf(this.inputs) + ", output=" + String.valueOf(this.output) + "}";
    }

    public static BlueprintSchema fromInputStream(InputStream stream) {
        return BlueprintSchema.fromJson(JsonParser.parseReader((Reader)new InputStreamReader(stream)).getAsJsonObject());
    }

    public static BlueprintSchema fromJson(JsonObject json) {
        AtomicReference created = new AtomicReference();
        CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).get().ifLeft(planet -> created.set((BlueprintSchema)planet.getFirst())).ifRight(err -> {
            created.set(null);
            AITMod.LOGGER.error("Error decoding datapack blueprint: {}", err);
        });
        return (BlueprintSchema)created.get();
    }

    public static class InputList
    extends ArrayList<Input> {
        public static Codec<InputList> CODEC = Input.CODEC.listOf().flatXmap(l -> {
            InputList list = new InputList();
            list.addAll(l);
            return DataResult.success((Object)list);
        }, DataResult::success);

        public InputList() {
        }

        public InputList(Input ... inputs) {
            super(List.of(inputs));
        }

        public InputList(class_1799 ... stacks) {
            for (class_1799 stack : stacks) {
                this.add(new Input(stack));
            }
        }

        public List<class_1799> toStacks() {
            ArrayList<class_1799> stacks = new ArrayList<class_1799>();
            for (Input input : this) {
                stacks.add(input.toStack());
            }
            return stacks;
        }
    }

    public static class Input {
        public static Codec<Input> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("item").forGetter(input -> class_7923.field_41178.method_10221((Object)input.item)), (App)Codec.INT.fieldOf("minCount").forGetter(Input::minimum), (App)Codec.INT.fieldOf("maxCount").forGetter(Input::maximum)).apply((Applicative)instance, Input::new));
        private final class_1792 item;
        private final int maxCount;
        private final int minCount;

        public Input(class_1792 item, int minCount, int maxCount) {
            this.item = item;
            this.minCount = minCount;
            this.maxCount = maxCount;
        }

        public Input(class_1792 item, int count) {
            this(item, count, count);
        }

        public Input(class_1792 item) {
            this(item, 1);
        }

        public Input(class_1799 stack) {
            this(stack.method_7909(), stack.method_7947());
        }

        private Input(class_2960 item, Integer min, Integer max) {
            this((class_1792)class_7923.field_41178.method_10223(item), (int)min, (int)max);
        }

        public int minimum() {
            return this.minCount;
        }

        public int maximum() {
            return this.maxCount;
        }

        public class_1799 toStack() {
            return new class_1799((class_1935)this.item, this.minCount + (int)(Math.random() * (double)(this.maxCount - this.minCount)));
        }

        public class_1799 maxCountStack() {
            return new class_1799((class_1935)this.item, this.maxCount);
        }

        public String toString() {
            return "Input{item=" + String.valueOf(this.item) + ", minCount=" + this.minCount + ", maxCount=" + this.maxCount + "}";
        }

        public class_2561 text() {
            class_5250 countText = this.minCount == this.maxCount ? class_2561.method_43470((String)String.valueOf(this.minCount)) : class_2561.method_43470((String)(this.minCount + "-" + this.maxCount));
            return class_2564.method_10885((class_2561)class_2561.method_43471((String)this.item.method_7876())).method_27693(" x").method_10852((class_2561)countText);
        }
    }
}

