/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.item.component;

import dev.amble.ait.AITMod;
import dev.amble.ait.core.AITTags;
import dev.amble.ait.core.item.SonicItem;
import dev.amble.ait.core.item.link.AbstractLinkItem;
import dev.amble.ait.core.item.sonic.SonicMode;
import dev.amble.ait.core.util.StackUtil;
import dev.amble.ait.data.schema.MachineRecipeSchema;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5536;
import net.minecraft.class_5630;

public class AbstractTardisPart
extends class_1792 {
    public static final class_2960 DISASSEMBLE = AITMod.id("part_disassemble");
    public static final class_2960 ATTACH = AITMod.id("link_attach");
    public static final class_2960 UNATTACH = AITMod.id("link_unattach");
    private final AbstractLinkItem.Type[] slots;

    public AbstractTardisPart(class_1792.class_1793 settings, AbstractLinkItem.Type ... slots) {
        super(settings.method_7889(1));
        this.slots = slots;
    }

    private static void set(class_1799 stack, AbstractLinkItem item, AbstractLinkItem.Type type) {
        class_2487 nbt = stack.method_7948();
        StackUtil.write(nbt, type.toString(), item);
    }

    public static void remove(class_1799 stack, AbstractLinkItem.Type type) {
        AbstractTardisPart.set(stack, null, type);
    }

    public static void remove(class_1799 stack, AbstractLinkItem item) {
        AbstractTardisPart.remove(stack, item.getType());
    }

    public static void set(class_1799 stack, AbstractLinkItem item) {
        AbstractTardisPart.set(stack, item, item.getType());
    }

    public static AbstractLinkItem get(class_1799 stack, AbstractLinkItem.Type type) {
        class_2487 nbt = stack.method_7948();
        class_1792 result = StackUtil.readItem(nbt, type.toString());
        if (result != null) {
            return (AbstractLinkItem)result;
        }
        return null;
    }

    public static AbstractLinkItem getAny(class_1799 stack) {
        for (AbstractLinkItem.Type type : AbstractLinkItem.Type.values()) {
            AbstractLinkItem item = AbstractTardisPart.get(stack, type);
            if (item == null) continue;
            return item;
        }
        return null;
    }

    public static AbstractLinkItem removeAny(class_1799 stack) {
        AbstractLinkItem item = AbstractTardisPart.getAny(stack);
        if (item == null) {
            return null;
        }
        AbstractTardisPart.remove(stack, item);
        return item;
    }

    public boolean method_31565(class_1799 stack, class_1735 slot, class_5536 clickType, class_1657 player) {
        class_1799 machine = slot.method_7677();
        if (clickType != class_5536.field_27014) {
            return false;
        }
        if (!stack.method_41409().method_40220(AITTags.Items.SONIC_ITEM)) {
            return false;
        }
        if (SonicItem.mode(stack) != SonicMode.Modes.INTERACTION) {
            return false;
        }
        AbstractTardisPart.disassemble(machine);
        return true;
    }

    public boolean method_31566(class_1799 stack, class_1799 otherStack, class_1735 slot, class_5536 clickType, class_1657 player, class_5630 cursor) {
        if (player.method_37908().method_8608()) {
            return false;
        }
        if (!(stack.method_7909() instanceof AbstractLinkItem)) {
            return false;
        }
        if (clickType == class_5536.field_27014) {
            AbstractTardisPart.set(stack, (AbstractLinkItem)StackUtil.take(otherStack).method_7909());
        } else {
            cursor.method_32332(new class_1799((class_1935)StackUtil.orAir(AbstractTardisPart.removeAny(stack))));
        }
        return true;
    }

    public AbstractLinkItem.Type[] getSlots() {
        return this.slots;
    }

    @Environment(value=EnvType.CLIENT)
    public static void disassemble(class_1799 machine) {
        class_2540 data = PacketByteBufs.create();
        data.method_10793(StackUtil.take(machine));
        ClientPlayNetworking.send((class_2960)DISASSEMBLE, (class_2540)data);
    }

    @Environment(value=EnvType.CLIENT)
    public static void unattach(class_1799 machine, AbstractLinkItem.Type link) {
        class_2540 data = PacketByteBufs.create();
        data.method_10793(machine);
        data.method_10817((Enum)link);
        ClientPlayNetworking.send((class_2960)UNATTACH, (class_2540)data);
    }

    @Environment(value=EnvType.CLIENT)
    public static void attach(class_1799 machine, AbstractLinkItem link) {
        class_2540 data = PacketByteBufs.create();
        data.method_10793(machine);
        StackUtil.writeItem(data, link);
        ClientPlayNetworking.send((class_2960)ATTACH, (class_2540)data);
    }

    @Environment(value=EnvType.SERVER)
    public static void disassemble(class_3222 player, class_1799 machine, MachineRecipeSchema recipe) {
        machine.method_7934(1);
        for (class_1799 input : recipe.input()) {
            player.method_7328(input, true);
        }
    }

    @Environment(value=EnvType.SERVER)
    public static void unattach(class_3222 player, class_1799 machine, AbstractLinkItem.Type type) {
        AbstractTardisPart.remove(machine, type);
    }
}

