/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.item.sonic;

import dev.amble.ait.api.tardis.link.v2.block.AbstractLinkableBlockEntity;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.AITTags;
import dev.amble.ait.core.item.SonicItem;
import dev.amble.ait.core.item.sonic.SonicMode;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.core.tardis.control.Control;
import dev.amble.ait.core.tardis.control.impl.HADSControl;
import dev.amble.ait.core.tardis.control.impl.HandBrakeControl;
import dev.amble.ait.core.tardis.handler.travel.TravelHandler;
import dev.amble.ait.core.tardis.handler.travel.TravelHandlerBase;
import dev.amble.ait.data.Loyalty;
import dev.amble.ait.data.schema.sonic.SonicSchema;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2309;
import net.minecraft.class_2312;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2388;
import net.minecraft.class_2389;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2401;
import net.minecraft.class_243;
import net.minecraft.class_2453;
import net.minecraft.class_2457;
import net.minecraft.class_2530;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4262;
import net.minecraft.class_4770;
import net.minecraft.class_5540;
import net.minecraft.class_5712;

public class OverloadSonicMode
extends SonicMode {
    protected OverloadSonicMode(int index) {
        super(index);
    }

    @Override
    public class_2561 text() {
        return class_2561.method_43471((String)"sonic.ait.mode.overload").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067});
    }

    @Override
    public void tick(class_1799 stack, class_1937 world, class_1309 user, int ticks, int ticksLeft) {
        class_3218 serverWorld;
        block3: {
            block2: {
                if (!(world instanceof class_3218)) break block2;
                serverWorld = (class_3218)world;
                if (ticks % 10 == 0) break block3;
            }
            return;
        }
        this.process(serverWorld, user, ticks);
    }

    private void process(class_3218 world, class_1309 user, int ticks) {
        class_3966 entityHit;
        class_1297 mainFuel2;
        class_1792 dir;
        class_239 hitResult = SonicMode.getHitResultForOutline(user);
        SonicMode.checkSonicWoodAdvancementConditions((class_1937)world, user, hitResult);
        if (hitResult instanceof class_3965) {
            class_3965 blockHit = (class_3965)hitResult;
            this.overloadBlock(blockHit.method_17777(), world, user, ticks, blockHit);
        }
        if (!(user instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)user;
        class_1799 main = player.method_6047();
        class_1799 off = player.method_6079();
        class_1792 class_17922 = main.method_7909();
        if (class_17922 instanceof SonicItem) {
            SonicItem mainSonic = (SonicItem)class_17922;
            class_17922 = off.method_7909();
            if (class_17922 instanceof SonicItem) {
                SonicItem offSonic = (SonicItem)class_17922;
                if (SonicItem.mode(off) == SonicMode.Modes.OVERLOAD) {
                    double mainFuel2 = mainSonic.getCurrentFuel(main);
                    double offFuel = offSonic.getCurrentFuel(off);
                    if (mainFuel2 > 0.0 || offFuel > 0.0) {
                        mainSonic.removeFuel(mainFuel2, main);
                        offSonic.removeFuel(offFuel, off);
                        dir = player.method_5828(1.0f).method_1021(-0.5).method_1031(0.0, 0.3, 0.0);
                        player.method_5762(dir.field_1352, dir.field_1351, dir.field_1350);
                        player.method_5643(world.method_48963().method_48831(), 2.0f);
                        this.playSparkEffect(world, player);
                        player.method_7357().method_7906(main.method_7909(), 60);
                        player.method_7357().method_7906(off.method_7909(), 60);
                    }
                }
            }
        }
        if (hitResult instanceof class_3966 && (mainFuel2 = (entityHit = (class_3966)hitResult).method_17782()) instanceof class_1657) {
            double otherFuel;
            class_1657 other = (class_1657)mainFuel2;
            class_1799 userStack = player.method_6047();
            class_1799 otherStack = other.method_6047();
            class_1792 class_17923 = userStack.method_7909();
            if (!(class_17923 instanceof SonicItem)) {
                return;
            }
            SonicItem userSonic = (SonicItem)class_17923;
            dir = otherStack.method_7909();
            if (!(dir instanceof SonicItem)) {
                return;
            }
            SonicItem otherSonic = (SonicItem)dir;
            if (SonicItem.mode(otherStack) != SonicMode.Modes.OVERLOAD) {
                return;
            }
            double userFuel = userSonic.getCurrentFuel(userStack);
            if (userFuel == (otherFuel = otherSonic.getCurrentFuel(otherStack))) {
                return;
            }
            class_1657 lowerFuelPlayer = userFuel < otherFuel ? player : other;
            class_1657 higherFuelPlayer = userFuel < otherFuel ? other : player;
            class_1799 lowerStack = lowerFuelPlayer.method_6047();
            class_1799 higherStack = higherFuelPlayer.method_6047();
            double transferAmount = 10.0;
            double actualRemoved = Math.min(transferAmount, ((SonicItem)higherStack.method_7909()).getCurrentFuel(higherStack));
            ((SonicItem)higherStack.method_7909()).removeFuel(actualRemoved, higherStack);
            ((SonicItem)lowerStack.method_7909()).addFuel(actualRemoved, lowerStack);
            this.playSparkEffect(world, lowerFuelPlayer);
            class_243 pushDir = lowerFuelPlayer.method_19538().method_1020(higherFuelPlayer.method_19538()).method_1029().method_1021(0.5);
            lowerFuelPlayer.method_5762(pushDir.field_1352, 0.1, pushDir.field_1350);
            higherFuelPlayer.method_5762(-pushDir.field_1352, 0.1, -pushDir.field_1350);
            lowerFuelPlayer.method_5643(world.method_48963().method_48831(), 1.0f);
            higherFuelPlayer.method_5643(world.method_48963().method_48831(), 1.0f);
            player.method_7357().method_7906(userStack.method_7909(), 60);
            other.method_7357().method_7906(otherStack.method_7909(), 500);
        }
    }

    private void overloadBlock(class_2338 pos, class_3218 world, class_1309 user, int ticks, class_3965 blockHit) {
        AbstractLinkableBlockEntity ext;
        class_2680 state = world.method_8320(pos);
        class_2248 block = state.method_26204();
        if (!state.method_26164(AITTags.Blocks.SONIC_INTERACTABLE) || !OverloadSonicMode.canMakeRedstoneTweak(ticks)) {
            return;
        }
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof AbstractLinkableBlockEntity && (ext = (AbstractLinkableBlockEntity)class_25862).isLinked()) {
            ServerTardis tardis = ext.tardis().get().asServer();
            if (tardis.loyalty().get((class_1657)user).smallerThan(Loyalty.fromLevel(Loyalty.Type.COMPANION.level))) {
                return;
            }
            OverloadSonicMode.getExpectedControl(tardis).handleRun(tardis, (class_3222)user, world, pos, false);
            this.playFx(world, pos);
            return;
        }
        if (block instanceof class_2309) {
            this.activateBlock(world, pos, user, state, blockHit);
        } else if (block instanceof class_2453) {
            world.method_8501(pos, (class_2680)state.method_28493((class_2769)class_2741.field_12548));
        } else if (block instanceof class_2457 || block instanceof class_2312) {
            this.forceRedstonePower(world, pos, state, 100);
        } else if (block instanceof class_2401) {
            class_2401 lever = (class_2401)block;
            lever.method_21846(state, (class_1937)world, pos);
        } else if (block instanceof class_4262 || block instanceof class_2389) {
            this.breakBlock(world, pos, user, state, blockHit);
        } else if (OverloadSonicMode.canLight(ticks) && block instanceof class_2530) {
            class_2530.method_10738((class_1937)world, (class_2338)pos);
            world.method_8650(pos, false);
            world.method_33596((class_1297)user, class_5712.field_28165, pos);
        } else if (state.method_26204() instanceof class_5540) {
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)class_5540.field_27083, (Comparable)Boolean.valueOf(true)), 3);
            world.method_33596((class_1297)user, class_5712.field_28733, pos);
        } else if (state.method_27852(class_2246.field_10540)) {
            class_2338 blockPos2 = pos.method_10093(blockHit.method_17780());
            if (class_4770.method_30032((class_1937)world, (class_2338)blockPos2, (class_2350)user.method_5735())) {
                this.playFx(world, blockPos2);
                world.method_8652(blockPos2, class_4770.method_24416((class_1922)world, (class_2338)blockPos2), 3);
                world.method_33596((class_1297)user, class_5712.field_28164, pos);
            }
        } else if (state.method_27852(class_2246.field_10104)) {
            this.breakBlock(world, pos, user, state, blockHit);
        }
        this.playFx(world, pos);
    }

    private void playSparkEffect(class_3218 world, class_1657 player) {
        class_243 pos = player.method_19538().method_1031(0.0, (double)player.method_17682() / 2.0, 0.0);
        world.method_14199((class_2394)class_2398.field_29644, pos.field_1352, pos.field_1351, pos.field_1350, 10, 0.2, 0.5, 0.2, 0.05);
        world.method_8396(null, player.method_24515(), AITSounds.SONIC_TWEAK, class_3419.field_15248, 1.0f, 1.5f);
    }

    private static Control getExpectedControl(ServerTardis tardis) {
        TravelHandler travel = tardis.travel();
        return travel.getState() == TravelHandlerBase.State.DEMAT || tardis.subsystems().engine().phaser().isPhasing() ? new HandBrakeControl() : new HADSControl();
    }

    private void activateBlock(class_3218 world, class_2338 pos, class_1309 user, class_2680 state, class_3965 hit) {
        state.method_26174((class_1937)world, (class_1657)user, user.method_6058(), hit);
        this.playFx(world, pos);
    }

    private void breakBlock(class_3218 world, class_2338 pos, class_1309 user, class_2680 state, class_3965 hit) {
        world.method_8396(null, pos, state.method_26231().method_10595(), class_3419.field_15245, 1.0f, 1.0f);
        world.method_14199((class_2394)new class_2388(class_2398.field_11217, state), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 10, 0.5, 0.5, 0.5, 0.1);
        world.method_22352(pos, false);
    }

    private void forceRedstonePower(class_3218 world, class_2338 pos, class_2680 state, int durationTicks) {
        this.playFx(world, pos);
        world.method_8408(pos, state.method_26204());
    }

    private void playFx(class_3218 world, class_2338 pos) {
        world.method_8396(null, pos, AITSounds.SONIC_TWEAK, class_3419.field_15245, 1.0f, 1.0f);
        this.spawnParticles(world, pos);
    }

    private void spawnParticles(class_3218 world, class_2338 pos) {
        world.method_14199((class_2394)class_2398.field_29644, (double)pos.method_10263() + 0.5, (double)(pos.method_10264() + 1), (double)pos.method_10260() + 0.5, 5, 0.2, 0.2, 0.2, 0.01);
        world.method_14199((class_2394)class_2398.field_11239, (double)pos.method_10263() + 0.5, (double)(pos.method_10264() + 1), (double)pos.method_10260() + 0.5, 3, 0.1, 0.1, 0.1, 0.01);
    }

    private static boolean canLight(int ticks) {
        return ticks >= 10;
    }

    private static boolean canMakeRedstoneTweak(int ticks) {
        return ticks >= 10;
    }

    @Override
    public int maxTime() {
        return 6000;
    }

    @Override
    public class_2960 model(SonicSchema.Models models) {
        return models.overload();
    }

    @Override
    public int fuelCost() {
        return 2;
    }
}

