/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.item.sonic;

import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.AITTags;
import dev.amble.ait.core.entities.RiftEntity;
import dev.amble.ait.core.item.SonicItem;
import dev.amble.ait.core.item.sonic.SonicMode;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.util.MonitorUtil;
import dev.amble.ait.core.util.WorldUtil;
import dev.amble.ait.core.world.LandingPadManager;
import dev.amble.ait.core.world.RiftChunkManager;
import dev.amble.ait.core.world.TardisServerWorld;
import dev.amble.ait.data.landing.LandingPadRegion;
import dev.amble.ait.data.landing.LandingPadSpot;
import dev.amble.ait.data.schema.sonic.SonicSchema;
import dev.amble.lib.api.ICantBreak;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5250;
import net.minecraft.class_5281;
import net.minecraft.class_5321;

public class ScanningSonicMode
extends SonicMode {
    private static final class_2561 RIFT_FOUND = class_2561.method_43471((String)"message.ait.sonic.riftfound").method_27692(class_124.field_1075).method_27692(class_124.field_1067);
    private static final class_2561 RIFT_NOT_FOUND = class_2561.method_43471((String)"message.ait.sonic.riftnotfound").method_27692(class_124.field_1075).method_27692(class_124.field_1067);

    protected ScanningSonicMode(int index) {
        super(index);
    }

    @Override
    public class_2561 text() {
        return class_2561.method_43471((String)"sonic.ait.mode.scanning").method_27695(new class_124[]{class_124.field_1054, class_124.field_1067});
    }

    @Override
    public int maxTime() {
        return 6000;
    }

    @Override
    public void tick(class_1799 stack, class_1937 world, class_1309 user, int ticks, int ticksLeft) {
        class_1657 player;
        block3: {
            block2: {
                if (!(world instanceof class_3218)) break block2;
                class_3218 serverWorld = (class_3218)world;
                if (!(user instanceof class_1657)) break block2;
                player = (class_1657)user;
                if (ticks % 10 == 0) break block3;
            }
            return;
        }
        this.process(stack, world, player);
    }

    public boolean process(class_1799 stack, class_1937 world, class_1657 user) {
        boolean isMainHand;
        class_239 hitResult = SonicMode.getHitResult((class_1309)user);
        boolean bl = isMainHand = user.method_6047().method_7909() == stack.method_7909();
        if (isMainHand) {
            class_3966 entityHit;
            class_3965 blockHit;
            SonicMode.checkSonicWoodAdvancementConditions(world, (class_1309)user, hitResult);
            if (hitResult instanceof class_3965 && !world.method_8320((blockHit = (class_3965)hitResult).method_17777()).method_26215()) {
                return this.scanBlocks(stack, world, user, blockHit.method_17777());
            }
            if (hitResult instanceof class_3966 && !((entityHit = (class_3966)hitResult).method_17782() instanceof RiftEntity)) {
                return this.scanEntities(stack, world, user, entityHit.method_17782());
            }
        }
        return this.scanRegion(stack, world, user, class_2338.method_49638((class_2374)hitResult.method_17784()));
    }

    public boolean scanBlocks(class_1799 stack, class_1937 world, class_1657 user, class_2338 pos) {
        LandingPadRegion region;
        if (world.method_8608() || user == null) {
            return true;
        }
        class_2680 state = world.method_8320(pos);
        class_2248 block = state.method_26204();
        Tardis tardis = SonicItem.getTardisStatic(world, stack);
        String blastRes = String.format("%.2f", Float.valueOf(block.method_9520()));
        if (tardis != null && state.method_26164(AITTags.Blocks.SONIC_CAN_LOCATE)) {
            class_2338 tPos = tardis.travel().position().getPos();
            class_3218 tardisWorld = tardis.travel().position().getWorld();
            String dimensionText = MonitorUtil.truncateDimensionName(WorldUtil.worldText((class_5321<class_1937>)tardisWorld.method_27983()).getString(), 20);
            class_5250 coordinatesMessage = class_2561.method_43469((String)"item.sonic.scanning.locator_message.coordinates", (Object[])new Object[]{tPos.method_10263(), tPos.method_10264(), tPos.method_10260()});
            class_5250 fullMessage = class_2561.method_43469((String)"item.sonic.scanning.locator_message.title", (Object[])new Object[]{dimensionText}).method_27693("\n").method_10852((class_2561)coordinatesMessage);
            user.method_43496((class_2561)fullMessage);
        }
        if ((region = LandingPadManager.getInstance((class_3218)world).getRegionAt(pos)) != null) {
            if (world.method_8320(pos).method_26215()) {
                return true;
            }
            boolean wasSpotCreated = ScanningSonicMode.modifyRegion(null, (class_3218)world, pos.method_10084(), user, stack, region);
            float pitch = wasSpotCreated ? 1.1f : 0.75f;
            world.method_8396(null, pos, AITSounds.SONIC_SWITCH, class_3419.field_15248, 1.0f, pitch);
            return true;
        }
        String toolRequirement = "item.sonic.scanning.any_tool";
        if (block instanceof ICantBreak) {
            toolRequirement = "item.sonic.scanning.cant_break";
        } else if (state.method_26164(class_3481.field_33717)) {
            toolRequirement = "item.sonic.scanning.diamond_tool";
        } else if (state.method_26164(class_3481.field_33718)) {
            toolRequirement = "item.sonic.scanning.iron_tool";
        } else if (state.method_26164(class_3481.field_33719)) {
            toolRequirement = "item.sonic.scanning.stone_tool";
        } else if (!block.method_9564().method_29291()) {
            toolRequirement = "item.sonic.scanning.no_tool";
        }
        class_5250 message = class_2561.method_43470((String)("\ud83d\udd25: " + blastRes + " \u26cf: ")).method_10852((class_2561)class_2561.method_43471((String)toolRequirement)).method_27692(class_124.field_1054).method_27692(class_124.field_1065);
        user.method_7353((class_2561)message, true);
        return true;
    }

    public boolean scanRegion(class_1799 stack, class_1937 world, class_1657 user, class_2338 pos) {
        if (world.method_8608()) {
            return true;
        }
        if (user == null) {
            return false;
        }
        if (!TardisServerWorld.isTardisDimension(world)) {
            ScanningSonicMode.sendRiftInfo(null, (class_3218)world, pos, user, stack);
            return true;
        }
        Tardis tardis = SonicItem.getTardisStatic(world, stack);
        if (tardis == null) {
            return false;
        }
        if (TardisServerWorld.isTardisDimension(world)) {
            ScanningSonicMode.sendTardisInfo(tardis, (class_3218)world, pos, user, stack);
            return true;
        }
        return false;
    }

    public boolean scanEntities(class_1799 stack, class_1937 world, class_1657 user, class_1297 entity) {
        if (world.method_8608()) {
            return true;
        }
        if (user == null) {
            return false;
        }
        if (entity instanceof class_1309) {
            String health = String.valueOf(((class_1309)entity).method_6032());
            String maxhealth = String.valueOf(((class_1309)entity).method_6063());
            user.method_7353((class_2561)class_2561.method_43470((String)"\u2665:").method_27693(health).method_27693("/").method_27693(maxhealth).method_27692(class_124.field_1054), true);
        }
        return false;
    }

    private static boolean modifyRegion(Tardis tardis, class_3218 world, class_2338 pos, class_1657 player, class_1799 stack, LandingPadRegion region) {
        LandingPadSpot spot = region.getSpotAt(pos).orElse(null);
        if (spot == null) {
            ScanningSonicMode.addSpot(region, pos);
            ScanningSonicMode.syncRegion(world, pos);
            return true;
        }
        ScanningSonicMode.removeSpot(region, pos);
        ScanningSonicMode.syncRegion(world, pos);
        return false;
    }

    private static void addSpot(LandingPadRegion region, class_2338 pos) {
        region.createSpotAt(pos);
    }

    private static void removeSpot(LandingPadRegion region, class_2338 pos) {
        region.removeSpotAt(pos);
    }

    private static void syncRegion(class_3218 world, class_2338 pos) {
        LandingPadManager.Network.syncTracked(LandingPadManager.Network.Action.ADD, world, new class_1923(pos));
    }

    private static void sendRiftInfo(Tardis tardis, class_3218 world, class_2338 pos, class_1657 player, class_1799 stack) {
        boolean isRift = RiftChunkManager.isRiftChunk((class_5281)world, pos);
        player.method_7353(isRift ? RIFT_FOUND : RIFT_NOT_FOUND, true);
        if (!isRift) {
            return;
        }
        int artronValue = (int)RiftChunkManager.getInstance(world).getArtron(new class_1923(pos));
        player.method_43496((class_2561)class_2561.method_43469((String)"message.ait.artron_units", (Object[])new Object[]{artronValue}).method_27692(class_124.field_1065));
    }

    private static void sendTardisInfo(Tardis tardis, class_3218 world, class_2338 pos, class_1657 player, class_1799 stack) {
        if (tardis == null) {
            return;
        }
        if (tardis.crash().isUnstable() || tardis.crash().isToxic()) {
            player.method_7353((class_2561)class_2561.method_43469((String)"message.ait.sonic.repairtime", (Object[])new Object[]{tardis.crash().getRepairTicks()}).method_27695(new class_124[]{class_124.field_1079, class_124.field_1056}), true);
            return;
        }
        player.method_7353((class_2561)class_2561.method_43469((String)"message.ait.artron_units", (Object[])new Object[]{tardis.fuel().getCurrentFuel()}).method_27692(class_124.field_1065), true);
    }

    @Override
    public class_2960 model(SonicSchema.Models models) {
        return models.scanning();
    }
}

