/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.item.sonic;

import dev.amble.ait.core.AITTags;
import dev.amble.ait.core.advancement.TardisCriterions;
import dev.amble.ait.core.item.sonic.InactiveSonicMode;
import dev.amble.ait.core.item.sonic.InteractionSonicMode;
import dev.amble.ait.core.item.sonic.OverloadSonicMode;
import dev.amble.ait.core.item.sonic.ScanningSonicMode;
import dev.amble.ait.core.item.sonic.TardisSonicMode;
import dev.amble.ait.data.enummap.Ordered;
import dev.amble.ait.data.schema.sonic.SonicSchema;
import java.util.function.Function;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3959;
import net.minecraft.class_3965;

public abstract class SonicMode
implements Ordered {
    private static final int MAX_DISTANCE = 16;
    private final int index;

    protected SonicMode(int index) {
        this.index = index;
    }

    public SonicMode next() {
        return Modes.next(this);
    }

    public SonicMode previous() {
        return Modes.previous(this);
    }

    public abstract class_2561 text();

    public abstract int maxTime();

    public boolean startUsing(class_1799 stack, class_1937 world, class_1657 user, class_1268 hand) {
        return true;
    }

    public void tick(class_1799 stack, class_1937 world, class_1309 user, int ticks, int ticksLeft) {
    }

    public void stopUsing(class_1799 stack, class_1937 world, class_1309 user, int ticks, int ticksLeft) {
    }

    public void finishUsing(class_1799 stack, class_1937 world, class_1309 user) {
        this.stopUsing(stack, world, user, this.maxTime(), 0);
    }

    public abstract class_2960 model(SonicSchema.Models var1);

    public int fuelCost() {
        return 1;
    }

    public static class_239 getHitResultForOutline(class_1309 user) {
        return SonicMode.getHitResultForOutline(user, 16.0);
    }

    public static class_239 getHitResultForOutline(class_1309 user, double distance) {
        class_3965 hitResult = null;
        if (user instanceof class_1657) {
            class_1657 player = (class_1657)user;
            class_243 eyePos = player.method_5836(1.0f);
            class_243 rotation = player.method_5828(1.0f);
            class_243 end = eyePos.method_1019(rotation.method_1021(distance));
            hitResult = player.method_37908().method_17742(new class_3959(eyePos, end, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)player));
        }
        return hitResult;
    }

    public static class_239 getHitResult(class_1309 user) {
        return SonicMode.getHitResult(user, 16.0);
    }

    public static class_239 getHitResult(class_1309 user, double distance) {
        return class_1675.method_49998((class_1297)user, entity -> !entity.method_7325() && entity.method_5863(), (double)distance);
    }

    public static void checkSonicWoodAdvancementConditions(class_1937 world, class_1309 user, class_239 hitResult) {
        class_3965 blockHit;
        class_2680 state;
        if (!(user instanceof class_3222)) {
            return;
        }
        class_3222 player = (class_3222)user;
        if (hitResult instanceof class_3965 && (state = world.method_8320((blockHit = (class_3965)hitResult).method_17777())).method_26164(AITTags.Blocks.WOODEN_BLOCKS)) {
            TardisCriterions.SONIC_WOOD.trigger(player);
        }
    }

    @Override
    public int index() {
        return this.index;
    }

    public static class Modes {
        public static final SonicMode[] VALUES = new SonicMode[4];
        private static int lastIndex = 0;
        public static final SonicMode INTERACTION = Modes.register(InteractionSonicMode::new);
        public static final SonicMode OVERLOAD = Modes.register(OverloadSonicMode::new);
        public static final SonicMode SCANNING = Modes.register(ScanningSonicMode::new);
        public static final SonicMode TARDIS = Modes.register(TardisSonicMode::new);
        public static final SonicMode INACTIVE = new InactiveSonicMode();

        public static SonicMode register(Function<Integer, SonicMode> consumer) {
            SonicMode mode;
            Modes.VALUES[Modes.lastIndex] = mode = consumer.apply(lastIndex);
            ++lastIndex;
            return mode;
        }

        public static SonicMode next(SonicMode mode) {
            int nextIndex = mode.index() + 1;
            if (nextIndex == VALUES.length) {
                return VALUES[0];
            }
            return VALUES[nextIndex];
        }

        public static SonicMode previous(SonicMode mode) {
            int previousIndex = mode.index() - 1;
            if (previousIndex < 0) {
                return VALUES[VALUES.length - 1];
            }
            return VALUES[previousIndex];
        }

        public static SonicMode get(int index) {
            if (index == -1) {
                return INACTIVE;
            }
            return VALUES[index];
        }

        public static SonicMode getAndWrap(Integer index) {
            if (index == null) {
                return INACTIVE;
            }
            while (index >= VALUES.length) {
                index = index - VALUES.length;
            }
            return Modes.get(index);
        }

        public static int size() {
            return VALUES.length;
        }
    }
}

