/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.item.sonic;

import dev.amble.ait.core.engine.SubSystem;
import dev.amble.ait.core.item.SonicItem;
import dev.amble.ait.core.item.sonic.SonicMode;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.util.TardisUtil;
import dev.amble.ait.core.world.TardisServerWorld;
import dev.amble.ait.data.schema.sonic.SonicSchema;
import dev.amble.lib.data.CachedDirectedGlobalPos;
import dev.amble.lib.data.DirectedGlobalPos;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;

public class TardisSonicMode
extends SonicMode {
    protected TardisSonicMode(int index) {
        super(index);
    }

    @Override
    public void tick(class_1799 stack, class_1937 world, class_1309 user, int ticks, int ticksLeft) {
        class_1657 player;
        block3: {
            block2: {
                if (!(world instanceof class_3218)) break block2;
                class_3218 serverWorld = (class_3218)world;
                if (!(user instanceof class_1657)) break block2;
                player = (class_1657)user;
                if (ticks % 10 == 0) break block3;
            }
            return;
        }
        this.process(stack, world, player);
    }

    public boolean process(class_1799 stack, class_1937 world, class_1657 user) {
        boolean isLookingUp;
        boolean isMainHand;
        if (!(user instanceof class_3222)) {
            return false;
        }
        class_3222 player = (class_3222)user;
        Tardis tardis = SonicItem.getTardisStatic(world, stack);
        if (tardis == null) {
            return false;
        }
        boolean bl = isMainHand = user.method_6047().method_7909() == stack.method_7909();
        if (isMainHand) {
            class_239 hitResult = SonicMode.getHitResult((class_1309)user, 2.0);
            return this.interactBlock(stack, world, player, class_2338.method_49638((class_2374)hitResult.method_17784()));
        }
        boolean bl2 = isLookingUp = user.method_36455() < 0.0f;
        if (isLookingUp) {
            tardis.travel().handbrake(false);
            tardis.travel().dematerialize();
            player.method_7353((class_2561)class_2561.method_43471((String)"sonic.ait.mode.tardis.flight"), true);
            return true;
        }
        tardis.travel().handbrake(true);
        tardis.fuel().refueling().set(true);
        player.method_7353((class_2561)class_2561.method_43471((String)"sonic.ait.mode.tardis.refuel"), true);
        return true;
    }

    private boolean interactBlock(class_1799 stack, class_1937 world, class_3222 player, class_2338 pos) {
        Tardis tardis = SonicItem.getTardisStatic(world, stack);
        if (tardis == null) {
            return false;
        }
        if (TardisServerWorld.isTardisDimension(world)) {
            return false;
        }
        CachedDirectedGlobalPos targetPos = CachedDirectedGlobalPos.create((class_5321<class_1937>)player.method_51469().method_27983(), pos, DirectedGlobalPos.getGeneralizedRotation((class_2350)player.method_5755()));
        if (!((SubSystem)tardis.subsystems().get(SubSystem.Id.STABILISERS)).isUsable()) {
            player.method_7353((class_2561)class_2561.method_43471((String)"sonic.ait.mode.tardis.does_not_have_stabilisers"), true);
            return false;
        }
        class_3218 tardisWorld = tardis.travel().position().getWorld();
        boolean inSameWorld = player.method_37908().equals(tardisWorld);
        boolean isNearTardis = TardisUtil.isNearTardis((class_1657)player, tardis, 256.0);
        double distance = TardisUtil.distanceFromTardis((class_1657)player, tardis);
        if (!tardis.fuel().hasPower()) {
            player.method_7353((class_2561)class_2561.method_43471((String)"sonic.ait.mode.tardis.does_not_have_power"), true);
            return false;
        }
        if (tardis.fuel().getCurrentFuel() <= TardisUtil.estimatedFuelCost((class_1657)player, tardis, distance)) {
            player.method_7353((class_2561)class_2561.method_43471((String)"sonic.ait.mode.tardis.insufficient_fuel"), true);
            return false;
        }
        if (!inSameWorld || !isNearTardis) {
            player.method_7353((class_2561)class_2561.method_43471((String)"sonic.ait.mode.tardis.is_not_in_range"), true);
            return false;
        }
        tardis.travel().destination(targetPos);
        tardis.travel().autopilot(true);
        tardis.travel().dematerialize();
        player.method_7353((class_2561)class_2561.method_43471((String)"sonic.ait.mode.tardis.location_summon"), true);
        return true;
    }

    @Override
    public class_2561 text() {
        return class_2561.method_43471((String)"sonic.ait.mode.tardis").method_27695(new class_124[]{class_124.field_1078, class_124.field_1067});
    }

    @Override
    public int maxTime() {
        return 40;
    }

    @Override
    public class_2960 model(SonicSchema.Models models) {
        return models.tardis();
    }
}

