/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.likes;

import dev.amble.ait.core.likes.ItemOpinionRegistry;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.lib.api.Identifiable;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public interface Opinion
extends Identifiable {
    public int loyalty();

    public Type type();

    default public boolean likes() {
        return this.loyalty() > 0;
    }

    default public void apply(ServerTardis tardis, class_3222 target) {
        tardis.loyalty().addLevel(target, this.loyalty());
    }

    public static Optional<Opinion> find(class_2960 id) {
        for (Type type : Type.values()) {
            Opinion opinion = type.get(id);
            if (opinion == null) continue;
            return Optional.of(opinion);
        }
        return Optional.empty();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Type {
        ITEM{

            @Override
            public Opinion get(class_2960 id) {
                return (Opinion)ItemOpinionRegistry.getInstance().get(id);
            }
        };


        public abstract Opinion get(class_2960 var1);
    }
}

