/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.lock;

import dev.amble.ait.AITMod;
import dev.amble.ait.core.lock.LockedDimension;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.util.WorldUtil;
import dev.amble.lib.register.datapack.SimpleDatapackRegistry;
import dev.amble.lib.register.unlockable.Unlockable;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_7134;

public class LockedDimensionRegistry
extends SimpleDatapackRegistry<LockedDimension> {
    private static final LockedDimensionRegistry instance = new LockedDimensionRegistry();
    public static LockedDimension NETHER;

    public LockedDimensionRegistry() {
        super(LockedDimension::fromInputStream, LockedDimension.CODEC, "locked_dimension", true, "ait");
    }

    public void onCommonInit() {
        super.onCommonInit();
        this.defaults();
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)this);
    }

    protected void defaults() {
        NETHER = (LockedDimension)this.register(new LockedDimension(class_7134.field_37671, new class_1799((class_1935)class_1802.field_8894)));
    }

    public LockedDimension fallback() {
        return NETHER;
    }

    public LockedDimension get(class_1937 world) {
        return (LockedDimension)this.get(world.method_27983().method_29177());
    }

    public List<LockedDimension> forStack(class_1799 stack) {
        ArrayList<LockedDimension> copy = new ArrayList<LockedDimension>(this.REGISTRY.values());
        copy.removeIf(dim -> !dim.stack().method_7909().equals(stack.method_7909()));
        return copy;
    }

    public static LockedDimensionRegistry getInstance() {
        return instance;
    }

    public static boolean tryUnlockDimension(class_3222 player, class_1799 held, ServerTardis tardis) {
        if (held.method_7960()) {
            return false;
        }
        if (!AITMod.CONFIG.lockDimensions) {
            return false;
        }
        List<LockedDimension> dims = LockedDimensionRegistry.getInstance().forStack(held);
        if (dims.isEmpty()) {
            return false;
        }
        dims.forEach(dim -> {
            tardis.stats().unlock((Unlockable)dim);
            player.method_7353((class_2561)dim.text().method_27661().method_27693(" unlocked!").method_27695(new class_124[]{class_124.field_1067, class_124.field_1056, class_124.field_1065}), false);
        });
        player.method_51469().method_8396(null, player.method_24515(), class_3417.field_15195, class_3419.field_15248, 0.2f, 1.0f);
        held.method_7934(1);
        return true;
    }

    public boolean isUnlocked(Tardis tardis, class_1937 world) {
        if (!AITMod.CONFIG.lockDimensions) {
            return true;
        }
        if (this.isEnd(world)) {
            return WorldUtil.isEndDragonDead();
        }
        LockedDimension dim = this.get(world);
        return dim == null || tardis.isUnlocked(dim);
    }

    private boolean isEnd(class_1937 world) {
        return world.method_27983().method_29177().equals((Object)class_1937.field_25181.method_29177());
    }
}

