/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.sounds.flight;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.amble.ait.AITMod;
import dev.amble.ait.api.Nameable;
import dev.amble.ait.core.AITSounds;
import dev.amble.lib.api.Identifiable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_7923;

public record FlightSound(class_2960 id, class_2960 soundId, int length, String name) implements Identifiable,
Nameable
{
    public static final Codec<FlightSound> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("id").forGetter(FlightSound::id), (App)class_2960.field_25139.fieldOf("sound").forGetter(FlightSound::soundId), (App)Codec.INT.fieldOf("length").forGetter(FlightSound::length), (App)Codec.STRING.optionalFieldOf("name", (Object)"").forGetter(FlightSound::name)).apply((Applicative)instance, FlightSound::new));

    public FlightSound {
        if (name.isEmpty()) {
            name = id.method_12832();
        }
    }

    public class_3414 sound() {
        class_3414 sfx = (class_3414)class_7923.field_41172.method_10223(this.soundId());
        if (sfx == null) {
            AITMod.LOGGER.error("Unknown sound event: {} in flight sfx {}", (Object)this.soundId(), (Object)this.id());
            sfx = AITSounds.ERROR;
        }
        return sfx;
    }

    public static FlightSound fromInputStream(InputStream stream) {
        return FlightSound.fromJson(JsonParser.parseReader((Reader)new InputStreamReader(stream)).getAsJsonObject());
    }

    public static FlightSound fromJson(JsonObject json) {
        AtomicReference created = new AtomicReference();
        CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).get().ifLeft(var -> created.set((FlightSound)var.getFirst())).ifRight(err -> {
            created.set(null);
            AITMod.LOGGER.error("Error decoding datapack flight sfx: {}", err);
        });
        return (FlightSound)created.get();
    }
}

