/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.tardis;

import dev.amble.ait.api.tardis.Initializable;
import dev.amble.ait.api.tardis.TardisComponent;
import dev.amble.ait.client.tardis.ClientTardis;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.core.tardis.TardisDesktop;
import dev.amble.ait.core.tardis.TardisExterior;
import dev.amble.ait.core.tardis.TardisHandlersManager;
import dev.amble.ait.core.tardis.control.sequences.SequenceHandler;
import dev.amble.ait.core.tardis.handler.ButlerHandler;
import dev.amble.ait.core.tardis.handler.ChameleonHandler;
import dev.amble.ait.core.tardis.handler.CloakHandler;
import dev.amble.ait.core.tardis.handler.DoorHandler;
import dev.amble.ait.core.tardis.handler.ExtraHandler;
import dev.amble.ait.core.tardis.handler.FuelHandler;
import dev.amble.ait.core.tardis.handler.HadsHandler;
import dev.amble.ait.core.tardis.handler.InteriorChangingHandler;
import dev.amble.ait.core.tardis.handler.LandingPadHandler;
import dev.amble.ait.core.tardis.handler.LoyaltyHandler;
import dev.amble.ait.core.tardis.handler.OpinionHandler;
import dev.amble.ait.core.tardis.handler.RealFlightHandler;
import dev.amble.ait.core.tardis.handler.SelfDestructHandler;
import dev.amble.ait.core.tardis.handler.ServerAlarmHandler;
import dev.amble.ait.core.tardis.handler.ServerHumHandler;
import dev.amble.ait.core.tardis.handler.ShieldHandler;
import dev.amble.ait.core.tardis.handler.SiegeHandler;
import dev.amble.ait.core.tardis.handler.SonicHandler;
import dev.amble.ait.core.tardis.handler.StatsHandler;
import dev.amble.ait.core.tardis.handler.SubSystemHandler;
import dev.amble.ait.core.tardis.handler.TardisCrashHandler;
import dev.amble.ait.core.tardis.handler.WaypointHandler;
import dev.amble.ait.core.tardis.handler.permissions.PermissionHandler;
import dev.amble.ait.core.tardis.handler.travel.TravelHandler;
import dev.amble.ait.registry.impl.DesktopRegistry;
import dev.amble.ait.registry.impl.exterior.ExteriorVariantRegistry;
import dev.amble.lib.register.unlockable.Unlockable;
import java.util.Objects;
import java.util.UUID;

public abstract class Tardis
extends Initializable<TardisComponent.InitContext> {
    private UUID uuid;
    protected TardisDesktop desktop;
    protected TardisExterior exterior;
    protected TardisHandlersManager handlers;

    protected Tardis(UUID uuid, TardisDesktop desktop, TardisExterior exterior) {
        this.uuid = uuid;
        this.desktop = desktop;
        this.exterior = exterior;
        this.handlers = new TardisHandlersManager();
    }

    protected Tardis() {
    }

    @Override
    protected void onInit(TardisComponent.InitContext ctx) {
        TardisComponent.init(this.desktop, this, ctx);
        TardisComponent.init(this.exterior, this, ctx);
        TardisComponent.init(this.handlers, this, ctx);
        this.postInit(ctx);
    }

    protected void postInit(TardisComponent.InitContext ctx) {
        TardisComponent.postInit(this.desktop, ctx);
        TardisComponent.postInit(this.exterior, ctx);
        TardisComponent.postInit(this.handlers, ctx);
    }

    public static void init(Tardis tardis, TardisComponent.InitContext ctx) {
        Initializable.init(tardis, ctx);
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public ServerTardis asServer() {
        return (ServerTardis)this;
    }

    public ClientTardis asClient() {
        return (ClientTardis)this;
    }

    public TardisDesktop getDesktop() {
        return this.desktop;
    }

    public TardisExterior getExterior() {
        return this.exterior;
    }

    public DoorHandler door() {
        return (DoorHandler)this.handler(TardisComponent.Id.DOOR);
    }

    public SonicHandler sonic() {
        return (SonicHandler)this.handler(TardisComponent.Id.SONIC);
    }

    public ButlerHandler butler() {
        return (ButlerHandler)this.handler(TardisComponent.Id.BUTLER);
    }

    public TravelHandler travel() {
        return (TravelHandler)this.handler(TardisComponent.Id.TRAVEL);
    }

    public ExtraHandler extra() {
        return (ExtraHandler)this.handler(TardisComponent.Id.EXTRAS);
    }

    public RealFlightHandler flight() {
        return (RealFlightHandler)this.handler(TardisComponent.Id.FLIGHT);
    }

    public LoyaltyHandler loyalty() {
        return (LoyaltyHandler)this.handler(TardisComponent.Id.LOYALTY);
    }

    public ServerAlarmHandler alarm() {
        return (ServerAlarmHandler)this.handler(TardisComponent.Id.ALARMS);
    }

    public StatsHandler stats() {
        return (StatsHandler)this.handler(TardisComponent.Id.STATS);
    }

    @Deprecated(forRemoval=true)
    public InteriorChangingHandler interiorChangingHandler() {
        return this.interiorChanging();
    }

    public InteriorChangingHandler interiorChanging() {
        return (InteriorChangingHandler)this.handler(TardisComponent.Id.INTERIOR);
    }

    public ServerHumHandler hum() {
        return (ServerHumHandler)this.handler(TardisComponent.Id.HUM);
    }

    public ChameleonHandler chameleon() {
        return (ChameleonHandler)this.handler(TardisComponent.Id.CHAMELEON);
    }

    public TardisHandlersManager getHandlers() {
        return this.handlers;
    }

    public <T extends TardisComponent> T handler(TardisComponent.IdLike type) {
        return this.handlers.get(type);
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public double addFuel(double fuel) {
        return ((FuelHandler)this.handler(TardisComponent.Id.FUEL)).addFuel(fuel);
    }

    public void removeFuel(double fuel) {
        ((FuelHandler)this.handler(TardisComponent.Id.FUEL)).removeFuel(fuel);
    }

    public double getFuel() {
        return ((FuelHandler)this.handler(TardisComponent.Id.FUEL)).getCurrentFuel();
    }

    public void setFuelCount(double i) {
        ((FuelHandler)this.handler(TardisComponent.Id.FUEL)).setCurrentFuel(i);
    }

    public boolean isRefueling() {
        return (Boolean)((FuelHandler)this.handler(TardisComponent.Id.FUEL)).refueling().get();
    }

    public void setRefueling(boolean b) {
        ((FuelHandler)this.handler(TardisComponent.Id.FUEL)).refueling().set(b);
    }

    public boolean isInDanger() {
        return ((HadsHandler)this.handler(TardisComponent.Id.HADS)).isInDanger();
    }

    public FuelHandler fuel() {
        return (FuelHandler)this.handler(TardisComponent.Id.FUEL);
    }

    public TardisCrashHandler crash() {
        return (TardisCrashHandler)this.handler(TardisComponent.Id.CRASH_DATA);
    }

    public SequenceHandler sequence() {
        return (SequenceHandler)this.handler(TardisComponent.Id.SEQUENCE);
    }

    public WaypointHandler waypoint() {
        return (WaypointHandler)this.handler(TardisComponent.Id.WAYPOINTS);
    }

    public boolean isUnlocked(Unlockable unlockable) {
        return unlockable.freebie() || this.stats().isUnlocked(unlockable);
    }

    public boolean isGrowth() {
        return this.hasGrowthExterior();
    }

    public boolean hasGrowthExterior() {
        return Objects.equals(this.getExterior().getVariant(), ExteriorVariantRegistry.CORAL_GROWTH);
    }

    public boolean hasGrowthDesktop() {
        return Objects.equals(this.getDesktop().getSchema(), DesktopRegistry.DEFAULT_CAVE);
    }

    public boolean areShieldsActive() {
        return (Boolean)((ShieldHandler)this.handler(TardisComponent.Id.SHIELDS)).shielded().get();
    }

    public boolean areVisualShieldsActive() {
        return (Boolean)((ShieldHandler)this.handler(TardisComponent.Id.SHIELDS)).visuallyShielded().get();
    }

    public SiegeHandler siege() {
        return (SiegeHandler)this.handler(TardisComponent.Id.SIEGE);
    }

    public boolean isSiegeBeingHeld() {
        return ((SiegeHandler)this.handler(TardisComponent.Id.SIEGE)).isSiegeBeingHeld();
    }

    public void setSiegeBeingHeld(UUID b) {
        ((SiegeHandler)this.handler(TardisComponent.Id.SIEGE)).setSiegeBeingHeld(b);
    }

    public String toString() {
        return this.uuid.toString();
    }

    public PermissionHandler permissions() {
        return (PermissionHandler)this.handler(TardisComponent.Id.PERMISSIONS);
    }

    public CloakHandler cloak() {
        return (CloakHandler)this.handler(TardisComponent.Id.CLOAK);
    }

    public LandingPadHandler landingPad() {
        return (LandingPadHandler)this.handler(TardisComponent.Id.LANDING_PAD);
    }

    public SelfDestructHandler selfDestruct() {
        return (SelfDestructHandler)this.handler(TardisComponent.Id.SELF_DESTRUCT);
    }

    public OpinionHandler opinions() {
        return (OpinionHandler)this.handler(TardisComponent.Id.OPINION);
    }

    public SubSystemHandler subsystems() {
        return (SubSystemHandler)this.handler(TardisComponent.Id.SUBSYSTEM);
    }

    public ShieldHandler shields() {
        return (ShieldHandler)this.handler(TardisComponent.Id.SHIELDS);
    }
}

