/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.tardis;

import dev.amble.ait.AITMod;
import dev.amble.ait.api.tardis.TardisComponent;
import dev.amble.ait.api.tardis.TardisEvents;
import dev.amble.ait.core.AITBlocks;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.blockentities.ConsoleBlockEntity;
import dev.amble.ait.core.blockentities.ConsoleGeneratorBlockEntity;
import dev.amble.ait.core.blockentities.DoorBlockEntity;
import dev.amble.ait.core.blockentities.EngineBlockEntity;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.core.tardis.manager.ServerTardisManager;
import dev.amble.ait.core.tardis.util.NetworkUtil;
import dev.amble.ait.core.tardis.util.TardisUtil;
import dev.amble.ait.core.world.QueuedTardisStructureTemplate;
import dev.amble.ait.core.world.TardisServerWorld;
import dev.amble.ait.data.Corners;
import dev.amble.ait.data.schema.desktop.TardisDesktopSchema;
import dev.amble.lib.data.DirectedBlockPos;
import dev.drtheo.queue.api.ActionQueue;
import dev.drtheo.queue.api.util.block.ChunkEraser;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1530;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_4076;
import net.minecraft.class_5321;
import net.minecraft.class_5425;

public class TardisDesktop
extends TardisComponent {
    private static final class_3492 SETTINGS = new class_3492().method_15131(false);
    public static final class_2960 CACHE_CONSOLE = AITMod.id("cache_console");
    private TardisDesktopSchema schema;
    private DirectedBlockPos doorPos;
    private class_2338 enginePos;
    private final Corners corners;
    private final Set<class_2338> consolePos;
    public static final int RADIUS = 500;
    private static final Corners CORNERS;
    private boolean changingDesktop = false;

    public TardisDesktop(TardisDesktopSchema schema) {
        super(TardisComponent.Id.DESKTOP);
        this.schema = schema;
        this.corners = CORNERS;
        this.consolePos = new HashSet<class_2338>();
    }

    @Override
    public void postInit(TardisComponent.InitContext ctx) {
        if (!ctx.created()) {
            return;
        }
        this.changeInterior(this.schema, false, false).execute();
    }

    public TardisDesktopSchema getSchema() {
        return this.schema;
    }

    public void setDoorPos(DoorBlockEntity door) {
        if (door == null || door.method_10997() == null || door.method_10997().method_8608()) {
            return;
        }
        DirectedBlockPos pos = door.getDirectedPos();
        if (this.doorPos != null && this.doorPos.equals((Object)pos)) {
            return;
        }
        this.doorPos = pos;
        ((TardisEvents.MoveDoor)TardisEvents.DOOR_MOVE.invoker()).onMove(this.tardis.asServer(), pos, this.doorPos);
    }

    public void setEnginePos(EngineBlockEntity engine) {
        if (engine == null || engine.method_10997() == null || engine.method_10997().method_8608()) {
            return;
        }
        class_2338 pos = engine.method_11016();
        if (pos.equals((Object)this.enginePos)) {
            return;
        }
        this.enginePos = pos;
        ((TardisEvents.MoveEngine)TardisEvents.ENGINE_MOVE.invoker()).onMove(this.tardis.asServer(), pos, this.enginePos);
    }

    public void removeDoor(DoorBlockEntity door) {
        if (this.doorPos == null) {
            return;
        }
        if (!this.doorPos.equals((Object)door.getDirectedPos())) {
            return;
        }
        this.doorPos = null;
        ((TardisEvents.BreakDoor)TardisEvents.BREAK_DOOR.invoker()).onBreak(this.tardis, this.doorPos);
    }

    public DirectedBlockPos getDoorPos() {
        if (this.doorPos == null) {
            Iterator<class_2338> iterator = this.consolePos.iterator();
            if (iterator.hasNext()) {
                class_2338 consolePos = iterator.next();
                return DirectedBlockPos.create((class_2338)consolePos, (byte)0);
            }
            return DirectedBlockPos.create((class_2338)class_2338.field_10980, (byte)0);
        }
        return this.doorPos;
    }

    public class_2338 getEnginePos() {
        return this.enginePos;
    }

    @Deprecated(forRemoval=true, since="1.1.0")
    public Corners getCorners() {
        return this.corners;
    }

    public Optional<ActionQueue> createInteriorChangeQueue(TardisDesktopSchema schema, boolean sendEvent) {
        long start = System.currentTimeMillis();
        this.schema = schema;
        if (sendEvent) {
            ((TardisEvents.ReconfigureDesktop)TardisEvents.RECONFIGURE_DESKTOP.invoker()).reconfigure(this.tardis);
        }
        ServerTardis tardis = this.tardis.asServer();
        TardisServerWorld world = tardis.world();
        Optional<class_3499> optional = this.schema.findTemplate();
        if (optional.isEmpty()) {
            AITMod.LOGGER.error("Failed to find template for {}", (Object)this.schema.id());
            return Optional.empty();
        }
        QueuedTardisStructureTemplate template = new QueuedTardisStructureTemplate(optional.get(), tardis);
        Optional optionalQueue = template.place((class_5425)world, class_2338.method_49638((class_2374)this.corners.getBox().method_1005()), class_2338.method_49638((class_2374)this.corners.getBox().method_1005()), SETTINGS, world.method_8409(), 16);
        optionalQueue.ifPresentOrElse(queue -> queue.thenRun(() -> AITMod.LOGGER.warn("Time taken to generate interior: {}ms", (Object)(System.currentTimeMillis() - start))), () -> AITMod.LOGGER.error("Failed to generate interior for {}", (Object)this.tardis.getUuid()));
        return optionalQueue;
    }

    public ActionQueue createDesktopClearQueue() {
        ServerTardis tardis = this.tardis.asServer();
        TardisServerWorld world = tardis.world();
        int chunkRadius = class_4076.method_18675((int)500);
        TardisUtil.getEntitiesInBox(class_1530.class, (class_1937)world, this.corners.getBox(), frame -> true).forEach(frame -> frame.method_5650(class_1297.class_5529.field_26999));
        return new ChunkEraser.Builder().withFlags(16).build((class_3218)world, -chunkRadius, -chunkRadius, chunkRadius, chunkRadius).thenRun(() -> {
            this.consolePos.clear();
            this.doorPos = null;
        });
    }

    public void startQueue(boolean interact) {
        if (interact) {
            this.tardis.door().interactLock(true, null, false);
        }
        this.tardis.door().setDeadlocked(true);
        this.tardis.alarm().enable();
    }

    private void completeQueue() {
        this.tardis.door().setLocked(false);
        this.tardis.door().setDeadlocked(false);
        this.tardis.alarm().disable();
        this.changingDesktop = false;
    }

    public ActionQueue changeInterior(TardisDesktopSchema schema, boolean clear, boolean sendEvent) {
        this.changingDesktop = true;
        ActionQueue queue = new ActionQueue().thenRun(() -> this.startQueue(sendEvent));
        if (clear) {
            queue.thenRun(this.createDesktopClearQueue());
        }
        return queue.thenRun(this.createInteriorChangeQueue(schema, sendEvent)).thenRun(this::completeQueue);
    }

    public void cacheConsole(class_2338 consolePos) {
        TardisServerWorld dim = this.tardis.asServer().world();
        dim.method_8396(null, consolePos, class_3417.field_19344, class_3419.field_15245, 0.5f, 1.0f);
        class_2586 class_25862 = dim.method_8321(consolePos);
        if (class_25862 instanceof ConsoleBlockEntity) {
            ConsoleBlockEntity entity = (ConsoleBlockEntity)class_25862;
            ConsoleGeneratorBlockEntity generator = new ConsoleGeneratorBlockEntity(consolePos, AITBlocks.CONSOLE_GENERATOR.method_9564(), entity.getTypeSchema().id(), entity.getVariant().id());
            entity.onBroken();
            dim.method_8650(consolePos, false);
            dim.method_8544(consolePos);
            dim.method_8652(consolePos, AITBlocks.CONSOLE_GENERATOR.method_9564(), 3);
            dim.method_8438(generator);
        }
    }

    public static void playSoundAtConsole(class_1937 dim, class_2338 console, class_3414 sound, class_3419 category, float volume, float pitch) {
        dim.method_8396(null, console, sound, category, volume, pitch);
    }

    public void playSoundAtEveryConsole(class_3414 sound, class_3419 category, float volume, float pitch) {
        if (!this.isServer()) {
            return;
        }
        TardisServerWorld world = this.tardis.asServer().world();
        this.getConsolePos().forEach(arg_0 -> TardisDesktop.lambda$playSoundAtEveryConsole$9((class_3218)world, sound, category, volume, pitch, arg_0));
    }

    public void forcePlaySoundAtEveryConsole(class_2960 soundId, class_3419 category) {
        if (!this.isServer()) {
            return;
        }
        class_5321 worldKey = this.tardis.asServer().world().method_27983();
        this.getConsolePos().forEach(consolePos -> NetworkUtil.playSound((class_5321<class_1937>)worldKey, consolePos, soundId, category, 1.0f));
    }

    public void playSoundAtEveryConsole(class_3414 sound, class_3419 category) {
        this.playSoundAtEveryConsole(sound, category, 1.0f, 1.0f);
    }

    public void playSoundAtEveryConsole(class_3414 sound) {
        this.playSoundAtEveryConsole(sound, class_3419.field_15245);
    }

    public Set<class_2338> getConsolePos() {
        return this.consolePos;
    }

    public boolean isChanging() {
        return this.changingDesktop;
    }

    private static /* synthetic */ void lambda$playSoundAtEveryConsole$9(class_3218 world, class_3414 sound, class_3419 category, float volume, float pitch, class_2338 consolePos) {
        TardisDesktop.playSoundAtConsole((class_1937)world, consolePos, sound, category, volume, pitch);
    }

    static {
        class_2338 first = new class_2338(500, 0, 500);
        CORNERS = new Corners(first.method_35830(-1), first);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)CACHE_CONSOLE, (ServerPlayNetworking.PlayChannelHandler)ServerTardisManager.receiveTardis((tardis, server, player, handler, buf, responseSender) -> {
            class_2338 console = buf.method_10811();
            server.execute(() -> {
                class_2586 patt0$temp = player.method_37908().method_8321(console);
                if (!(patt0$temp instanceof ConsoleBlockEntity)) {
                    return;
                }
                ConsoleBlockEntity consoleBlockEntity = (ConsoleBlockEntity)patt0$temp;
                if (tardis == null) {
                    return;
                }
                if (consoleBlockEntity.isLinked() && consoleBlockEntity.getSonicScrewdriver() != null && !consoleBlockEntity.getSonicScrewdriver().method_7960()) {
                    player.method_37908().method_8396(null, player.method_24515(), AITSounds.BWEEP, class_3419.field_15248, 1.0f, 1.0f);
                    player.method_7353((class_2561)class_2561.method_43471((String)"tardis.message.console.has_sonic_in_port"), true);
                    return;
                }
                tardis.getDesktop().cacheConsole(console);
            });
        }));
    }
}

