/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.tardis;

import dev.amble.ait.AITMod;
import dev.amble.ait.api.tardis.TardisComponent;
import dev.amble.ait.api.tardis.TardisEvents;
import dev.amble.ait.client.tardis.ClientTardis;
import dev.amble.ait.client.util.ClientTardisUtil;
import dev.amble.ait.core.blockentities.ExteriorBlockEntity;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.manager.ServerTardisManager;
import dev.amble.ait.core.tardis.util.NetworkUtil;
import dev.amble.ait.core.util.StackUtil;
import dev.amble.ait.data.schema.exterior.ExteriorCategorySchema;
import dev.amble.ait.data.schema.exterior.ExteriorVariantSchema;
import dev.amble.ait.registry.impl.CategoryRegistry;
import dev.amble.ait.registry.impl.exterior.ExteriorVariantRegistry;
import dev.amble.lib.data.CachedDirectedGlobalPos;
import java.util.Optional;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5321;

public class TardisExterior
extends TardisComponent {
    public static final class_2960 CHANGE_EXTERIOR = AITMod.id("change_exterior");
    private static final ExteriorCategorySchema MISSING_CATEGORY = CategoryRegistry.getInstance().fallback();
    private static final ExteriorVariantSchema MISSING_VARIANT = ExteriorVariantRegistry.getInstance().fallback();
    private ExteriorCategorySchema category;
    private ExteriorVariantSchema variant;

    private boolean update(ExteriorVariantSchema variant, boolean variantChange) {
        if (!this.tardis.isUnlocked(variant)) {
            return false;
        }
        this.tardis.getExterior().setType(variant.category());
        if (variantChange) {
            this.tardis.getExterior().setVariant(variant);
        }
        CachedDirectedGlobalPos cached = this.tardis.travel().position();
        cached.getWorld().method_14178().method_14128(cached.getPos());
        ((TardisEvents.OnExteriorChange)TardisEvents.EXTERIOR_CHANGE.invoker()).onChange(this.tardis);
        return true;
    }

    public TardisExterior(ExteriorVariantSchema variant) {
        super(TardisComponent.Id.EXTERIOR);
        this.category = variant.category();
        this.variant = variant;
    }

    private void setMissing() {
        Tardis tardis = this.tardis;
        if (tardis instanceof ClientTardis) {
            ClientTardis clientTardis = (ClientTardis)tardis;
            ClientTardisUtil.changeExteriorWithScreen(clientTardis, MISSING_VARIANT.id(), true);
        }
        this.category = MISSING_CATEGORY;
        this.variant = MISSING_VARIANT;
    }

    public ExteriorCategorySchema getCategory() {
        if (this.category == null) {
            this.setMissing();
        }
        return this.category;
    }

    public ExteriorVariantSchema getVariant() {
        if (this.variant == null) {
            this.setMissing();
        }
        return this.variant;
    }

    public void setType(ExteriorCategorySchema exterior) {
        this.category = exterior;
        if (exterior != this.getVariant().category()) {
            this.setVariant(ExteriorVariantRegistry.getInstance().pickRandomWithParent(exterior));
        }
        this.sync();
    }

    public void setVariant(ExteriorVariantSchema variant) {
        this.variant = variant;
        this.sync();
    }

    public Optional<ExteriorBlockEntity> findExteriorBlock() {
        CachedDirectedGlobalPos pos = this.tardis.travel().position();
        if (pos.getWorld() == null || pos.getWorld().method_8608()) {
            return Optional.empty();
        }
        class_2586 found = pos.getWorld().method_8321(pos.getPos());
        if (!(found instanceof ExteriorBlockEntity)) {
            return Optional.empty();
        }
        ExteriorBlockEntity exterior = (ExteriorBlockEntity)found;
        return Optional.of(exterior);
    }

    public void playSound(class_3414 sound, class_3419 category, float volume, float pitch) {
        CachedDirectedGlobalPos pos = this.tardis.travel().position();
        if (pos == null || pos.getWorld() == null) {
            return;
        }
        pos.getWorld().method_8396(null, pos.getPos(), sound, category, volume, pitch);
    }

    public void playSound(class_3414 sound, class_3419 category) {
        this.playSound(sound, category, 1.0f, 1.0f);
    }

    public void playSound(class_3414 sound) {
        this.playSound(sound, class_3419.field_15245);
    }

    public void playSound(class_2960 soundId, class_3419 category, float volume) {
        CachedDirectedGlobalPos pos = this.tardis.travel().position();
        NetworkUtil.playSound((class_5321<class_1937>)pos.getDimension(), pos.getPos(), soundId, category, volume);
    }

    static {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)CHANGE_EXTERIOR, (ServerPlayNetworking.PlayChannelHandler)ServerTardisManager.receiveTardis((tardis, server, player, handler, buf, responseSender) -> {
            boolean variantChange = buf.readBoolean();
            class_2960 variantValue = buf.method_10810();
            ExteriorVariantSchema schema = (ExteriorVariantSchema)ExteriorVariantRegistry.getInstance().get(variantValue);
            server.execute(() -> {
                if (!tardis.getExterior().update(schema, variantChange)) {
                    return;
                }
                StackUtil.playBreak((class_1657)player);
            });
        }));
    }
}

