/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.tardis;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import dev.amble.ait.AITMod;
import dev.amble.ait.api.tardis.TardisComponent;
import dev.amble.ait.api.tardis.TardisTickable;
import dev.amble.ait.data.Exclude;
import dev.amble.ait.data.enummap.ConcurrentEnumMap;
import dev.amble.ait.registry.impl.TardisComponentRegistry;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;

public class TardisHandlersManager
extends TardisComponent
implements TardisTickable {
    @Exclude
    private final ConcurrentEnumMap<TardisComponent.IdLike, TardisComponent> handlers = new ConcurrentEnumMap(TardisComponentRegistry::values, TardisComponent[]::new);

    public TardisHandlersManager() {
        super(TardisComponent.Id.HANDLERS);
    }

    @Override
    public void onCreate() {
        TardisComponentRegistry.getInstance().fill(this::createHandler);
    }

    @Override
    protected void onInit(TardisComponent.InitContext ctx) {
        this.forEach(component -> TardisComponent.init(component, this.tardis, ctx));
    }

    @Override
    public void postInit(TardisComponent.InitContext ctx) {
        this.forEach(component -> component.postInit(ctx));
    }

    private void forEach(Consumer<TardisComponent> consumer) {
        for (TardisComponent component : (TardisComponent[])this.handlers.getValues()) {
            if (component == null) continue;
            consumer.accept(component);
        }
    }

    private void createHandler(TardisComponent component) {
        this.handlers.put(component.getId(), component);
    }

    @Override
    public void tick(MinecraftServer server) {
        this.forEach(component -> {
            if (!(component instanceof TardisTickable)) {
                return;
            }
            TardisTickable tickable = (TardisTickable)((Object)component);
            try {
                tickable.tick(server);
            }
            catch (Exception e) {
                AITMod.LOGGER.error("Ticking failed for {} | {}", new Object[]{component.getId().name(), component.tardis().getUuid().toString(), e});
            }
        });
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void tick(class_310 client) {
        this.forEach(component -> {
            if (!(component instanceof TardisTickable)) {
                return;
            }
            TardisTickable tickable = (TardisTickable)((Object)component);
            try {
                tickable.tick(client);
            }
            catch (Exception e) {
                AITMod.LOGGER.error("Ticking failed for {} | {}", new Object[]{component.getId().name(), component.tardis().getUuid().toString(), e});
            }
        });
    }

    @Deprecated
    @ApiStatus.Internal
    public <T extends TardisComponent> T get(TardisComponent.IdLike id) {
        return (T)this.handlers.get(id);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.forEach(TardisComponent::dispose);
        this.handlers.clear();
    }

    @ApiStatus.Internal
    public <T extends TardisComponent> void set(T t) {
        this.handlers.put(t.getId(), t);
    }

    public static Object serializer() {
        return new Serializer();
    }

    static class Serializer
    implements JsonSerializer<TardisHandlersManager>,
    JsonDeserializer<TardisHandlersManager> {
        Serializer() {
        }

        public TardisHandlersManager deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            TardisHandlersManager manager = new TardisHandlersManager();
            Map map = json.getAsJsonObject().asMap();
            TardisComponentRegistry registry = TardisComponentRegistry.getInstance();
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                JsonElement element = (JsonElement)entry.getValue();
                TardisComponent.IdLike id = registry.get(key);
                if (id == null) {
                    AITMod.LOGGER.error("Can't find a component id with name '{}'!", (Object)key);
                    continue;
                }
                manager.set((TardisComponent)context.deserialize(element, id.clazz()));
            }
            for (int i = 0; i < manager.handlers.size(); ++i) {
                if (manager.handlers.get(i) != null) continue;
                TardisComponent.IdLike id = registry.get(i);
                AITMod.LOGGER.debug("Appending new component {}", (Object)id);
                manager.set(id.create());
            }
            return manager;
        }

        public JsonElement serialize(TardisHandlersManager manager, Type type, JsonSerializationContext context) {
            JsonObject result = new JsonObject();
            manager.forEach(component -> {
                TardisComponent.IdLike idLike = component.getId();
                if (idLike == null) {
                    AITMod.LOGGER.error("Id was null for {}", component.getClass());
                    return;
                }
                result.add(idLike.name(), context.serialize(component));
            });
            return result;
        }
    }
}

