/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.tardis;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.amble.ait.AITMod;
import dev.amble.ait.api.tardis.TardisComponent;
import dev.amble.ait.client.tardis.manager.ClientTardisManager;
import dev.amble.ait.core.engine.SubSystem;
import dev.amble.ait.core.engine.registry.SubSystemRegistry;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.TardisHandlersManager;
import dev.amble.ait.core.tardis.animation.v2.TardisAnimation;
import dev.amble.ait.core.tardis.animation.v2.TardisAnimationMap;
import dev.amble.ait.core.tardis.handler.SubSystemHandler;
import dev.amble.ait.core.tardis.handler.permissions.Permission;
import dev.amble.ait.core.tardis.handler.permissions.PermissionLike;
import dev.amble.ait.core.tardis.manager.ServerTardisManager;
import dev.amble.ait.data.Corners;
import dev.amble.ait.data.Exclude;
import dev.amble.ait.data.TardisMap;
import dev.amble.ait.data.gson.BlockPosSerializer;
import dev.amble.ait.data.gson.GlobalPosSerializer;
import dev.amble.ait.data.gson.IdentifierSerializer;
import dev.amble.ait.data.gson.ItemStackSerializer;
import dev.amble.ait.data.gson.NbtSerializer;
import dev.amble.ait.data.gson.RegistryKeySerializer;
import dev.amble.ait.data.properties.Value;
import dev.amble.ait.data.properties.bool.BoolValue;
import dev.amble.ait.data.properties.dbl.DoubleValue;
import dev.amble.ait.data.properties.integer.IntValue;
import dev.amble.ait.data.properties.integer.ranged.RangedIntValue;
import dev.amble.ait.data.schema.console.ConsoleTypeSchema;
import dev.amble.ait.data.schema.console.ConsoleVariantSchema;
import dev.amble.ait.data.schema.desktop.TardisDesktopSchema;
import dev.amble.ait.data.schema.door.DoorSchema;
import dev.amble.ait.data.schema.exterior.ExteriorCategorySchema;
import dev.amble.ait.data.schema.exterior.ExteriorVariantSchema;
import dev.amble.ait.registry.impl.TardisComponentRegistry;
import dev.amble.lib.data.DirectedBlockPos;
import dev.amble.lib.data.DirectedGlobalPos;
import java.util.Collection;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public abstract class TardisManager<T extends Tardis, C> {
    public static final class_2960 SEND_PROPERTY = AITMod.id("send_property");
    public static final class_2960 ASK = AITMod.id("ask_tardis");
    public static final class_2960 SEND = AITMod.id("tardis/send");
    public static final class_2960 SEND_BULK = AITMod.id("tardis/send_bulk");
    public static final class_2960 REMOVE = AITMod.id("tardis/remove");
    public static final class_2960 SEND_COMPONENT = AITMod.id("tardis/send_component");
    public static final boolean DEMENTIA = false;
    protected final Gson networkGson = this.getNetworkGson(this.createGsonBuilder(Exclude.Strategy.NETWORK)).create();
    protected final Gson fileGson = this.getFileGson(this.createGsonBuilder(Exclude.Strategy.FILE)).create();

    protected TardisManager() {
    }

    protected GsonBuilder createGsonBuilder(final Exclude.Strategy strategy) {
        return new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new ExclusionStrategy(){

            public boolean shouldSkipField(FieldAttributes field) {
                Exclude exclude = (Exclude)field.getAnnotation(Exclude.class);
                if (exclude == null) {
                    return false;
                }
                Exclude.Strategy excluded = exclude.strategy();
                return excluded == Exclude.Strategy.ALL || excluded == strategy;
            }

            public boolean shouldSkipClass(Class<?> clazz) {
                return false;
            }
        }}).registerTypeAdapter(TardisDesktopSchema.class, TardisDesktopSchema.serializer()).registerTypeAdapter(ExteriorVariantSchema.class, ExteriorVariantSchema.serializer()).registerTypeAdapter(DoorSchema.class, DoorSchema.serializer()).registerTypeAdapter(ExteriorCategorySchema.class, ExteriorCategorySchema.serializer()).registerTypeAdapter(ConsoleTypeSchema.class, ConsoleTypeSchema.serializer()).registerTypeAdapter(ConsoleVariantSchema.class, ConsoleVariantSchema.serializer()).registerTypeAdapter(Corners.class, Corners.serializer()).registerTypeAdapter(PermissionLike.class, Permission.serializer()).registerTypeAdapter(DirectedGlobalPos.class, DirectedGlobalPos.serializer()).registerTypeAdapter(DirectedBlockPos.class, DirectedBlockPos.serializer()).registerTypeAdapter(class_2487.class, (Object)new NbtSerializer()).registerTypeAdapter(class_1799.class, (Object)new ItemStackSerializer()).registerTypeAdapter(class_2960.class, (Object)new IdentifierSerializer()).registerTypeAdapter(class_4208.class, (Object)new GlobalPosSerializer()).registerTypeAdapter(class_2338.class, (Object)new BlockPosSerializer()).registerTypeAdapter(class_5321.class, (Object)new RegistryKeySerializer()).registerTypeAdapter(TardisHandlersManager.class, TardisHandlersManager.serializer()).registerTypeAdapter(TardisComponent.IdLike.class, TardisComponentRegistry.idSerializer()).registerTypeAdapter(SubSystemHandler.class, SubSystemHandler.serializer()).registerTypeAdapter(SubSystem.IdLike.class, SubSystemRegistry.idSerializer()).registerTypeAdapter(SubSystem.class, SubSystem.serializer()).registerTypeAdapter(TardisAnimationMap.class, TardisAnimationMap.serializer()).registerTypeAdapter(TardisAnimation.class, TardisAnimation.serializer());
    }

    protected GsonBuilder getNetworkGson(GsonBuilder builder) {
        return builder;
    }

    protected GsonBuilder getFileGson(GsonBuilder builder) {
        if (!AITMod.CONFIG.minifyJson) {
            builder.setPrettyPrinting();
        }
        return builder.registerTypeAdapter(Value.class, Value.serializer()).registerTypeAdapter(BoolValue.class, BoolValue.serializer()).registerTypeAdapter(IntValue.class, IntValue.serializer()).registerTypeAdapter(RangedIntValue.class, RangedIntValue.serializer()).registerTypeAdapter(DoubleValue.class, DoubleValue.serializer());
    }

    public static TardisManager<?, ?> getInstance(class_1297 entity) {
        return TardisManager.getInstance(entity.method_37908());
    }

    public static TardisManager<?, ?> getInstance(class_2586 entity) {
        return TardisManager.getInstance(entity.method_10997());
    }

    public static TardisManager<?, ?> getInstance(class_1937 world) {
        return TardisManager.getInstance(!world.method_8608());
    }

    public static TardisManager<?, ?> getInstance(Tardis tardis) {
        return TardisManager.getInstance(tardis instanceof ServerTardis);
    }

    public static TardisManager<?, ?> getInstance(boolean isServer) {
        return isServer ? ServerTardisManager.getInstance() : ClientTardisManager.getInstance();
    }

    public static <C, R> R with(class_2586 entity, ContextManager<C, R> consumer) {
        return TardisManager.with(entity.method_10997(), consumer);
    }

    public static <C, R> R with(class_1297 entity, ContextManager<C, R> consumer) {
        return TardisManager.with(entity.method_37908(), consumer);
    }

    public static <C, R> R with(class_1937 world, ContextManager<C, R> consumer) {
        return TardisManager.with(world.method_8608(), consumer, () -> ((class_1937)world).method_8503());
    }

    public static <C, R> R with(boolean isClient, ContextManager<C, R> consumer, Supplier<MinecraftServer> server) {
        TardisManager<?, ?> manager = TardisManager.getInstance(!isClient);
        if (isClient) {
            return consumer.run(class_310.method_1551(), manager);
        }
        return consumer.run((class_310)server.get(), (TardisManager<?, class_310>)manager);
    }

    public abstract void getTardis(C var1, UUID var2, Consumer<T> var3);

    @Deprecated
    @Nullable
    public abstract T demandTardis(C var1, UUID var2);

    protected abstract TardisMap<?> lookup();

    public void reset() {
        this.lookup().clear();
    }

    public Collection<UUID> ids() {
        return this.lookup().keySet();
    }

    public abstract void forEach(Consumer<T> var1);

    public Gson getNetworkGson() {
        return this.networkGson;
    }

    public Gson getFileGson() {
        return this.fileGson;
    }

    @FunctionalInterface
    public static interface ContextManager<C, R> {
        public R run(C var1, TardisManager<?, C> var2);
    }
}

