/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.tardis.animation.v2;

import dev.amble.ait.AITMod;
import dev.amble.ait.api.tardis.Disposable;
import dev.amble.ait.api.tardis.TardisTickable;
import dev.amble.ait.api.tardis.link.v2.Linkable;
import dev.amble.ait.api.tardis.link.v2.TardisRef;
import dev.amble.ait.client.sounds.ClientSoundManager;
import dev.amble.ait.client.sounds.flight.FlightSoundPlayer;
import dev.amble.ait.core.effects.ZeitonHighEffect;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.TardisManager;
import dev.amble.ait.core.tardis.animation.v2.TardisAnimation;
import dev.amble.ait.core.tardis.animation.v2.TardisAnimationMap;
import dev.amble.ait.core.tardis.handler.travel.TravelHandlerBase;
import dev.amble.ait.core.tardis.util.NetworkUtil;
import dev.amble.ait.data.Exclude;
import dev.amble.ait.data.Loyalty;
import dev.amble.ait.data.enummap.EnumMap;
import dev.amble.lib.util.ServerLifecycleHooks;
import dev.drtheo.queue.api.ActionQueue;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_746;
import net.minecraft.server.MinecraftServer;
import org.joml.Math;
import org.joml.Vector3f;

public class AnimationHolder
implements TardisTickable,
Disposable,
Linkable {
    public static final class_2960 UPDATE_PACKET = AITMod.id("sync/ext_anim");
    protected final TardisAnimationMap map;
    private TardisAnimation current;
    private float alphaOverride = -1.0f;
    public static final double MAX_CLOAK_DISTANCE = 5.0;
    @Exclude
    private boolean isServer = true;
    private TardisRef ref;

    public AnimationHolder(TardisAnimationMap map) {
        this.map = map;
    }

    public AnimationHolder(Tardis tardis) {
        this(TardisAnimationMap.forTardis(tardis));
        this.link(tardis);
    }

    public int getTicks() {
        return this.current == null ? 0 : this.current.getTicks();
    }

    protected TardisAnimation getCurrent() {
        return this.current;
    }

    public boolean isRunning() {
        return this.current != null && !this.current.isAged();
    }

    public boolean setAnimation(TardisAnimation anim) {
        if (this.isLinked() && anim.getExpectedState() != this.tardis().get().travel().getState()) {
            AITMod.LOGGER.error("Tried to force animation {} but the tardis is in state {} which is unexpected!", (Object)anim.id(), (Object)this.tardis().get().travel().getState());
            return false;
        }
        Tardis tardis = this.tardis().get();
        if (this.current != null) {
            this.current.dispose();
        }
        this.current = anim.instantiate();
        this.alphaOverride = -1.0f;
        if (this.isLinked()) {
            this.current.link(tardis);
            this.sync(tardis.travel().getState());
        }
        return true;
    }

    public ActionQueue onDone() {
        if (this.current == null) {
            return null;
        }
        return this.current.onDone();
    }

    @Override
    public void tick(MinecraftServer server) {
        if (this.current == null) {
            return;
        }
        this.current.tick(server);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void tick(class_310 client) {
        this.isServer = false;
        if (this.current == null) {
            return;
        }
        this.current.tick(client);
    }

    @Override
    public boolean isAged() {
        if (this.current == null) {
            return true;
        }
        return this.current.isAged();
    }

    @Override
    public void age() {
        this.current.age();
    }

    @Override
    public void dispose() {
        this.current.dispose();
        this.alphaOverride = -1.0f;
    }

    @Override
    public void link(UUID uuid) {
        this.ref = new TardisRef(uuid, real -> TardisManager.with(!this.isServer, (o, manager) -> manager.demandTardis(o, (UUID)real), ServerLifecycleHooks::get));
    }

    @Override
    public void link(Tardis tardis) {
        this.ref = new TardisRef(tardis, real -> TardisManager.with(!this.isServer, (o, manager) -> manager.demandTardis(o, (UUID)real), ServerLifecycleHooks::get));
        this.isServer = tardis instanceof ServerTardis;
    }

    @Override
    public TardisRef tardis() {
        return this.ref;
    }

    public void onStateChange(TravelHandlerBase.State state) {
        TardisAnimation animation = (TardisAnimation)((EnumMap)this.map).get(state);
        if (state == TravelHandlerBase.State.LANDED) {
            this.alphaOverride = 1.0f;
            return;
        }
        if (state == TravelHandlerBase.State.FLIGHT) {
            this.alphaOverride = 0.0f;
            return;
        }
        if (animation == null) {
            switch (state) {
                case DEMAT: {
                    this.alphaOverride = 1.0f;
                }
                case MAT: {
                    this.alphaOverride = 0.0f;
                }
            }
            return;
        }
        this.alphaOverride = -1.0f;
        if (this.current != null) {
            this.current.dispose();
        }
        animation.dispose();
        this.current = animation.instantiate();
        if (this.isLinked()) {
            this.current.link(this.tardis().get());
        }
        this.sync(state);
    }

    public float getAlpha(float delta) {
        if (this.isLinked()) {
            Tardis tardis = this.tardis().get();
            if (((Boolean)tardis.cloak().cloaked().get()).booleanValue()) {
                return this.cloakAlpha(tardis);
            }
            if (tardis.travel().isLanded() && tardis.travel().handbrake() && tardis.travel().speed() > 0) {
                return this.handbrakeAlpha(tardis);
            }
        }
        if (this.alphaOverride != -1.0f) {
            return this.alphaOverride;
        }
        if (this.current == null) {
            return 1.0f;
        }
        return this.current.getAlpha(delta);
    }

    private float cloakAlpha(Tardis tardis) {
        if (FabricLoader.getInstance().getEnvironmentType() != EnvType.CLIENT) {
            return 0.0f;
        }
        return this.getCloakAlpha(tardis);
    }

    @Environment(value=EnvType.CLIENT)
    private float getCloakAlpha(Tardis tardis) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return 0.0f;
        }
        double distance = AnimationHolder.distanceFromTardis((class_1657)player, tardis);
        if (distance >= 5.0) {
            return 0.0f;
        }
        boolean companion = tardis.loyalty().get((class_1657)player).isOf(Loyalty.Type.COMPANION);
        float distanceAlpha = 1.0f - (float)(distance / 5.0);
        float base = 1.0f;
        if (!companion) {
            base = ZeitonHighEffect.isHigh((class_1309)player) ? 0.105f : 0.0f;
        }
        return distanceAlpha * base;
    }

    public static double distanceFromTardis(class_1657 player, Tardis tardis) {
        class_2338 pPos = player.method_24515();
        class_2338 tPos = tardis.travel().position().getPos();
        return Math.sqrt((double)tPos.method_10262((class_2382)pPos));
    }

    private float handbrakeAlpha(Tardis tardis) {
        if (FabricLoader.getInstance().getEnvironmentType() != EnvType.CLIENT) {
            return 0.5f;
        }
        return this.getHandbrakeAlpha(tardis);
    }

    @Environment(value=EnvType.CLIENT)
    private float getHandbrakeAlpha(Tardis tardis) {
        FlightSoundPlayer sfx = ClientSoundManager.getFlight().getFlightLoop(tardis.asClient());
        if (sfx == null) {
            return 0.5f;
        }
        float progress = sfx.getProgress();
        return (float)(Math.cos((double)(2.0 * ((double)progress * java.lang.Math.PI))) * (double)0.15f + (double)0.85f);
    }

    public Vector3f getScale(float delta) {
        if (this.current == null) {
            if (this.isLinked()) {
                return this.tardis().get().stats().getScale();
            }
            return new Vector3f(1.0f, 1.0f, 1.0f);
        }
        return this.current.getScale(delta);
    }

    public Vector3f getPosition(float delta) {
        if (this.current == null) {
            return new Vector3f(0.0f, 0.0f, 0.0f);
        }
        return this.current.getPosition(delta);
    }

    public Vector3f getRotation(float delta) {
        if (this.current == null) {
            return new Vector3f(0.0f, 0.0f, 0.0f);
        }
        return this.current.getRotation(delta);
    }

    private void sync(TravelHandlerBase.State state) {
        if (!(ServerLifecycleHooks.isServer() && this.isLinked() && this.tardis().get() instanceof ServerTardis)) {
            return;
        }
        ServerTardis tardis = this.tardis().get().asServer();
        class_2540 buf = PacketByteBufs.create();
        buf.method_10817((Enum)state);
        buf.method_10812(this.current.id());
        buf.method_10797(tardis.getUuid());
        NetworkUtil.getSubscribedPlayers(tardis).forEach(player -> NetworkUtil.send(player, UPDATE_PACKET, buf));
    }
}

