/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.tardis.animation.v2;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.animation.v2.TardisAnimation;
import dev.amble.ait.core.tardis.animation.v2.datapack.TardisAnimationRegistry;
import dev.amble.ait.core.tardis.handler.travel.TravelHandlerBase;
import dev.amble.ait.data.enummap.EnumMap;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.class_2960;

public class TardisAnimationMap
extends EnumMap.Compliant<TravelHandlerBase.State, TardisAnimation> {
    public TardisAnimationMap() {
        super(TravelHandlerBase.State::values, TardisAnimationMap::createArray);
    }

    private static TardisAnimation[] createArray(int length) {
        Object[] array = new TardisAnimation[length];
        TardisAnimation fallback = TardisAnimationRegistry.getInstance().fallback();
        Arrays.fill(array, fallback.instantiate());
        return array;
    }

    public TardisAnimationMap of(TravelHandlerBase.State state, TardisAnimation sound) {
        ((EnumMap)this).put(state, sound);
        return this;
    }

    public TardisAnimationMap of(TravelHandlerBase.State state, class_2960 id) {
        return this.of(state, TardisAnimationRegistry.getInstance().instantiate(id));
    }

    public static TardisAnimationMap forTardis(Tardis tardis) {
        TardisAnimationMap map = new TardisAnimationMap();
        for (TravelHandlerBase.State state : TravelHandlerBase.State.values()) {
            map.of(state, tardis.travel().getAnimationIdFor(state));
        }
        return map;
    }

    public static Object serializer() {
        return new Serializer();
    }

    public static class Serializer
    implements JsonSerializer<TardisAnimationMap>,
    JsonDeserializer<TardisAnimationMap> {
        public TardisAnimationMap deserialize(JsonElement element, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            Map map = element.getAsJsonObject().asMap();
            TardisAnimationMap result = new TardisAnimationMap();
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                JsonElement value = (JsonElement)entry.getValue();
                TravelHandlerBase.State state = TravelHandlerBase.State.valueOf(key);
                TardisAnimation animation = (TardisAnimation)jsonDeserializationContext.deserialize(value, TardisAnimation.class);
                ((EnumMap)result).put(state, animation);
            }
            return result;
        }

        public JsonElement serialize(TardisAnimationMap tardisAnimationMap, Type type, JsonSerializationContext jsonSerializationContext) {
            JsonObject result = new JsonObject();
            tardisAnimationMap.forEach((state, animation) -> {
                if (animation == null) {
                    return;
                }
                JsonElement element = jsonSerializationContext.serialize(animation);
                result.add(state.name(), element);
            });
            return result;
        }
    }
}

