/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.tardis.animation.v2.blockbench;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.amble.ait.AITMod;
import dev.amble.ait.core.tardis.animation.v2.keyframe.AnimationKeyframe;
import dev.amble.ait.core.tardis.animation.v2.keyframe.KeyframeTracker;
import dev.amble.lib.AmbleKit;
import dev.amble.lib.util.ServerLifecycleHooks;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3545;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;
import org.joml.Vector3f;

public class BlockbenchParser
implements SimpleSynchronousResourceReloadListener {
    private static final class_2960 SYNC = AITMod.id("blockbench_sync");
    private final HashMap<class_2960, Result> tardisAnimations = new HashMap();
    private final ConcurrentHashMap<String, List<JsonObject>> tardisAnimationsRaw = new ConcurrentHashMap();
    private static final BlockbenchParser instance = new BlockbenchParser();

    private BlockbenchParser() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)this);
        ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.register((player, joined) -> this.sync(player));
    }

    public static BlockbenchParser getInstance() {
        return instance;
    }

    public static void init() {
        if (EnvType.CLIENT == FabricLoader.getInstance().getEnvironmentType()) {
            BlockbenchParser.initClient();
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static void initClient() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SYNC, (client, handler, buf, responseSender) -> BlockbenchParser.getInstance().receive(buf));
    }

    private class_2540 toBuf() {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(this.tardisAnimationsRaw.size());
        for (Map.Entry<String, List<JsonObject>> entry : this.tardisAnimationsRaw.entrySet()) {
            buf.method_10814(entry.getKey());
            buf.writeInt(entry.getValue().size());
            for (JsonObject json : entry.getValue()) {
                buf.method_10814(json.toString());
            }
        }
        return buf;
    }

    private void sync(class_3222 target) {
        if (ServerLifecycleHooks.get() == null) {
            return;
        }
        ServerPlayNetworking.send((class_3222)target, (class_2960)SYNC, (class_2540)this.toBuf());
    }

    private void sync() {
        if (ServerLifecycleHooks.get() == null) {
            return;
        }
        class_2540 buf = this.toBuf();
        for (class_3222 player : ServerLifecycleHooks.get().method_3760().method_14571()) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)SYNC, (class_2540)buf);
        }
    }

    private void receive(class_2540 buf) {
        this.tardisAnimationsRaw.clear();
        this.tardisAnimations.clear();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            String namespace = buf.method_19772();
            int jsonSize = buf.readInt();
            ArrayList<JsonObject> jsons = new ArrayList<JsonObject>();
            for (int j = 0; j < jsonSize; ++j) {
                String jsonString = buf.method_19772();
                JsonObject json = JsonParser.parseString((String)jsonString).getAsJsonObject();
                jsons.add(json);
            }
            this.tardisAnimationsRaw.put(namespace, jsons);
        }
        this.parseRawLookup();
        AITMod.LOGGER.info("Received {} blockbench animation files", (Object)this.tardisAnimationsRaw.size());
    }

    public class_2960 getFabricId() {
        return AITMod.id("blockbench_parser");
    }

    public void method_14491(class_3300 manager) {
        this.tardisAnimationsRaw.clear();
        this.tardisAnimations.clear();
        for (class_2960 id : manager.method_14488("fx/animation/keyframes", filename -> filename.method_12832().endsWith("animation.json")).keySet()) {
            try {
                InputStream stream = ((class_3298)manager.method_14486(id).get()).method_14482();
                try {
                    this.parseAndStore(JsonParser.parseReader((Reader)new InputStreamReader(stream)).getAsJsonObject(), id.method_12836());
                    AmbleKit.LOGGER.info("Loaded blockbench file {}", (Object)id);
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception e) {
                AmbleKit.LOGGER.error("Error occurred while loading resource json {}", (Object)id.toString(), (Object)e);
            }
        }
        this.sync();
    }

    public static Result getOrThrow(class_2960 id) {
        Result result = BlockbenchParser.getInstance().tardisAnimations.get(id);
        if (result == null) {
            throw new IllegalStateException("No blockbench animation found for " + String.valueOf(id));
        }
        return result;
    }

    public static Result getOrFallback(class_2960 id) {
        try {
            return BlockbenchParser.getOrThrow(id);
        }
        catch (IllegalStateException e) {
            AITMod.LOGGER.error(String.valueOf(e));
            return BlockbenchParser.getInstance().tardisAnimations.values().iterator().next();
        }
    }

    private void parseRawLookup() {
        this.tardisAnimations.clear();
        for (Map.Entry<String, List<JsonObject>> entry : this.tardisAnimationsRaw.entrySet()) {
            String namespace = entry.getKey();
            List<JsonObject> animations = entry.getValue();
            for (JsonObject json : animations) {
                HashMap<class_2960, Result> map = BlockbenchParser.parse(json, namespace);
                this.tardisAnimations.putAll(map);
            }
        }
    }

    private void parseAndStore(JsonObject json, String namespace) {
        this.tardisAnimationsRaw.computeIfAbsent(namespace, k -> new ArrayList());
        this.tardisAnimationsRaw.get(namespace).add(json);
        HashMap<class_2960, Result> map = BlockbenchParser.parse(json, namespace);
        this.tardisAnimations.putAll(map);
    }

    public static HashMap<class_2960, Result> parse(JsonObject json, String namespace) {
        JsonObject animations = json.getAsJsonObject("animations");
        HashMap<class_2960, Result> map = new HashMap<class_2960, Result>();
        for (String key : animations.keySet()) {
            JsonObject anim = animations.getAsJsonObject(key);
            class_2960 id = class_2960.method_43902((String)namespace, (String)key);
            Result result = BlockbenchParser.parseAnimation(anim);
            map.put(id, result);
        }
        return map;
    }

    private static Result parseAnimation(JsonObject anim) {
        JsonObject bones = anim.getAsJsonObject("bones");
        return BlockbenchParser.parseTracker(bones.getAsJsonObject((String)bones.keySet().iterator().next()), anim.getAsJsonObject("timeline"));
    }

    private static Result parseTracker(JsonObject main, JsonObject timeline) {
        KeyframeTracker<Vector3f> rotation = BlockbenchParser.parseVectorKeyframe(main.get("rotation"), 1.0f, new Vector3f(0.0f, 0.0f, 0.0f));
        KeyframeTracker<Vector3f> translation = BlockbenchParser.parseVectorKeyframe(main.get("position"), 16.0f, new Vector3f(0.0f, 0.0f, 0.0f));
        KeyframeTracker<Vector3f> scale = BlockbenchParser.parseVectorKeyframe(main.get("scale"), 1.0f, new Vector3f(1.0f, 1.0f, 1.0f));
        KeyframeTracker<Float> alpha = BlockbenchParser.parseAlphaKeyframe(timeline);
        return new Result(alpha, rotation, translation, scale);
    }

    private static KeyframeTracker<Float> parseAlphaKeyframe(JsonObject object) {
        if (object == null) {
            ArrayList list = new ArrayList();
            list.add(new AnimationKeyframe<Float>(20.0f, AnimationKeyframe.Interpolation.CUBIC, new AnimationKeyframe.InterpolatedFloat(1.0f, 1.0f)));
            return new KeyframeTracker<Float>(list);
        }
        ArrayList list = new ArrayList();
        TreeMap<Float, Float> alphaMap = new TreeMap<Float, Float>();
        for (String string : object.keySet()) {
            float time = Float.parseFloat(string);
            String alphaStr = object.get(string).getAsString();
            float alpha = Float.parseFloat(alphaStr.substring(0, alphaStr.length() - 1));
            alphaMap.put(Float.valueOf(time), Float.valueOf(alpha));
        }
        for (Map.Entry entry : alphaMap.entrySet()) {
            Float currentTime = (Float)entry.getKey();
            Float currentAlpha = (Float)entry.getValue();
            Map.Entry nextEntry = alphaMap.higherEntry(currentTime);
            if (nextEntry != null) {
                Float nextTime = nextEntry.getKey();
                Float nextAlpha = (Float)nextEntry.getValue();
                AnimationKeyframe<Float> frame = new AnimationKeyframe<Float>((nextTime.floatValue() - currentTime.floatValue()) * 20.0f, AnimationKeyframe.Interpolation.CUBIC, new AnimationKeyframe.InterpolatedFloat(currentAlpha.floatValue(), nextAlpha.floatValue()));
                list.add(frame);
                continue;
            }
            if (!list.isEmpty()) continue;
            AnimationKeyframe<Float> frame = new AnimationKeyframe<Float>(20.0f, AnimationKeyframe.Interpolation.CUBIC, new AnimationKeyframe.InterpolatedFloat(currentAlpha.floatValue(), currentAlpha.floatValue()));
            list.add(frame);
        }
        return new KeyframeTracker<Float>(list);
    }

    private static KeyframeTracker<Vector3f> parseVectorKeyframe(JsonElement element, float divider, Vector3f fallback) {
        ArrayList list = new ArrayList();
        if (element == null) {
            list.add(new AnimationKeyframe<Vector3f>(20.0f, AnimationKeyframe.Interpolation.LINEAR, new AnimationKeyframe.InterpolatedVector3f(fallback, fallback)));
            return new KeyframeTracker<Vector3f>(list);
        }
        if (element.isJsonArray()) {
            Vector3f vec = BlockbenchParser.parseVector(element.getAsJsonArray());
            list.add(new AnimationKeyframe<Vector3f>(20.0f, AnimationKeyframe.Interpolation.LINEAR, new AnimationKeyframe.InterpolatedVector3f(vec, vec)));
            return new KeyframeTracker<Vector3f>(list);
        }
        if (element.isJsonPrimitive()) {
            Vector3f vec = new Vector3f(element.getAsJsonPrimitive().getAsFloat());
            list.add(new AnimationKeyframe<Vector3f>(20.0f, AnimationKeyframe.Interpolation.LINEAR, new AnimationKeyframe.InterpolatedVector3f(vec, vec)));
            return new KeyframeTracker<Vector3f>(list);
        }
        JsonObject object = element.getAsJsonObject();
        TreeMap<Float, class_3545> map = new TreeMap<Float, class_3545>();
        for (String string : object.keySet()) {
            AnimationKeyframe.Interpolation type;
            Vector3f vector;
            float time = Float.parseFloat(string);
            if (object.get(string).isJsonObject()) {
                JsonObject data = object.get(string).getAsJsonObject();
                vector = BlockbenchParser.parseVector(data.getAsJsonArray("post")).div(divider);
                type = AnimationKeyframe.Interpolation.CUBIC;
            } else {
                vector = BlockbenchParser.parseVector(object.get(string).getAsJsonArray()).div(divider);
                type = AnimationKeyframe.Interpolation.LINEAR;
            }
            map.put(Float.valueOf(time), new class_3545((Object)vector, (Object)type));
        }
        for (Map.Entry entry : map.entrySet()) {
            Float currentTime = (Float)entry.getKey();
            Vector3f currentVector = (Vector3f)((class_3545)entry.getValue()).method_15442();
            AnimationKeyframe.Interpolation currentType = (AnimationKeyframe.Interpolation)((Object)((class_3545)entry.getValue()).method_15441());
            Map.Entry nextEntry = map.higherEntry(currentTime);
            if (nextEntry != null) {
                Float nextTime = nextEntry.getKey();
                Vector3f nextVector = (Vector3f)((class_3545)nextEntry.getValue()).method_15442();
                AnimationKeyframe<Vector3f> frame = new AnimationKeyframe<Vector3f>((nextTime.floatValue() - currentTime.floatValue()) * 20.0f, currentType, new AnimationKeyframe.InterpolatedVector3f(currentVector, nextVector));
                list.add(frame);
                continue;
            }
            if (!list.isEmpty()) continue;
            AnimationKeyframe<Vector3f> frame = new AnimationKeyframe<Vector3f>(20.0f, currentType, new AnimationKeyframe.InterpolatedVector3f(currentVector, currentVector));
            list.add(frame);
        }
        return new KeyframeTracker<Vector3f>(list);
    }

    private static Vector3f parseVector(JsonArray json) {
        return new Vector3f(BlockbenchParser.parseFloat(json.get(0)), BlockbenchParser.parseFloat(json.get(1)), BlockbenchParser.parseFloat(json.get(2)));
    }

    private static float parseFloat(JsonElement element) {
        try {
            return element.getAsFloat();
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return BlockbenchParser.parseMath(element.getAsString());
            }
            catch (Exception e) {
                AITMod.LOGGER.error("Error occurred while parsing float {}", (Object)element);
                return 0.0f;
            }
        }
    }

    public static float parseMath(String data) {
        Expression expression = new ExpressionBuilder(data).build();
        double result = expression.evaluate();
        return (float)result;
    }

    public record Result(KeyframeTracker<Float> alpha, KeyframeTracker<Vector3f> rotation, KeyframeTracker<Vector3f> translation, KeyframeTracker<Vector3f> scale) {
    }
}

