/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.tardis.animation.v2.datapack;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.amble.ait.AITMod;
import dev.amble.ait.core.tardis.animation.v2.TardisAnimation;
import dev.amble.ait.core.tardis.animation.v2.blockbench.BlockbenchParser;
import dev.amble.ait.core.tardis.animation.v2.keyframe.KeyframeTracker;
import dev.amble.ait.core.tardis.handler.travel.TravelHandlerBase;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class DatapackAnimation
extends TardisAnimation {
    public static final Codec<TardisAnimation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("id").forGetter(TardisAnimation::id), (App)class_2960.field_25139.optionalFieldOf("blockbench_file").forGetter(TardisAnimation::getBlockbenchId), (App)TravelHandlerBase.State.CODEC.fieldOf("expected_state").forGetter(TardisAnimation::getExpectedState), (App)class_2960.field_25139.optionalFieldOf("sound").forGetter(TardisAnimation::getSoundId)).apply((Applicative)instance, DatapackAnimation::new));
    private final TravelHandlerBase.State expectedState;
    private final String nameKey;
    @Nullable
    private final class_2960 blockbenchId;

    protected DatapackAnimation(class_2960 id, Optional<class_2960> blockbench, TravelHandlerBase.State expectedState, Optional<class_2960> sound) {
        super(id, sound.orElse(null), BlockbenchParser.getOrFallback(blockbench.orElse(id)));
        this.blockbenchId = blockbench.orElse(null);
        this.expectedState = expectedState;
        this.nameKey = id.method_42093("animation");
    }

    protected DatapackAnimation(class_2960 id, KeyframeTracker<Float> alpha, KeyframeTracker<Vector3f> scale, KeyframeTracker<Vector3f> position, KeyframeTracker<Vector3f> rotation, class_2960 blockbench, TravelHandlerBase.State expectedState, String optName, @Nullable class_2960 soundId) {
        super(id, soundId, alpha, scale, position, rotation);
        this.blockbenchId = blockbench;
        this.expectedState = expectedState;
        this.nameKey = id.method_42093("animation");
    }

    @Override
    public Optional<class_2960> getBlockbenchId() {
        return Optional.ofNullable(this.blockbenchId);
    }

    @Override
    public TravelHandlerBase.State getExpectedState() {
        return this.expectedState;
    }

    @Override
    public DatapackAnimation instantiate() {
        return new DatapackAnimation(this.id(), this.alpha.instantiate(), this.scale.instantiate(), this.position.instantiate(), this.rotation.instantiate(), this.blockbenchId, this.expectedState, this.nameKey, this.getSoundIdOrDefault());
    }

    public static DatapackAnimation fromInputStream(InputStream stream) {
        return DatapackAnimation.fromJson(JsonParser.parseReader((Reader)new InputStreamReader(stream)).getAsJsonObject());
    }

    public static DatapackAnimation fromJson(JsonObject json) {
        AtomicReference created = new AtomicReference();
        CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).get().ifLeft(var -> created.set((DatapackAnimation)var.getFirst())).ifRight(err -> {
            created.set(null);
            AITMod.LOGGER.error("Error decoding datapack animation: {}", err);
        });
        return (DatapackAnimation)created.get();
    }

    @Override
    public String name() {
        return class_2561.method_43471((String)this.nameKey).getString();
    }
}

