/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.tardis.animation.v2.keyframe;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import dev.amble.ait.api.tardis.Disposable;
import dev.amble.ait.api.tardis.TardisTickable;
import net.minecraft.class_3532;
import net.minecraft.class_5699;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class AnimationKeyframe<T>
implements TardisTickable,
Disposable {
    protected final InterpolatedValue<T> value;
    protected final Interpolation interpolation;
    protected final float duration;
    protected int ticks;
    private AnimationKeyframe<T> previous;
    private AnimationKeyframe<T> next;

    public AnimationKeyframe(float duration, Interpolation type, InterpolatedValue<T> value) {
        if (duration < 0.0f || value == null) {
            throw new IllegalArgumentException("Invalid keyframe parameters: " + duration + ", " + String.valueOf((Object)type) + ", " + String.valueOf(value));
        }
        this.duration = duration;
        this.value = value;
        this.interpolation = type;
        this.ticks = 0;
    }

    public boolean isDone() {
        return (float)this.ticks >= this.duration;
    }

    public void tickCommon(boolean isClient) {
        ++this.ticks;
    }

    @Override
    public void dispose() {
        this.ticks = 0;
    }

    @Override
    public boolean isAged() {
        return this.isDone();
    }

    @Override
    public void age() {
        this.ticks = class_3532.method_15386((float)this.duration);
    }

    public int ticks() {
        return this.ticks;
    }

    public T getValue(float delta) {
        return this.value.interpolate(this.getProgress(delta), this.getPreviousValue(), this.getNextValue(), this.interpolation);
    }

    protected T getPreviousValue() {
        if (this.previous == null) {
            return this.value.start();
        }
        return this.previous.value.start();
    }

    protected T getNextValue() {
        if (this.next == null) {
            return this.value.target();
        }
        return this.next.value.target();
    }

    public void setNext(AnimationKeyframe<T> val) {
        this.next = val;
    }

    public void setPrevious(AnimationKeyframe<T> val) {
        this.previous = val;
    }

    public void setStart(T val) {
        this.value.setStart(val);
    }

    public float getProgress(float delta) {
        return ((float)this.ticks + delta) / this.duration;
    }

    public AnimationKeyframe<T> instantiate() {
        return new AnimationKeyframe<T>(this.duration, this.interpolation, this.value.instantiate());
    }

    public static interface InterpolatedValue<T> {
        public T start();

        public T target();

        public T interpolate(float var1, T var2, T var3, Interpolation var4);

        public void setStart(T var1);

        public InterpolatedValue<T> instantiate();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Interpolation {
        LINEAR{

            @Override
            public float interpolate(float progress, float previous, float start, float end, float next) {
                return class_3532.method_16439((float)Math.min(progress, 1.0f), (float)start, (float)end);
            }
        }
        ,
        CUBIC{

            @Override
            public float interpolate(float progress, float previous, float start, float end, float next) {
                return class_3532.method_41303((float)Math.min(progress, 1.0f), (float)previous, (float)start, (float)end, (float)next);
            }
        };

        public static final Codec<Interpolation> CODEC;

        public abstract float interpolate(float var1, float var2, float var3, float var4, float var5);

        static {
            CODEC = class_5699.field_41759.flatXmap(s -> {
                try {
                    return DataResult.success((Object)((Object)Interpolation.valueOf(s.toUpperCase())));
                }
                catch (Exception e) {
                    return DataResult.error(() -> "Invalid state: " + s + "! | " + e.getMessage());
                }
            }, var -> DataResult.success((Object)var.toString()));
        }
    }

    public static class InterpolatedVector3f
    implements InterpolatedValue<Vector3f> {
        private Vector3f start;
        private final Vector3f target;

        public InterpolatedVector3f(Vector3f start, Vector3f target) {
            this.start = start;
            this.target = target;
        }

        @Override
        public Vector3f start() {
            return this.start;
        }

        @Override
        public Vector3f target() {
            return this.target;
        }

        @Override
        public Vector3f interpolate(float progress, Vector3f previous, Vector3f next, Interpolation type) {
            return new Vector3f(type.interpolate(progress, previous.x, this.start.x, this.target.x, next.x), type.interpolate(progress, previous.y, this.start.y, this.target.y, next.y), type.interpolate(progress, previous.z, this.start.z, this.target.z, next.z));
        }

        @Override
        public void setStart(Vector3f start) {
            this.start = start;
        }

        @Override
        public InterpolatedValue<Vector3f> instantiate() {
            return new InterpolatedVector3f(new Vector3f((Vector3fc)this.start), new Vector3f((Vector3fc)this.target));
        }
    }

    public static class InterpolatedFloat
    implements InterpolatedValue<Float> {
        private float start;
        private final float target;

        public InterpolatedFloat(float start, float target) {
            this.start = start;
            this.target = target;
        }

        @Override
        public Float start() {
            return Float.valueOf(this.start);
        }

        @Override
        public Float target() {
            return Float.valueOf(this.target);
        }

        @Override
        public Float interpolate(float progress, Float previous, Float next, Interpolation type) {
            return Float.valueOf(type.interpolate(progress, previous.floatValue(), this.start().floatValue(), this.target().floatValue(), next.floatValue()));
        }

        @Override
        public void setStart(Float start) {
            this.start = start.floatValue();
        }

        @Override
        public InterpolatedValue<Float> instantiate() {
            return new InterpolatedFloat(this.start, this.target);
        }
    }
}

