/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.tardis.animation.v2.keyframe;

import dev.amble.ait.api.tardis.Disposable;
import dev.amble.ait.api.tardis.TardisTickable;
import dev.amble.ait.core.tardis.animation.v2.keyframe.AnimationKeyframe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.NoSuchElementException;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.server.MinecraftServer;

public class KeyframeTracker<T>
extends ArrayList<AnimationKeyframe<T>>
implements TardisTickable,
Disposable {
    protected int current = 0;
    private float duration;

    public KeyframeTracker(Collection<AnimationKeyframe<T>> frames) {
        this.addAll(frames);
        this.duration = -1.0f;
    }

    public AnimationKeyframe<T> getCurrent() {
        if (this.size() == 0) {
            throw new NoSuchElementException("Keyframe Tracker " + String.valueOf(this) + " is missing keyframes!");
        }
        return (AnimationKeyframe)this.get(this.current);
    }

    public boolean isStarting() {
        return this.current == 0;
    }

    public T getValue(float delta) {
        return this.getCurrent().getValue(delta);
    }

    @Override
    public void tick(MinecraftServer server) {
        this.tickCommon(false);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void tick(class_310 client) {
        this.tickCommon(true);
    }

    protected void tickCommon(boolean isClient) {
        AnimationKeyframe<T> current = (AnimationKeyframe<T>)this.get(this.current);
        current.tickCommon(isClient);
        if (current.isDone() && !this.isDone()) {
            ++this.current;
            AnimationKeyframe<T> previous = current;
            current = this.getCurrent();
            AnimationKeyframe next = null;
            if (this.current + 1 < this.size()) {
                next = (AnimationKeyframe)this.get(this.current + 1);
            }
            current.setStart(previous.getValue(0.0f));
            current.setPrevious(previous);
            current.setNext(next);
            previous.dispose();
        }
    }

    public void start(T val) {
        this.dispose();
    }

    public boolean isDone() {
        return this.getCurrent().isDone() && this.current == this.size() - 1;
    }

    public float duration() {
        if (this.duration == -1.0f) {
            return this.calculateDuration();
        }
        return this.duration;
    }

    private int calculateDuration() {
        int total = 0;
        for (AnimationKeyframe keyframe : this) {
            total = (int)((float)total + keyframe.duration);
        }
        this.duration = total;
        return total;
    }

    @Override
    public boolean isAged() {
        return this.isDone();
    }

    @Override
    public void age() {
        this.current = this.size() - 1;
        this.getCurrent().age();
    }

    @Override
    public void dispose() {
        this.forEach(AnimationKeyframe::dispose);
        this.current = 0;
    }

    public KeyframeTracker<T> instantiate() {
        ArrayList<AnimationKeyframe<T>> frames = new ArrayList<AnimationKeyframe<T>>();
        for (AnimationKeyframe keyframe : this) {
            frames.add(keyframe.instantiate());
        }
        return new KeyframeTracker<T>(frames);
    }
}

