/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.tardis.control;

import dev.amble.ait.AITMod;
import dev.amble.ait.api.tardis.TardisEvents;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.engine.SubSystem;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.control.impl.SecurityControl;
import dev.amble.ait.core.tardis.control.sound.ControlSoundRegistry;
import dev.amble.ait.core.util.WorldUtil;
import dev.amble.ait.data.schema.console.ConsoleTypeSchema;
import dev.amble.lib.api.Identifiable;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;

public class Control
implements Identifiable {
    private final class_2960 id;

    public Control(class_2960 id) {
        this.id = id;
    }

    public class_2960 id() {
        return this.id;
    }

    protected Result runServer(Tardis tardis, class_3222 player, class_3218 world, class_2338 console, boolean leftClick) throws ControlSequencedException {
        if (this.shouldBeAddedToSequence(tardis)) {
            this.addToControlSequence(tardis, player, console);
            throw ControlSequencedException.INSTANCE;
        }
        ((TardisEvents.UseControl)TardisEvents.USE_CONTROL.invoker()).onUse(this, tardis, player, world, console, leftClick);
        return Result.FAILURE;
    }

    public Result handleRun(Tardis tardis, class_3222 player, class_3218 world, class_2338 console, boolean leftClick) {
        try {
            return this.runServer(tardis, player, world, console, leftClick);
        }
        catch (ControlSequencedException e) {
            return Result.SEQUENCE;
        }
    }

    protected boolean shouldBeAddedToSequence(Tardis tardis) {
        return tardis.sequence().hasActiveSequence() && tardis.sequence().controlPartOfSequence(this);
    }

    public void addToControlSequence(Tardis tardis, class_3222 player, class_2338 pos) {
        tardis.sequence().add(this, player, pos);
        if (AITMod.RANDOM.nextInt(0, 20) == 4) {
            tardis.loyalty().addLevel(player, 1);
            player.method_51469().method_14199((class_2394)class_2398.field_11201, pos.method_46558().method_10216(), pos.method_46558().method_10214() + 1.0, pos.method_46558().method_10215(), 1, 0.0, 1.0, 0.0, 5.0);
        }
    }

    public class_3414 getFallbackSound() {
        return null;
    }

    public class_3414 getSound(ConsoleTypeSchema console, Result result) {
        class_3414 sound = ControlSoundRegistry.getInstance().get(console, this).sound(result);
        if (this.getFallbackSound() != null && (sound == null || sound == AITSounds.ERROR)) {
            return this.getFallbackSound();
        }
        return sound;
    }

    public boolean requiresPower() {
        return true;
    }

    protected SubSystem.IdLike requiredSubSystem() {
        return SubSystem.Id.ENGINE;
    }

    public void runAnimation(Tardis tardis, class_3222 player, class_3218 world) {
    }

    public String toString() {
        return "Control{id='" + String.valueOf(this.id) + "'}";
    }

    public long getDelayLength(Tardis tardis) {
        return 5L;
    }

    public boolean shouldHaveDelay() {
        return true;
    }

    public boolean shouldHaveDelay(Tardis tardis) {
        return !this.shouldBeAddedToSequence(tardis) && this.shouldHaveDelay();
    }

    public boolean ignoresSecurity() {
        return false;
    }

    public boolean canRun(Tardis tardis, class_3222 user) {
        if (tardis.isGrowth()) {
            return false;
        }
        if (this.requiresPower() && !tardis.fuel().hasPower()) {
            return false;
        }
        boolean security = (Boolean)tardis.stats().security().get();
        if (!this.ignoresSecurity() && security) {
            return SecurityControl.hasMatchingKey(user, tardis);
        }
        SubSystem.IdLike dependent = this.requiredSubSystem();
        if (dependent != null) {
            boolean enabled = ((SubSystem)tardis.subsystems().get(dependent)).isEnabled();
            if (!enabled) {
                user.method_7353((class_2561)class_2561.method_43469((String)"warning.ait.needs_subsystem", (Object[])new Object[]{class_2561.method_43470((String)WorldUtil.fakeTranslate(dependent.toString())).method_27692(class_124.field_1061)}).method_27692(class_124.field_1068), true);
            }
            return enabled;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Control control = (Control)o;
        return this.id.equals((Object)control.id());
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public static class ControlSequencedException
    extends RuntimeException {
        public static final ControlSequencedException INSTANCE = new ControlSequencedException();

        private ControlSequencedException() {
            this.setStackTrace(new StackTraceElement[0]);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            this.setStackTrace(new StackTraceElement[0]);
            return this;
        }
    }

    public static enum Result {
        SUCCESS,
        FAILURE,
        SEQUENCE,
        SUCCESS_ALT;


        public boolean isSuccess() {
            return this == SUCCESS || this == SUCCESS_ALT;
        }

        public boolean isAltSound() {
            return this == SUCCESS_ALT || this == FAILURE;
        }
    }
}

