/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.tardis.control.impl;

import dev.amble.ait.AITMod;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.lock.LockedDimensionRegistry;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.control.Control;
import dev.amble.ait.core.tardis.control.impl.pos.PosType;
import dev.amble.ait.core.tardis.handler.travel.TravelHandler;
import dev.amble.ait.core.tardis.util.AsyncLocatorUtil;
import dev.amble.ait.core.util.WorldUtil;
import dev.amble.lib.data.CachedDirectedGlobalPos;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_5250;
import net.minecraft.class_5321;

public class DimensionControl
extends Control {
    public static final class_2960 ID = AITMod.id("dimension");

    public DimensionControl() {
        super(ID);
    }

    @Override
    public Control.Result runServer(Tardis tardis, class_3222 player, class_3218 world, class_2338 console, boolean leftClick) {
        super.runServer(tardis, player, world, console, leftClick);
        TravelHandler travel = tardis.travel();
        CachedDirectedGlobalPos dest = travel.destination();
        CompletionStage future = CompletableFuture.supplyAsync(() -> {
            List<class_3218> dims = WorldUtil.getTravelWorlds();
            int index = Math.max(0, WorldUtil.travelWorldIndex(dest.getWorld()));
            index = leftClick ? (dims.size() + index - 1) % dims.size() : (index + 1) % dims.size();
            return dims.get(index);
        }).thenAccept(destWorld -> {
            travel.destination(cached -> {
                CachedDirectedGlobalPos cachedPos = cached.world((class_3218)destWorld);
                class_2338 clampedPos = PosType.clamp(cachedPos.getPos(), 0, (class_1937)destWorld);
                return cachedPos.pos(clampedPos);
            });
            this.messagePlayer(player, (class_3218)destWorld, LockedDimensionRegistry.getInstance().isUnlocked(tardis, (class_1937)destWorld));
        });
        AsyncLocatorUtil.LOCATING_EXECUTOR_SERVICE.submit(() -> DimensionControl.lambda$runServer$3((CompletableFuture)future));
        return Control.Result.SUCCESS;
    }

    private void messagePlayer(class_3222 player, class_3218 world, boolean unlocked) {
        class_5250 message = class_2561.method_43471((String)"message.ait.tardis.control.dimension.info").method_10852(WorldUtil.worldText((class_5321<class_1937>)world.method_27983(), false)).method_27692(unlocked ? class_124.field_1068 : class_124.field_1080);
        if (!unlocked) {
            message.method_10852((class_2561)class_2561.method_43470((String)" \ud83d\udd12"));
        }
        player.method_7353((class_2561)message, true);
    }

    @Override
    public class_3414 getFallbackSound() {
        return AITSounds.DIMENSION;
    }

    private static /* synthetic */ CompletableFuture lambda$runServer$3(CompletableFuture future) throws Exception {
        return future;
    }
}

