/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.tardis.control.impl;

import dev.amble.ait.AITMod;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.engine.SubSystem;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.control.Control;
import dev.amble.ait.core.tardis.handler.travel.TravelHandler;
import dev.amble.ait.core.tardis.handler.travel.TravelHandlerBase;
import dev.amble.lib.data.CachedDirectedGlobalPos;
import dev.drtheo.scheduler.api.TimeUnit;
import dev.drtheo.scheduler.api.common.Scheduler;
import dev.drtheo.scheduler.api.common.TaskStage;
import java.util.Random;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;

public class EngineOverloadControl
extends Control {
    private static final Random RANDOM = new Random();
    private static final String[] SPINNER = new String[]{"/", "-", "\\", "|"};

    public EngineOverloadControl() {
        super(AITMod.id("engine_overload"));
    }

    @Override
    public Control.Result runServer(Tardis tardis, class_3222 player, class_3218 world, class_2338 console, boolean leftClick) {
        boolean isInFlight;
        super.runServer(tardis, player, world, console, leftClick);
        if (tardis.fuel().getCurrentFuel() < 25000.0) {
            player.method_7353((class_2561)class_2561.method_43471((String)"tardis.message.control.engine_overdrive.insufficient_fuel").method_27692(class_124.field_1061), true);
            world.method_8396(null, player.method_24515(), AITSounds.CLOISTER, class_3419.field_15245, 1.0f, 1.0f);
            return Control.Result.FAILURE;
        }
        if (!TravelHandler.isEngineOverloadArmed(tardis.getUuid())) {
            player.method_7353((class_2561)class_2561.method_43471((String)"tardis.message.control.engine_overdrive.primed").method_27692(class_124.field_1061), true);
            TravelHandler.armEngineOverload(tardis.getUuid(), world);
            return Control.Result.SUCCESS_ALT;
        }
        TravelHandler.disarmEngineOverload(tardis.getUuid());
        boolean bl = isInFlight = tardis.travel().getState() == TravelHandlerBase.State.FLIGHT;
        if (!isInFlight) {
            tardis.travel().finishDemat();
        }
        this.runDumpingArtronSequence(player, () -> {
            world.method_8396(null, player.method_24515(), AITSounds.ENGINE_OVERLOAD, class_3419.field_15245, 1.0f, 1.0f);
            world.method_8503().execute(() -> {
                tardis.travel().handbrake(false);
                if (!isInFlight) {
                    tardis.travel().finishDemat();
                }
                tardis.setFuelCount(0.0);
                tardis.travel().decreaseFlightTime(999999999);
                tardis.setRefueling(false);
                Scheduler.get().runTaskLater(() -> this.triggerExplosion(world, console, tardis, 4), TaskStage.END_SERVER_TICK, TimeUnit.SECONDS, 0L);
            });
        });
        return Control.Result.SUCCESS;
    }

    private void triggerExplosion(class_3218 world, class_2338 console, Tardis tardis, int stage) {
        if (stage <= 0) {
            return;
        }
        tardis.alarm().enable();
        tardis.subsystems().demat().removeDurability(250.0f);
        tardis.subsystems().chameleon().removeDurability(250.0f);
        tardis.subsystems().shields().removeDurability(250.0f);
        tardis.subsystems().lifeSupport().removeDurability(250.0f);
        tardis.subsystems().engine().removeDurability(250.0f);
        tardis.crash().addRepairTicks(999999999);
        this.spawnParticles(world, console);
        Scheduler.get().runTaskLater(() -> this.spawnExteriorParticles(tardis), TaskStage.END_SERVER_TICK, TimeUnit.SECONDS, 3L);
        int nextDelay = stage == 4 ? 2 : 3;
        Scheduler.get().runTaskLater(() -> this.triggerExplosion(world, console, tardis, stage - 1), TaskStage.END_SERVER_TICK, TimeUnit.SECONDS, (long)nextDelay);
    }

    private void runDumpingArtronSequence(class_3222 player, Runnable onFinish) {
        for (int i = 0; i < 6; ++i) {
            int delay = i + 1;
            Scheduler.get().runTaskLater(() -> {
                String frame = SPINNER[delay % SPINNER.length];
                player.method_7353((class_2561)class_2561.method_43471((String)"tardis.message.control.engine_overdrive.dumping_artron").method_27693(" " + frame).method_27692(class_124.field_1065), true);
            }, TaskStage.END_SERVER_TICK, TimeUnit.SECONDS, (long)delay);
        }
        Scheduler.get().runTaskLater(() -> this.runFlashingFinalMessage(player, onFinish), TaskStage.END_SERVER_TICK, TimeUnit.SECONDS, 3L);
    }

    private void runFlashingFinalMessage(class_3222 player, Runnable onFinish) {
        for (int i = 0; i < 6; ++i) {
            int delay = i + 1;
            Scheduler.get().runTaskLater(() -> {
                class_124 flashColor = delay % 2 == 0 ? class_124.field_1061 : class_124.field_1068;
                player.method_7353((class_2561)class_2561.method_43471((String)"tardis.message.control.engine_overdrive.engines_overloaded").method_27692(flashColor), true);
            }, TaskStage.END_SERVER_TICK, TimeUnit.SECONDS, (long)delay);
        }
        Scheduler.get().runTaskLater(onFinish, TaskStage.END_SERVER_TICK, TimeUnit.SECONDS, 3L);
    }

    private void spawnParticles(class_3218 world, class_2338 position) {
        for (int i = 0; i < 50; ++i) {
            double offsetX = (RANDOM.nextDouble() - 0.5) * 2.0;
            double offsetY = RANDOM.nextDouble() * 1.5;
            double offsetZ = (RANDOM.nextDouble() - 0.5) * 2.0;
            world.method_14199((class_2394)class_2398.field_11234, (double)position.method_10263() + 0.5 + offsetX, (double)position.method_10264() + 1.5 + offsetY, (double)position.method_10260() + 0.5 + offsetZ, 2, 0.0, 0.05, 0.0, 0.1);
            world.method_14199((class_2394)class_2398.field_22247, (double)position.method_10263() + 0.5 + offsetX, (double)position.method_10264() + 1.5 + offsetY, (double)position.method_10260() + 0.5 + offsetZ, 2, 0.0, 0.05, 0.0, 0.1);
            world.method_14199((class_2394)class_2398.field_11236, (double)position.method_10263() + 0.5 + offsetX, (double)position.method_10264() + 1.5 + offsetY, (double)position.method_10260() + 0.5 + offsetZ, 2, 0.0, 0.05, 0.0, 0.1);
            world.method_14199((class_2394)class_2398.field_11239, (double)position.method_10263() + 0.5 + offsetX, (double)position.method_10264() + 1.5 + offsetY, (double)position.method_10260() + 0.5 + offsetZ, 2, 0.0, 0.05, 0.0, 0.1);
            world.method_14199((class_2394)class_2398.field_27783, (double)position.method_10263() + 0.5 + offsetX, (double)position.method_10264() + 1.5 + offsetY, (double)position.method_10260() + 0.5 + offsetZ, 2, 0.0, 0.05, 0.0, 0.1);
            world.method_14199((class_2394)class_2398.field_17431, (double)position.method_10263() + 0.5 + offsetX, (double)position.method_10264() + 1.5 + offsetY, (double)position.method_10260() + 0.5 + offsetZ, 2, 0.0, 0.05, 0.0, 0.1);
        }
    }

    private void spawnExteriorParticles(Tardis tardis) {
        CachedDirectedGlobalPos exteriorPos = tardis.travel().position();
        if (exteriorPos == null) {
            return;
        }
        class_3218 exteriorWorld = exteriorPos.getWorld();
        class_2338 exteriorBlockPos = exteriorPos.getPos();
        this.spawnParticles(exteriorWorld, exteriorBlockPos);
    }

    @Override
    protected SubSystem.IdLike requiredSubSystem() {
        return SubSystem.Id.ENGINE;
    }

    @Override
    public long getDelayLength(Tardis tardis) {
        if (TravelHandler.isEngineOverloadArmed(tardis.getUuid())) {
            return 360000L;
        }
        return 5L;
    }

    @Override
    public class_3414 getFallbackSound() {
        return AITSounds.BWEEP;
    }
}

