/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.tardis.control.impl;

import dev.amble.ait.AITMod;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.blockentities.ConsoleBlockEntity;
import dev.amble.ait.core.engine.SubSystem;
import dev.amble.ait.core.engine.impl.EngineSystem;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.control.Control;
import dev.amble.ait.core.tardis.handler.travel.TravelHandler;
import dev.amble.ait.core.tardis.handler.travel.TravelHandlerBase;
import dev.amble.ait.data.schema.console.variant.renaissance.RenaissanceFireVariant;
import dev.amble.ait.data.schema.console.variant.renaissance.RenaissanceIdentityVariant;
import dev.amble.ait.data.schema.console.variant.renaissance.RenaissanceIndustriousVariant;
import dev.amble.ait.data.schema.console.variant.renaissance.RenaissanceTokamakVariant;
import dev.amble.ait.data.schema.console.variant.renaissance.RenaissanceVariant;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;

public class HandBrakeControl
extends Control {
    public static final class_2960 ID = AITMod.id("handbrake");

    public HandBrakeControl() {
        super(ID);
    }

    @Override
    public Control.Result runServer(Tardis tardis, class_3222 player, class_3218 world, class_2338 console, boolean leftClick) {
        super.runServer(tardis, player, world, console, leftClick);
        if (tardis.isInDanger()) {
            return Control.Result.FAILURE;
        }
        EngineSystem.Phaser phaser = tardis.subsystems().engine().phaser();
        if (phaser.isPhasing()) {
            phaser.cancel();
            return Control.Result.SUCCESS;
        }
        boolean handbrake = !tardis.travel().handbrake();
        tardis.travel().handbrake(handbrake);
        if (tardis.isRefueling()) {
            tardis.setRefueling(false);
        }
        TravelHandler travel = tardis.travel();
        if (handbrake && travel.getState() == TravelHandlerBase.State.FLIGHT) {
            if (travel.autopilot()) {
                travel.stopHere();
                travel.rematerialize();
            } else {
                travel.crash();
            }
        }
        return handbrake ? Control.Result.SUCCESS_ALT : Control.Result.SUCCESS;
    }

    @Override
    public class_3414 getFallbackSound() {
        return AITSounds.HANDBRAKE_UP;
    }

    @Override
    public boolean requiresPower() {
        return false;
    }

    @Override
    protected SubSystem.IdLike requiredSubSystem() {
        return null;
    }

    private boolean isRenaissanceVariant(ConsoleBlockEntity consoleBlockEntity) {
        return consoleBlockEntity.getVariant() instanceof RenaissanceTokamakVariant || consoleBlockEntity.getVariant() instanceof RenaissanceVariant || consoleBlockEntity.getVariant() instanceof RenaissanceIndustriousVariant || consoleBlockEntity.getVariant() instanceof RenaissanceIdentityVariant || consoleBlockEntity.getVariant() instanceof RenaissanceFireVariant;
    }
}

