/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.tardis.control.impl;

import dev.amble.ait.AITMod;
import dev.amble.ait.core.AITItems;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.item.KeyItem;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.control.Control;
import dev.amble.ait.core.tardis.util.TardisUtil;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;

public class SecurityControl
extends Control {
    public SecurityControl() {
        super(AITMod.id("protocol_19"));
    }

    @Override
    public Control.Result runServer(Tardis tardis, class_3222 player, class_3218 world, class_2338 console, boolean leftClick) {
        super.runServer(tardis, player, world, console, leftClick);
        if (!SecurityControl.hasMatchingKey(player, tardis)) {
            return Control.Result.FAILURE;
        }
        boolean security = (Boolean)tardis.stats().security().get();
        tardis.stats().security().set(!security);
        return security ? Control.Result.SUCCESS : Control.Result.SUCCESS_ALT;
    }

    public static void runSecurityProtocols(Tardis tardis) {
        boolean security = (Boolean)tardis.stats().security().get();
        boolean leaveBehind = (Boolean)tardis.travel().leaveBehind().get();
        if (!security) {
            return;
        }
        ArrayList<class_3222> forRemoval = new ArrayList<class_3222>();
        if (leaveBehind) {
            for (class_3222 player : tardis.asServer().world().method_18456()) {
                if (SecurityControl.hasMatchingKey(player, tardis)) continue;
                forRemoval.add(player);
            }
            for (class_3222 player : forRemoval) {
                TardisUtil.teleportOutside(tardis, (class_1297)player);
            }
        }
    }

    public static boolean hasMatchingKey(class_3222 player, Tardis tardis) {
        if (player.method_5687(2)) {
            return true;
        }
        if (!tardis.loyalty().get((class_1657)player).isOf(tardis.permissions().p19Loyalty().get())) {
            return false;
        }
        if (!KeyItem.isKeyInInventory((class_1657)player)) {
            return false;
        }
        Collection<class_1799> keys = KeyItem.getKeysInInventory((class_1657)player);
        for (class_1799 stack : keys) {
            Tardis found = KeyItem.getTardisStatic(player.method_37908(), stack);
            if (stack.method_7909() == AITItems.SKELETON_KEY) {
                return true;
            }
            if (found != tardis) continue;
            return true;
        }
        return false;
    }

    @Override
    public class_3414 getFallbackSound() {
        return AITSounds.PROTOCOL_19;
    }

    @Override
    public long getDelayLength(Tardis tardis) {
        return 50L;
    }
}

