/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.tardis.control.impl;

import dev.amble.ait.AITMod;
import dev.amble.ait.compat.portal.PortalsAPI;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.engine.SubSystem;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.control.Control;
import dev.amble.ait.core.tardis.handler.travel.TravelHandlerBase;
import dev.amble.lib.data.CachedDirectedGlobalPos;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class VisualiserControl
extends Control {
    public VisualiserControl() {
        super(AITMod.id("visualiser"));
    }

    @Override
    public Control.Result runServer(Tardis tardis, class_3222 player, class_3218 world, class_2338 console, boolean rightClick) {
        super.runServer(tardis, player, world, console, rightClick);
        if (!AITMod.CONFIG.rwfEnabled) {
            if (!tardis.travel().isLanded()) {
                return Control.Result.FAILURE;
            }
            return PortalsAPI.VISUALIZER.map(visualizer -> {
                CachedDirectedGlobalPos pos = tardis.travel().position();
                visualizer.open(player, pos.getWorld(), pos.getPos().method_10086((int)Math.ceil(tardis.getExterior().getVariant().portalHeight()) + 1));
                return Control.Result.SUCCESS;
            }).orElse(Control.Result.FAILURE);
        }
        if (!player.method_7337()) {
            player.method_7353((class_2561)class_2561.method_43471((String)"tardis.message.control.rwf_creative_only"), true);
            return Control.Result.FAILURE;
        }
        if (!player.method_5715() && tardis.travel().getState() == TravelHandlerBase.State.LANDED && ((SubSystem)tardis.subsystems().get(SubSystem.Id.GRAVITATIONAL)).isEnabled()) {
            if (tardis.door().isOpen()) {
                world.method_8396(null, player.method_24515(), class_3417.field_24061, class_3419.field_15245, 1.0f, 1.0f);
                return Control.Result.SUCCESS;
            }
            world.method_8396(null, player.method_24515(), class_3417.field_26945, class_3419.field_15245, 1.0f, 1.0f);
            tardis.flight().enterFlight(player);
            return Control.Result.SUCCESS;
        }
        return Control.Result.FAILURE;
    }

    @Override
    protected SubSystem.IdLike requiredSubSystem() {
        return SubSystem.Id.GRAVITATIONAL;
    }

    @Override
    public class_3414 getFallbackSound() {
        return AITSounds.RENAISSANCE_ANTI_GRAV;
    }
}

