/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.tardis.control.impl.waypoint;

import dev.amble.ait.AITMod;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.TardisDesktop;
import dev.amble.ait.core.tardis.control.Control;
import dev.amble.ait.core.world.TardisServerWorld;
import dev.amble.ait.data.Waypoint;
import dev.amble.lib.data.CachedDirectedGlobalPos;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5321;

public class SaveWaypointControl
extends Control {
    public SaveWaypointControl() {
        super(AITMod.id("save_waypoint"));
    }

    @Override
    public Control.Result runServer(Tardis tardis, class_3222 player, class_3218 world, class_2338 console, boolean leftClick) {
        super.runServer(tardis, player, world, console, leftClick);
        if (!tardis.waypoint().hasCartridge()) {
            player.method_7353((class_2561)class_2561.method_43471((String)"control.ait.load_waypoint.no_cartridge"), true);
            TardisDesktop.playSoundAtConsole((class_1937)world, console, (class_3414)class_3417.field_18311.comp_349(), class_3419.field_15248, 6.0f, 0.1f);
            return Control.Result.SUCCESS;
        }
        CachedDirectedGlobalPos cached = tardis.travel().position();
        if (cached.getWorld() instanceof TardisServerWorld) {
            cached = CachedDirectedGlobalPos.create((class_5321<class_1937>)TardisServerWorld.field_25179, cached.getPos(), cached.getRotation());
        }
        tardis.waypoint().set(Waypoint.fromPos(cached), console, false);
        TardisDesktop.playSoundAtConsole((class_1937)world, console, AITSounds.TARDIS_BLING, class_3419.field_15248, 6.0f, 1.0f);
        return Control.Result.SUCCESS;
    }

    @Override
    public class_3414 getFallbackSound() {
        return AITSounds.SAVE_WAYPOINT;
    }
}

