/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.tardis.control.sound;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.amble.ait.AITMod;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.tardis.control.Control;
import dev.amble.ait.data.schema.console.ConsoleTypeSchema;
import dev.amble.ait.registry.impl.ControlRegistry;
import dev.amble.ait.registry.impl.console.ConsoleRegistry;
import dev.amble.lib.api.Identifiable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_7923;

public record ControlSound(class_2960 controlId, class_2960 consoleId, class_2960 successId, class_2960 altId) implements Identifiable
{
    public static final Codec<ControlSound> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("control").forGetter(ControlSound::controlId), (App)class_2960.field_25139.fieldOf("console").forGetter(ControlSound::consoleId), (App)class_2960.field_25139.fieldOf("success_sound").forGetter(ControlSound::successId), (App)class_2960.field_25139.optionalFieldOf("alt_sound", (Object)class_3417.field_42593.method_14833()).forGetter(ControlSound::altId)).apply((Applicative)instance, ControlSound::new));

    public class_2960 id() {
        return ControlSound.mergeIdentifiers(this.controlId, this.consoleId);
    }

    public ConsoleTypeSchema console() {
        return (ConsoleTypeSchema)ConsoleRegistry.getInstance().get(this.consoleId());
    }

    public Control control() {
        return (Control)ControlRegistry.REGISTRY.method_10223(this.controlId());
    }

    public class_3414 sound(Control.Result result) {
        return !result.isAltSound() ? this.successSound() : this.altSound();
    }

    public class_3414 successSound() {
        class_3414 sfx = (class_3414)class_7923.field_41172.method_10223(this.successId());
        if (sfx == null) {
            AITMod.LOGGER.error("Unknown success sound event: {} in control sfx {}", (Object)this.successId(), (Object)this.id());
            sfx = AITSounds.ERROR;
        }
        return sfx;
    }

    public class_3414 altSound() {
        class_3414 sfx = (class_3414)class_7923.field_41172.method_10223(this.altId());
        if (sfx == null || this.altId() == class_3417.field_42593.method_14833()) {
            AITMod.LOGGER.error("Unknown alt sound event: {} in control sfx {}", (Object)this.altId(), (Object)this.id());
            sfx = this.successSound();
        }
        return sfx;
    }

    public static ControlSound forFallback(class_2960 controlId, class_3414 success, class_3414 alt) {
        return new ControlSound(controlId, AITMod.id("fallback"), success.method_14833(), alt.method_14833());
    }

    public static class_2960 mergeIdentifiers(class_2960 controlId, class_2960 consoleId) {
        return class_2960.method_43902((String)consoleId.method_12836(), (String)(consoleId.method_12832() + "/" + controlId.method_12836() + "/" + controlId.method_12832()));
    }

    public static ControlSound fromInputStream(InputStream stream) {
        return ControlSound.fromJson(JsonParser.parseReader((Reader)new InputStreamReader(stream)).getAsJsonObject());
    }

    public static ControlSound fromJson(JsonObject json) {
        AtomicReference created = new AtomicReference();
        CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).get().ifLeft(var -> created.set((ControlSound)var.getFirst())).ifRight(err -> {
            created.set(null);
            AITMod.LOGGER.error("Error decoding datapack console variant: {}", err);
        });
        return (ControlSound)created.get();
    }
}

