/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.tardis.control.sound;

import dev.amble.ait.AITMod;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.tardis.control.Control;
import dev.amble.ait.core.tardis.control.impl.AutoPilotControl;
import dev.amble.ait.core.tardis.control.impl.CloakControl;
import dev.amble.ait.core.tardis.control.impl.DoorControl;
import dev.amble.ait.core.tardis.control.impl.HandBrakeControl;
import dev.amble.ait.core.tardis.control.impl.RefuelerControl;
import dev.amble.ait.core.tardis.control.impl.ShieldsControl;
import dev.amble.ait.core.tardis.control.sound.ControlSound;
import dev.amble.ait.data.schema.console.ConsoleTypeSchema;
import dev.amble.lib.register.AmbleRegistries;
import dev.amble.lib.register.Registry;
import dev.amble.lib.register.datapack.SimpleDatapackRegistry;
import net.fabricmc.fabric.api.event.registry.FabricRegistryBuilder;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;

public class ControlSoundRegistry
extends SimpleDatapackRegistry<ControlSound> {
    private static final ControlSoundRegistry instance = new ControlSoundRegistry();
    public static final class_2370<ControlSound> FALLBACKS = (class_2370)FabricRegistryBuilder.createSimple((class_5321)class_5321.method_29180((class_2960)AITMod.id("control_sound_fallback"))).buildAndRegister();
    public static ControlSound EMPTY;

    public ControlSoundRegistry() {
        super(ControlSound::fromInputStream, ControlSound.CODEC, "control_sounds", true, "ait");
    }

    public static ControlSoundRegistry getInstance() {
        return instance;
    }

    public ControlSound fallback() {
        return EMPTY;
    }

    protected void defaults() {
        EMPTY = new ControlSound(AITMod.id("empty"), AITMod.id("empty"), AITSounds.ERROR.method_14833(), AITSounds.ERROR.method_14833());
    }

    private ControlSound registerFallback(ControlSound val) {
        return (ControlSound)class_2378.method_10230(FALLBACKS, (class_2960)val.controlId(), (Object)val);
    }

    public ControlSound get(class_2960 consoleId, class_2960 controlId) {
        ControlSound possible = (ControlSound)this.get(ControlSound.mergeIdentifiers(controlId, consoleId));
        if (possible != null) {
            return possible;
        }
        for (ControlSound sound : this.REGISTRY.values()) {
            if (!sound.controlId().equals((Object)controlId) || !sound.consoleId().equals((Object)consoleId)) continue;
            return sound;
        }
        possible = (ControlSound)FALLBACKS.method_10223(controlId);
        if (possible != null) {
            return possible;
        }
        return this.fallback();
    }

    public ControlSound get(ConsoleTypeSchema console, Control control) {
        return this.get(console.id(), control.id());
    }

    public static void init() {
        AmbleRegistries.getInstance().register((Registry)ControlSoundRegistry.getInstance());
        instance.registerFallback(ControlSound.forFallback(AutoPilotControl.ID, AITSounds.PROTOCOL_116_ON, AITSounds.PROTOCOL_116_OFF));
        instance.registerFallback(ControlSound.forFallback(CloakControl.ID, AITSounds.PROTOCOL_3, AITSounds.PROTOCOL_3ALT));
        instance.registerFallback(ControlSound.forFallback(DoorControl.ID, AITSounds.DOOR_CONTROL, AITSounds.DOOR_CONTROLALT));
        instance.registerFallback(ControlSound.forFallback(HandBrakeControl.ID, AITSounds.HANDBRAKE_DOWN, AITSounds.HANDBRAKE_UP));
        instance.registerFallback(ControlSound.forFallback(RefuelerControl.ID, AITSounds.ENGINE_REFUEL_CRANK, AITSounds.ENGINE_REFUEL));
        instance.registerFallback(ControlSound.forFallback(ShieldsControl.ID, AITSounds.HANDBRAKE_LEVER_PULL, AITSounds.SHIELDS));
    }
}

