/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.tardis.handler;

import dev.amble.ait.api.ArtronHolderItem;
import dev.amble.ait.api.tardis.KeyedTardisComponent;
import dev.amble.ait.api.tardis.TardisComponent;
import dev.amble.ait.api.tardis.TardisTickable;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.data.properties.Property;
import dev.amble.ait.data.properties.Value;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.server.MinecraftServer;

public class ButlerHandler
extends KeyedTardisComponent
implements ArtronHolderItem,
TardisTickable {
    private static final Property<class_1799> HANDLES = new Property<class_1799>(Property.ITEM_STACK, "handles", (class_1799)null);
    private final Value<class_1799> handles = HANDLES.create((class_1799)this);

    public ButlerHandler() {
        super(TardisComponent.Id.BUTLER);
    }

    @Override
    public void onLoaded() {
        this.handles.of(this, HANDLES);
    }

    public class_1799 getHandles() {
        return this.handles.get();
    }

    public void insertHandles(class_1799 handlesMyBoy, class_2338 consolePos) {
        ButlerHandler.insertAnyHandles(this.handles, handlesMyBoy, stack -> ButlerHandler.spawnItem((class_1937)this.tardis.asServer().world(), consolePos, stack));
    }

    public class_1799 takeHandles() {
        return ButlerHandler.takeAnyHandles(this.handles);
    }

    private static class_1799 takeAnyHandles(Value<class_1799> value) {
        class_1799 result = value.get();
        value.set((class_1799)null);
        return result;
    }

    private static void insertAnyHandles(Value<class_1799> value, class_1799 handles, Consumer<class_1799> spawner) {
        value.flatMap(stack -> {
            if (stack != null) {
                spawner.accept((class_1799)stack);
            }
            return handles;
        });
    }

    public static void spawnItem(class_1937 world, class_2338 pos, class_1799 handles) {
        class_1542 entity = new class_1542(world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), handles);
        world.method_8649((class_1297)entity);
    }

    @Override
    public double getMaxFuel(class_1799 stack) {
        return 0.0;
    }

    @Override
    public void tick(MinecraftServer server) {
        if (server.method_3780() % 10 != 0) {
            return;
        }
        class_1799 handlesItem = this.handles.get();
        if (handlesItem != null) {
            if (this.hasMaxFuel(handlesItem)) {
                return;
            }
            ServerTardis tardis = this.tardis.asServer();
            if (!tardis.fuel().hasPower()) {
                return;
            }
            this.addFuel(10.0, handlesItem);
            tardis.fuel().removeFuel(10.0);
        }
    }
}

