/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.tardis.handler;

import dev.amble.ait.AITMod;
import dev.amble.ait.api.tardis.KeyedTardisComponent;
import dev.amble.ait.api.tardis.TardisComponent;
import dev.amble.ait.api.tardis.TardisEvents;
import dev.amble.ait.core.AITBlocks;
import dev.amble.ait.core.blockentities.ExteriorBlockEntity;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.handler.BiomeHandler;
import dev.amble.ait.core.tardis.handler.DoorHandler;
import dev.amble.ait.core.tardis.util.NetworkUtil;
import dev.amble.ait.data.Exclude;
import dev.amble.ait.data.schema.exterior.variant.adaptive.AdaptiveVariant;
import dev.amble.lib.data.CachedDirectedGlobalPos;
import dev.drtheo.gaslighter.Gaslighter3000;
import dev.drtheo.gaslighter.api.FakeBlockEvents;
import dev.drtheo.gaslighter.impl.FakeStructureWorldAccess;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2622;
import net.minecraft.class_2626;
import net.minecraft.class_2680;
import net.minecraft.class_2944;
import net.minecraft.class_2960;
import net.minecraft.class_2964;
import net.minecraft.class_2975;
import net.minecraft.class_3005;
import net.minecraft.class_3031;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4625;
import net.minecraft.class_4781;
import net.minecraft.class_5250;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_6796;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;

public class ChameleonHandler
extends KeyedTardisComponent {
    @Exclude
    private Gaslighter3000 gaslighter;
    private class_2960 lastFeature = null;
    private static final Set<Class<? extends class_3031<?>>> TREES;
    private static final class_5321<class_2975<?, ?>> CACTUS;

    public ChameleonHandler() {
        super(TardisComponent.Id.CHAMELEON);
    }

    @Override
    public void postInit(TardisComponent.InitContext ctx) {
        if (ctx.created() || !this.isServer()) {
            return;
        }
        if (this.lastFeature == null) {
            return;
        }
        CachedDirectedGlobalPos cached = this.tardis.travel().position();
        class_2338 pos = cached.getPos();
        class_3218 world = cached.getWorld();
        Optional feature = ChameleonHandler.getRegistry((class_1937)world).method_40264(ChameleonHandler.asFeature(this.lastFeature));
        if (feature.isEmpty()) {
            return;
        }
        this.gaslighter = new Gaslighter3000(world);
        if (!this.generate(world, pos, (class_6880)feature.get()) && !this.applyFallback(world, pos)) {
            return;
        }
        if (!this.tryFixDisguise(world, pos)) {
            return;
        }
        this.applyDisguise();
    }

    private static boolean shouldNotBeDisguised(Tardis tardis) {
        return !ChameleonHandler.isDisguised(tardis) || !tardis.travel().isLanded() || tardis.siege().isActive() || tardis.door().isOpen() || (Boolean)tardis.flight().falling().get() != false || (Boolean)tardis.travel().antigravs().get() != false && (Boolean)tardis.flight().shouldFall().get() != false;
    }

    public static boolean isDisguised(Tardis tardis) {
        return tardis.getExterior().getVariant() instanceof AdaptiveVariant;
    }

    public void clearDisguise() {
        if (this.gaslighter == null) {
            return;
        }
        this.gaslighter.touchGrass();
        this.gaslighter.tweet();
        this.gaslighter = null;
        this.lastFeature = null;
    }

    public boolean recalcDisguise() {
        if (this.gaslighter != null) {
            return true;
        }
        long start = System.currentTimeMillis();
        CachedDirectedGlobalPos cached = this.tardis.travel().position();
        class_3218 world = cached.getWorld();
        class_2338 pos = cached.getPos();
        this.gaslighter = new Gaslighter3000(world);
        boolean success = this.testBiome(world, pos);
        if (!success && !this.applyFallback(world, pos)) {
            return false;
        }
        boolean result = this.tryFixDisguise(world, pos);
        AITMod.LOGGER.debug("Recalculated exterior in {}ms", (Object)(System.currentTimeMillis() - start));
        return result;
    }

    private boolean tryFixDisguise(class_3218 world, class_2338 pos) {
        if (!this.gaslighter.getAgenda(pos).method_27852(AITBlocks.EXTERIOR_BLOCK)) {
            return true;
        }
        if (!this.applyFallback(world, pos)) {
            this.gaslighter = null;
            return false;
        }
        return true;
    }

    private boolean applyFallback(class_3218 world, class_2338 pos) {
        class_2680 below = world.method_8320(pos.method_10074());
        if (!ChameleonHandler.isSafe(below) && !ChameleonHandler.isSafe(below = world.method_8320(pos.method_10087(2)))) {
            this.notifyFailure();
            return false;
        }
        this.gaslighter.spreadLies(pos, below);
        return true;
    }

    private void notifyFailure() {
        class_5250 text = class_2561.method_43471((String)"tardis.message.chameleon.failed").method_27692(class_124.field_1061);
        NetworkUtil.getSubscribedPlayers(this.tardis.asServer()).forEach(arg_0 -> ChameleonHandler.lambda$notifyFailure$10((class_2561)text, arg_0));
    }

    private void applyDisguise(class_3222 player) {
        if (!this.recalcDisguise()) {
            return;
        }
        this.gaslighter.tweet(player);
    }

    public void applyDisguise() {
        if (!this.recalcDisguise()) {
            return;
        }
        this.gaslighter.tweet();
    }

    private boolean testBiome(class_3218 world, class_2338 pos) {
        class_6880 biome = world.method_23753(pos);
        List<class_6880<class_2975<?, ?>>> trees = this.findTrees(world, (class_6880<class_1959>)biome);
        if (trees.isEmpty()) {
            return false;
        }
        class_6880<class_2975<?, ?>> tree = trees.get(world.field_9229.method_43048(trees.size()));
        if (tree == null) {
            return false;
        }
        return this.generate(world, pos, tree);
    }

    private boolean generate(class_3218 world, class_2338 pos, class_6880<class_2975<?, ?>> feature) {
        feature.method_40230().ifPresent(k -> {
            this.lastFeature = k.method_29177();
        });
        FakeStructureWorldAccess access = new FakeStructureWorldAccess(world, this.gaslighter);
        return ((class_2975)feature.comp_349()).method_12862((class_5281)access, world.method_14178().method_12129(), world.field_9229, pos);
    }

    private static boolean isSafe(class_2680 state) {
        return state.method_51367() && !state.method_45474();
    }

    private List<class_6880<class_2975<?, ?>>> findTrees(class_3218 world, class_6880<class_1959> biome) {
        BiomeHandler biomeHandler = (BiomeHandler)this.tardis.handler(TardisComponent.Id.BIOME);
        ArrayList trees = new ArrayList();
        if (biomeHandler.getBiomeKey() == BiomeHandler.BiomeType.SANDY && world.field_9229.method_43048(5) != 0) {
            trees.add(ChameleonHandler.getRegistry((class_1937)world).method_40264(CACTUS).orElse(null));
            return trees;
        }
        block0: for (class_6885 feature : ((class_1959)biome.comp_349()).method_30970().method_30983()) {
            for (class_6880 entry : feature) {
                class_6880 configured = ((class_6796)entry.comp_349()).comp_334();
                if (ChameleonHandler.isTree((class_2975)configured.comp_349(), biome)) {
                    trees.add(configured);
                    continue block0;
                }
                boolean shouldBreak = false;
                for (class_2975 configuredFeature : ((class_2975)configured.comp_349()).comp_333().method_30649().toList()) {
                    if (!ChameleonHandler.isTree(configuredFeature, biome)) continue;
                    trees.add(configured);
                    shouldBreak = true;
                    break;
                }
                if (!shouldBreak) continue;
                continue block0;
            }
        }
        return trees;
    }

    public boolean isApplied() {
        return ChameleonHandler.isDisguised(this.tardis) && this.gaslighter != null;
    }

    private static void shitParticles(class_3218 world, class_2338 pos) {
        class_243 center = pos.method_46558();
        world.method_14199((class_2394)class_2398.field_11207, center.method_10216(), center.method_10214(), center.method_10215(), 12, 0.3, 0.3, 0.3, 0.0);
    }

    private static boolean isTree(class_2975<?, ?> configured, class_6880<class_1959> biome) {
        class_3031 feature = configured.comp_332();
        for (Class<class_3031<?>> clazz : TREES) {
            if (!clazz.isInstance(feature)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static class_2378<class_2975<?, ?>> getRegistry(class_1937 world) {
        return world.method_30349().method_30530(class_7924.field_41239);
    }

    @NotNull
    private static class_5321<class_2975<?, ?>> asFeature(class_2960 id) {
        return class_5321.method_29179((class_5321)class_7924.field_41239, (class_2960)id);
    }

    private static /* synthetic */ void lambda$notifyFailure$10(class_2561 text, class_3222 player) {
        player.method_7353(text, true);
    }

    static {
        TardisEvents.ENTER_FLIGHT.register(tardis -> tardis.chameleon().clearDisguise());
        TardisEvents.START_FALLING.register(tardis -> tardis.chameleon().clearDisguise());
        TardisEvents.TOGGLE_SIEGE.register((tardis, active) -> {
            if (ChameleonHandler.shouldNotBeDisguised(tardis)) {
                tardis.chameleon().clearDisguise();
            } else {
                tardis.chameleon().applyDisguise();
            }
        });
        TardisEvents.LANDED.register(tardis -> {
            if (!ChameleonHandler.shouldNotBeDisguised(tardis)) {
                tardis.chameleon().applyDisguise();
            }
        });
        TardisEvents.SEND_TARDIS.register((tardis, player) -> {
            if (player.method_14208()) {
                return;
            }
            if (ChameleonHandler.shouldNotBeDisguised(tardis)) {
                return;
            }
            CachedDirectedGlobalPos pos = tardis.travel().position();
            if (pos == null || pos.getWorld() != player.method_51469()) {
                return;
            }
            tardis.chameleon().applyDisguise(player);
        });
        TardisEvents.EXTERIOR_CHANGE.register(tardis -> {
            if (ChameleonHandler.shouldNotBeDisguised(tardis)) {
                tardis.chameleon().clearDisguise();
            } else {
                tardis.chameleon().applyDisguise();
            }
        });
        TardisEvents.DOOR_USED.register((tardis, player) -> {
            if (player == null || !ChameleonHandler.isDisguised(tardis)) {
                return DoorHandler.InteractionResult.CONTINUE;
            }
            if (!ChameleonHandler.shouldNotBeDisguised(tardis)) {
                tardis.chameleon().applyDisguise(player);
                return DoorHandler.InteractionResult.CONTINUE;
            }
            CachedDirectedGlobalPos cached = tardis.travel().position();
            Optional<ExteriorBlockEntity> blockEntity = tardis.getExterior().findExteriorBlock();
            if (blockEntity.isEmpty()) {
                return DoorHandler.InteractionResult.CONTINUE;
            }
            player.field_13987.method_14364((class_2596)new class_2626((class_1922)cached.getWorld(), cached.getPos()));
            player.field_13987.method_14364((class_2596)new class_2626((class_1922)cached.getWorld(), cached.getPos().method_10084()));
            player.field_13987.method_14364((class_2596)class_2622.method_38585((class_2586)blockEntity.get()));
            return DoorHandler.InteractionResult.CONTINUE;
        });
        FakeBlockEvents.INTERACT.register((player, hand, pos) -> {
            if (hand != class_1268.field_5808) {
                return FakeBlockEvents.Action.REMOVE;
            }
            return FakeBlockEvents.Action.CONTINUE;
        });
        FakeBlockEvents.CHECK.register((player, hand, state, pos) -> {
            class_2586 patt0$temp;
            if (state.method_27852(AITBlocks.EXTERIOR_BLOCK)) {
                return FakeBlockEvents.Action.CONTINUE;
            }
            class_3218 world = player.method_51469();
            if (hand == class_1268.field_5808 && (patt0$temp = world.method_8321(pos.method_10074())) instanceof ExteriorBlockEntity) {
                ExteriorBlockEntity ebe = (ExteriorBlockEntity)patt0$temp;
                ebe.useOn(world, player.method_5715(), (class_1657)player);
                return FakeBlockEvents.Action.CONTINUE;
            }
            ChameleonHandler.shitParticles(world, pos);
            return FakeBlockEvents.Action.REMOVE;
        });
        FakeBlockEvents.PLACED.register((world, state, pos) -> ChameleonHandler.shitParticles(world, pos));
        FakeBlockEvents.REMOVED.register(ChameleonHandler::shitParticles);
        TREES = Set.of(class_2944.class, class_4625.class, class_4781.class, class_3005.class, class_2964.class);
        CACTUS = ChameleonHandler.asFeature(AITMod.id("cactus"));
    }
}

