/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.tardis.handler;

import dev.amble.ait.api.tardis.KeyedTardisComponent;
import dev.amble.ait.api.tardis.TardisComponent;
import dev.amble.ait.api.tardis.TardisTickable;
import dev.amble.ait.core.tardis.handler.travel.TravelHandler;
import dev.amble.ait.data.properties.bool.BoolProperty;
import dev.amble.ait.data.properties.bool.BoolValue;
import net.minecraft.server.MinecraftServer;

public class CloakHandler
extends KeyedTardisComponent
implements TardisTickable {
    private static final BoolProperty IS_CLOAKED = new BoolProperty("is_cloaked", false);
    private final BoolValue isCloaked = IS_CLOAKED.create(this);

    @Override
    public void onLoaded() {
        this.isCloaked.of(this, IS_CLOAKED);
    }

    public CloakHandler() {
        super(TardisComponent.Id.CLOAK);
    }

    public BoolValue cloaked() {
        return this.isCloaked;
    }

    @Override
    public void tick(MinecraftServer server) {
        TravelHandler travel;
        if (!((Boolean)this.cloaked().get()).booleanValue()) {
            return;
        }
        if (!this.tardis.fuel().hasPower()) {
            this.cloaked().set(false);
        }
        if ((travel = this.tardis.travel()).inFlight()) {
            return;
        }
        this.tardis.removeFuel(2 * travel.instability());
    }
}

