/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.tardis.handler;

import dev.amble.ait.api.tardis.KeyedTardisComponent;
import dev.amble.ait.api.tardis.TardisComponent;
import dev.amble.ait.api.tardis.TardisEvents;
import dev.amble.ait.api.tardis.TardisTickable;
import dev.amble.ait.core.AITDimensions;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.blockentities.DoorBlockEntity;
import dev.amble.ait.core.tardis.handler.travel.TravelHandlerBase;
import dev.amble.ait.core.tardis.util.TardisUtil;
import dev.amble.ait.core.world.TardisServerWorld;
import dev.amble.ait.data.Exclude;
import dev.amble.ait.data.properties.Property;
import dev.amble.ait.data.properties.Value;
import dev.amble.ait.data.properties.bool.BoolProperty;
import dev.amble.ait.data.properties.bool.BoolValue;
import dev.amble.ait.data.properties.flt.FloatProperty;
import dev.amble.ait.data.properties.flt.FloatValue;
import dev.amble.ait.data.schema.door.DoorSchema;
import dev.amble.lib.data.DirectedBlockPos;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class DoorHandler
extends KeyedTardisComponent
implements TardisTickable {
    private static final long KNOCK_RESET_TIME_MS = 2500L;
    private static final int KNOCKS_BEFORE_QUIET = 8;
    private static final float KNOCK_VOLUME_FULL = 1.0f;
    private static final float KNOCK_VOLUME_QUIET = 0.3f;
    private int knockCount = 0;
    private long lastKnockTime = 0L;
    private static final BoolProperty LOCKED_DOORS = new BoolProperty("locked");
    private static final BoolProperty PREVIOUSLY_LOCKED = new BoolProperty("previously_locked");
    private static final BoolProperty DEADLOCKED = new BoolProperty("deadlocked");
    private static final Property<DoorState> DOOR_STATE = Property.forEnum("door_state", DoorState.class, DoorState.CLOSED);
    private static final Property<AnimationDoorState> ANIMATION_STATE = Property.forEnum("animation_state", AnimationDoorState.class, AnimationDoorState.CLOSED);
    private static final FloatProperty LEFT_DOOR_ROT = new FloatProperty("left_door_rot");
    private static final FloatProperty RIGHT_DOOR_ROT = new FloatProperty("right_door_rot");
    private final BoolValue locked = LOCKED_DOORS.create(this);
    private final BoolValue previouslyLocked = PREVIOUSLY_LOCKED.create(this);
    private final BoolValue deadlocked = DEADLOCKED.create(this);
    private final Value<DoorState> doorState = DOOR_STATE.create((DoorState)((Object)this));
    private final FloatValue leftDoorRot = LEFT_DOOR_ROT.create(this);
    private final FloatValue rightDoorRot = RIGHT_DOOR_ROT.create(this);
    @Exclude
    @Nullable
    private class_2394 doorOpenParticles = null;
    @Exclude(strategy=Exclude.Strategy.FILE)
    public final Value<AnimationDoorState> animationState = ANIMATION_STATE.create((AnimationDoorState)((Object)this));

    public DoorHandler() {
        super(TardisComponent.Id.DOOR);
    }

    @Override
    public void onLoaded() {
        this.locked.of(this, LOCKED_DOORS);
        this.previouslyLocked.of(this, PREVIOUSLY_LOCKED);
        this.deadlocked.of(this, DEADLOCKED);
        this.doorState.of(this, DOOR_STATE);
        this.animationState.of(this, ANIMATION_STATE);
        this.leftDoorRot.of(this, LEFT_DOOR_ROT);
        this.rightDoorRot.of(this, RIGHT_DOOR_ROT);
    }

    @Override
    public void tick(MinecraftServer server) {
        if (this.shouldSucc()) {
            this.succ();
        }
        boolean wasClosed = this.isClosed();
        this.leftDoorRot.flatMap(rot -> Float.valueOf(this.tryUpdateRot(rot.floatValue(), this.getDoorState() != DoorState.CLOSED)));
        this.rightDoorRot.flatMap(rot -> Float.valueOf(this.tryUpdateRot(rot.floatValue(), this.getDoorState() == DoorState.BOTH)));
        if (wasClosed != this.isClosed()) {
            ((TardisEvents.CloseDoor)TardisEvents.REAL_DOOR_CLOSE.invoker()).onClose(this.tardis);
        }
        if (this.doorOpenParticles != null && !this.tardis().crash().isNormal() && server.method_3780() % 5 == 0 && this.tardis.door().isOpen()) {
            class_243 exteriorPosition = TardisUtil.offsetPos(this.tardis.travel().position().toPos(), -0.15f);
            exteriorPosition = TardisUtil.offsetDoorPosition(exteriorPosition, this.tardis.travel().position().getRotation());
            class_3218 exteriorWorld = this.tardis.travel().position().getWorld();
            exteriorWorld.method_14199(this.doorOpenParticles, exteriorPosition.method_10216(), exteriorPosition.method_10214() + 0.1, exteriorPosition.method_10215(), 25, 0.25, 1.1, 0.25, 0.025);
        }
        if (System.currentTimeMillis() - this.lastKnockTime > 2500L && this.knockCount > 0) {
            this.knockCount = 0;
        }
    }

    private float tryUpdateRot(float rot, boolean opening) {
        if (this.isClosed()) {
            return rot;
        }
        if (opening && rot == 1.0f) {
            return rot;
        }
        if (!opening && rot == 0.0f) {
            return rot;
        }
        return this.calculateRotation(rot, opening);
    }

    public float calculateRotation(float currentRotation, boolean opening) {
        currentRotation = opening ? (float)Math.min((double)currentRotation + ((double)0.13f - (double)currentRotation * 0.1), 1.0) : Math.max(currentRotation - 0.055f, 0.0f);
        return currentRotation;
    }

    private void succ() {
        TardisUtil.getLivingEntitiesInInterior(this.tardis.asServer()).stream().filter(entity -> !entity.method_7325()).forEach(entity -> {
            DirectedBlockPos directed = this.tardis.getDesktop().getDoorPos();
            if (!(this.tardis.asServer().world().method_8321(directed.getPos()) instanceof DoorBlockEntity)) {
                return;
            }
            class_243 pos = new class_243((double)directed.getPos().method_10263(), (double)directed.getPos().method_10264(), (double)directed.getPos().method_10260()).method_43206(directed.toMinecraftDirection(), -1.0);
            float suckValue = this.tardis.travel().position().getDimension().equals(AITDimensions.SPACE) ? 0.08f : 0.05f;
            class_243 motion = pos.method_1020(entity.method_19538()).method_1029().method_1021((double)suckValue);
            entity.method_18799(entity.method_18798().method_1019(motion));
            entity.field_6007 = true;
            entity.field_6037 = true;
        });
    }

    private boolean shouldSucc() {
        DirectedBlockPos directed = this.tardis.getDesktop().getDoorPos();
        if (directed == null) {
            return false;
        }
        return this.tardis.travel().position().getDimension().equals(AITDimensions.SPACE) && this.isOpen() && !this.tardis.areShieldsActive() || !this.tardis.travel().isLanded() && this.isOpen() && !this.tardis.areShieldsActive() && !this.tardis.travel().autopilot();
    }

    public boolean isRightOpen() {
        return this.doorState.get() == DoorState.BOTH;
    }

    public boolean isLeftOpen() {
        return this.doorState.get() == DoorState.HALF || this.doorState.get() == DoorState.BOTH;
    }

    public void setDeadlocked(boolean deadlocked) {
        this.deadlocked.set(deadlocked);
    }

    public void setLocked(boolean locked) {
        this.locked.set(locked);
        if (locked) {
            this.setDoorState(DoorState.CLOSED);
        }
    }

    public boolean locked() {
        return (Boolean)this.locked.get() != false || (Boolean)this.deadlocked.get() != false;
    }

    public boolean hasDoubleDoor() {
        return this.tardis.getExterior().getVariant().door().isDouble();
    }

    public boolean isOpen() {
        return this.doorState.get() != DoorState.CLOSED;
    }

    public boolean isClosed() {
        return ((Float)this.rightDoorRot.get()).floatValue() <= 0.0f && ((Float)this.leftDoorRot.get()).floatValue() <= 0.0f && this.doorState.get() == DoorState.CLOSED;
    }

    public boolean areBothOpen() {
        return ((Float)this.rightDoorRot.get()).floatValue() <= 0.0f && this.doorState.get() == DoorState.BOTH;
    }

    public void openDoors() {
        this.setDoorState(DoorState.HALF);
        if (this.hasDoubleDoor()) {
            this.setDoorState(DoorState.BOTH);
        }
    }

    public void closeDoors() {
        this.setDoorState(DoorState.CLOSED);
    }

    private void setDoorState(DoorState newState) {
        if (this.locked() && newState != DoorState.CLOSED) {
            return;
        }
        DoorState oldState = this.doorState.get();
        if (oldState != newState) {
            this.animationState.set(AnimationDoorState.match(newState, oldState));
            if (oldState == DoorState.CLOSED) {
                ((TardisEvents.OpenDoor)TardisEvents.DOOR_OPEN.invoker()).onOpen(this.tardis());
            }
            if (newState == DoorState.CLOSED) {
                ((TardisEvents.CloseDoor)TardisEvents.DOOR_CLOSE.invoker()).onClose(this.tardis());
            }
        }
        this.doorState.set(newState);
    }

    public DoorState getDoorState() {
        return this.doorState.get();
    }

    public boolean interact(class_3218 world, @Nullable class_2338 pos, @Nullable class_3222 player) {
        return this.interactAllDoors(world, pos, player, false);
    }

    public boolean interactAllDoors(class_3218 world, @Nullable class_2338 pos, @Nullable class_3222 player, boolean both) {
        float knockVolume;
        long now;
        TardisServerWorld interior = this.tardis.asServer().hasWorld() ? this.tardis.asServer().world() : null;
        InteractionResult result = ((TardisEvents.UseDoor)TardisEvents.USE_DOOR.invoker()).onUseDoor(this.tardis, (class_3218)interior, world, player, pos);
        if (result == InteractionResult.KNOCK) {
            now = System.currentTimeMillis();
            if (now - this.lastKnockTime > 2500L) {
                this.knockCount = 0;
            }
            ++this.knockCount;
            this.lastKnockTime = now;
            float f = knockVolume = this.knockCount > 8 ? 0.3f : 1.0f;
            if (pos != null && world != interior) {
                world.method_8396(null, pos, AITSounds.KNOCK, class_3419.field_15245, knockVolume, world.method_8409().method_43056() ? 0.5f : 0.3f);
            }
            if (interior != null) {
                interior.method_8396(null, this.tardis.getDesktop().getDoorPos().getPos(), AITSounds.KNOCK, class_3419.field_15245, knockVolume, world.method_8409().method_43056() ? 0.5f : 0.3f);
            }
        }
        if (result == InteractionResult.BANG) {
            if (pos != null && world != interior) {
                world.method_8396(null, pos, class_3417.field_14742, class_3419.field_15245, 1.0f, 1.0f);
            }
            if (interior != null) {
                interior.method_45447(null, this.tardis.getDesktop().getDoorPos().getPos(), class_3417.field_14742, class_3419.field_15245);
            }
        }
        if (result.returns != TriState.DEFAULT) {
            return result.returns.get();
        }
        if (this.locked()) {
            if (player != null && pos != null) {
                player.method_7353((class_2561)class_2561.method_43470((String)"\ud83d\udd12"), true);
                now = System.currentTimeMillis();
                if (now - this.lastKnockTime > 2500L) {
                    this.knockCount = 0;
                }
                ++this.knockCount;
                this.lastKnockTime = now;
                knockVolume = this.knockCount > 8 ? 0.3f : 1.0f;
                world.method_8396(null, pos, AITSounds.KNOCK, class_3419.field_15245, knockVolume, world.method_8409().method_43056() ? 0.5f : 0.3f);
                if (interior != null) {
                    interior.method_8396(null, this.tardis.getDesktop().getDoorPos().getPos(), AITSounds.KNOCK, class_3419.field_15245, knockVolume, world.method_8409().method_43056() ? 0.5f : 0.3f);
                }
            }
            return false;
        }
        DoorSchema doorSchema = this.tardis.getExterior().getVariant().door();
        class_3414 sound = this.getDoorState().next(doorSchema.isDouble()) == DoorState.CLOSED ? doorSchema.closeSound() : doorSchema.openSound();
        this.tardis.travel().position().getWorld().method_8396(null, this.tardis.travel().position().getPos(), sound, class_3419.field_15245, 0.2f, world.method_8409().method_43056() ? 1.0f : 0.8f);
        if (interior != null) {
            interior.method_8396(null, this.tardis.getDesktop().getDoorPos().getPos(), sound, class_3419.field_15245, 0.2f, world.method_8409().method_43056() ? 1.0f : 0.8f);
        }
        if (player.method_5715() || both) {
            if (this.isOpen()) {
                this.closeDoors();
            } else {
                this.openDoors();
            }
        } else {
            this.setDoorState(this.getDoorState().next(doorSchema.isDouble()));
        }
        ((TardisEvents.DoorUsed)TardisEvents.DOOR_USED.invoker()).onDoorUsed(this.tardis, player);
        return true;
    }

    public boolean interactToggleLock(@Nullable class_3222 player) {
        return this.interactToggleLock(player, false);
    }

    public boolean interactToggleLock(@Nullable class_3222 player, boolean forced) {
        return this.interactLock(!this.locked(), player, forced);
    }

    public boolean interactLock(boolean lock, @Nullable class_3222 player, boolean forced) {
        TardisServerWorld interior;
        String lockedState;
        if (this.locked() == lock) {
            return true;
        }
        if (!(forced || this.tardis.travel().getState() != TravelHandlerBase.State.DEMAT && this.tardis.travel().getState() != TravelHandlerBase.State.MAT)) {
            return false;
        }
        this.setLocked(lock);
        DoorState prevState = this.getDoorState();
        this.setDoorState(DoorState.CLOSED);
        if (prevState != DoorState.CLOSED) {
            ((TardisEvents.DoorUsed)TardisEvents.DOOR_USED.invoker()).onDoorUsed(this.tardis, player);
        }
        if (!forced) {
            this.previouslyLocked().set(this.locked);
        }
        String string = lockedState = this.tardis.door().locked() ? "\ud83d\udd12" : "\ud83d\udd13";
        if (player != null) {
            player.method_7353((class_2561)class_2561.method_43470((String)lockedState), true);
        }
        class_3414 keySound = lock ? AITSounds.KEY_LOCK : AITSounds.KEY_UNLOCK;
        this.tardis.travel().position().getWorld().method_8396(null, this.tardis.travel().position().getPos(), keySound, class_3419.field_15245, 0.6f, 1.0f);
        TardisServerWorld tardisServerWorld = interior = this.tardis.asServer().hasWorld() ? this.tardis.asServer().world() : null;
        if (interior != null) {
            interior.method_8396(null, this.tardis.getDesktop().getDoorPos().getPos(), keySound, class_3419.field_15245, 0.6f, 1.0f);
        }
        return true;
    }

    public BoolValue previouslyLocked() {
        return this.previouslyLocked;
    }

    public float getLeftRot() {
        return ((Float)this.leftDoorRot.get()).floatValue();
    }

    public float getRightRot() {
        return ((Float)this.rightDoorRot.get()).floatValue();
    }

    public void setDoorParticles(class_2394 particle) {
        this.doorOpenParticles = particle;
        this.sync();
    }

    static {
        TardisEvents.DEMAT.register(tardis -> tardis.door().isOpen() ? TardisEvents.Interaction.FAIL : TardisEvents.Interaction.PASS);
        TardisEvents.EXTERIOR_CHANGE.register(tardis -> {
            if (!tardis.door().hasDoubleDoor() && tardis.door().getDoorState() == DoorState.BOTH) {
                tardis.door().setDoorState(DoorState.HALF);
            }
        });
        TardisEvents.MAT.register(tardis -> {
            tardis.door().setDeadlocked(true);
            return TardisEvents.Interaction.PASS;
        });
        TardisEvents.LANDED.register(tardis -> tardis.door().setDeadlocked(false));
    }

    public static enum DoorState {
        CLOSED,
        HALF,
        BOTH;


        public DoorState next(boolean isDouble) {
            return switch (this.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> HALF;
                case 1 -> {
                    if (isDouble) {
                        yield BOTH;
                    }
                    yield CLOSED;
                }
                case 2 -> CLOSED;
            };
        }
    }

    public static enum AnimationDoorState {
        CLOSED,
        FIRST,
        SECOND,
        BOTH;


        public boolean is(DoorState doorState) {
            if (this == CLOSED && doorState == DoorState.CLOSED) {
                return true;
            }
            if (this == FIRST && doorState == DoorState.HALF) {
                return true;
            }
            return (this == BOTH || this == SECOND) && doorState == DoorState.BOTH;
        }

        public static AnimationDoorState match(DoorState newState, DoorState oldState) {
            AnimationDoorState animState = null;
            if (oldState == DoorState.HALF && newState == DoorState.BOTH) {
                animState = SECOND;
            }
            if (oldState == DoorState.CLOSED && newState == DoorState.BOTH) {
                animState = BOTH;
            }
            if (oldState == DoorState.BOTH && newState == DoorState.CLOSED) {
                animState = CLOSED;
            }
            if (oldState == DoorState.CLOSED && newState == DoorState.HALF) {
                animState = FIRST;
            }
            if (animState == null) {
                animState = CLOSED;
            }
            return animState;
        }
    }

    public static enum InteractionResult {
        CANCEL(TriState.FALSE),
        CONTINUE(TriState.DEFAULT),
        KNOCK(TriState.FALSE),
        BANG(TriState.FALSE),
        SUCCESS(TriState.TRUE);

        private final TriState returns;

        private InteractionResult(TriState returns) {
            this.returns = returns;
        }

        public TriState result() {
            return this.returns;
        }
    }
}

