/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.tardis.handler;

import dev.amble.ait.api.tardis.KeyedTardisComponent;
import dev.amble.ait.api.tardis.TardisComponent;
import dev.amble.ait.api.tardis.TardisEvents;
import dev.amble.ait.api.tardis.TardisTickable;
import dev.amble.ait.core.tardis.handler.BiomeHandler;
import dev.amble.ait.core.tardis.handler.travel.TravelHandler;
import dev.amble.ait.core.tardis.handler.travel.TravelHandlerBase;
import dev.amble.ait.data.properties.bool.BoolProperty;
import dev.amble.ait.data.properties.bool.BoolValue;
import dev.amble.lib.data.CachedDirectedGlobalPos;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;

public class ExteriorEnvironmentHandler
extends KeyedTardisComponent
implements TardisTickable {
    private static final BoolProperty RAINING = new BoolProperty("raining", false);
    private static final BoolProperty THUNDERING = new BoolProperty("thundering", false);
    private static final BoolProperty LAVA = new BoolProperty("lava", false);
    private final BoolValue raining = RAINING.create(this);
    private final BoolValue thundering = THUNDERING.create(this);
    private final BoolValue lava = LAVA.create(this);

    public ExteriorEnvironmentHandler() {
        super(TardisComponent.Id.ENVIRONMENT);
    }

    @Override
    public void onLoaded() {
        this.raining.of(this, RAINING);
        this.thundering.of(this, THUNDERING);
        this.lava.of(this, LAVA);
    }

    @Override
    public void tick(MinecraftServer server) {
        boolean isThundering;
        if (server.method_3780() % 10 != 0) {
            return;
        }
        TravelHandler travel = this.tardis.travel();
        class_3218 exterior = travel.position().getWorld();
        if (exterior == null || exterior.method_8608()) {
            return;
        }
        boolean snowy = ((BiomeHandler)this.tardis.handler(TardisComponent.Id.BIOME)).getBiomeKey() == BiomeHandler.BiomeType.SNOWY;
        boolean isRaining = exterior.method_8520(travel.position().getPos()) && exterior.method_8419() && !snowy;
        boolean bl = isThundering = exterior.method_8520(travel.position().getPos()) && exterior.method_8546() && !snowy;
        if (travel.getState() != TravelHandlerBase.State.LANDED) {
            isRaining = false;
            isThundering = false;
        }
        if (this.isRaining() != isRaining) {
            this.raining.set(isRaining);
        }
        if (this.isThundering() != isThundering) {
            this.thundering.set(isThundering);
        }
    }

    private void updateLava() {
        boolean hasLava = this.isInLava();
        if (this.tardis.travel().getState() != TravelHandlerBase.State.LANDED) {
            hasLava = false;
        }
        if (this.hasLava() != hasLava) {
            this.lava.set(hasLava);
        }
    }

    public boolean isRaining() {
        return (Boolean)this.raining.get();
    }

    public boolean isThundering() {
        return (Boolean)this.thundering.get();
    }

    public boolean hasLava() {
        return (Boolean)this.lava.get();
    }

    private boolean isInLava() {
        if (this.isClient()) {
            return false;
        }
        CachedDirectedGlobalPos cached = this.tardis.travel().position();
        class_3218 world = cached.getWorld();
        class_2338 tardisPos = cached.getPos();
        for (int xOffset = -1; xOffset <= 1; ++xOffset) {
            for (int zOffset = -1; zOffset <= 1; ++zOffset) {
                class_2338 blockPos = tardisPos.method_10069(xOffset, 0, zOffset);
                if (world.method_8320(blockPos).method_26204() != class_2246.field_10164) continue;
                return true;
            }
        }
        return false;
    }

    static {
        TardisEvents.LANDED.register(tdis -> ((ExteriorEnvironmentHandler)tdis.handler(TardisComponent.Id.ENVIRONMENT)).updateLava());
    }
}

