/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.tardis.handler;

import dev.amble.ait.api.ArtronHolder;
import dev.amble.ait.api.tardis.KeyedTardisComponent;
import dev.amble.ait.api.tardis.TardisComponent;
import dev.amble.ait.api.tardis.TardisEvents;
import dev.amble.ait.api.tardis.TardisTickable;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.blocks.ExteriorBlock;
import dev.amble.ait.core.engine.impl.EmergencyPower;
import dev.amble.ait.core.engine.impl.EngineSystem;
import dev.amble.ait.core.item.KeyItem;
import dev.amble.ait.core.tardis.handler.DoorHandler;
import dev.amble.ait.core.tardis.handler.HadsHandler;
import dev.amble.ait.core.tardis.handler.travel.TravelHandler;
import dev.amble.ait.core.tardis.handler.travel.TravelHandlerBase;
import dev.amble.ait.core.tardis.util.TardisUtil;
import dev.amble.ait.core.world.RiftChunkManager;
import dev.amble.ait.core.world.TardisServerWorld;
import dev.amble.ait.data.properties.bool.BoolProperty;
import dev.amble.ait.data.properties.bool.BoolValue;
import dev.amble.ait.data.properties.dbl.DoubleProperty;
import dev.amble.ait.data.properties.dbl.DoubleValue;
import dev.amble.lib.data.CachedDirectedGlobalPos;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1743;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1923;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.server.MinecraftServer;

public class FuelHandler
extends KeyedTardisComponent
implements ArtronHolder,
TardisTickable {
    public static final double TARDIS_MAX_FUEL = 50000.0;
    private static final DoubleProperty FUEL = new DoubleProperty("fuel", 1000.0);
    private static final BoolProperty REFUELING = new BoolProperty("refueling", false);
    private static final BoolProperty POWER = new BoolProperty("power", false);
    private final DoubleValue fuel = FUEL.create(this);
    private final BoolValue refueling = REFUELING.create(this);
    private final BoolValue power = POWER.create(this);

    public FuelHandler() {
        super(TardisComponent.Id.FUEL);
    }

    @Override
    public void onLoaded() {
        this.refueling.of(this, REFUELING);
        this.fuel.of(this, FUEL);
        this.power.of(this, POWER);
    }

    @Override
    public void tick(MinecraftServer server) {
        if (server.method_3780() % 20 != 0) {
            return;
        }
        TravelHandler travel = this.tardis().travel();
        TravelHandlerBase.State state = travel.getState();
        switch (state) {
            case LANDED: {
                this.tickIdle();
                break;
            }
            case FLIGHT: {
                this.tickFlight();
                break;
            }
            case MAT: 
            case DEMAT: {
                this.tickMat();
            }
        }
    }

    @Override
    public double getCurrentFuel() {
        return (Double)this.fuel.get();
    }

    @Override
    public void setCurrentFuel(double fuel) {
        double prev = this.getCurrentFuel();
        this.fuel.set(class_3532.method_15350((double)fuel, (double)0.0, (double)this.getMaxFuel()));
        if (this.isOutOfFuel() && prev != 0.0) {
            EmergencyPower backup = this.tardis().subsystems().emergency();
            if (backup.hasBackupPower()) {
                this.setCurrentFuel(backup.getCurrentFuel());
                backup.setCurrentFuel(0.0);
                ((TardisEvents.UseBackupPower)TardisEvents.USE_BACKUP_POWER.invoker()).onUse(this.tardis(), this.getCurrentFuel());
                return;
            }
            ((TardisEvents.NoFuel)TardisEvents.OUT_OF_FUEL.invoker()).onNoFuel(this.tardis);
        }
    }

    @Override
    public double addFuel(double var) {
        EmergencyPower backup = this.tardis().subsystems().emergency();
        if (backup.isEnabled() && !backup.isFull()) {
            return backup.addFuel(var);
        }
        return ArtronHolder.super.addFuel(var);
    }

    @Override
    public double getMaxFuel() {
        return 50000.0;
    }

    private void tickMat() {
        if (this.tardis.isGrowth()) {
            return;
        }
        this.removeFuel(100 * this.tardis.travel().instability());
    }

    public static double getPerTickFuelCost(int speed, int instability) {
        return speed + instability - 1;
    }

    public static double getPerTickFuelCost(TravelHandler travel) {
        return FuelHandler.getPerTickFuelCost(Math.max(travel.speed(), 1), travel.instability());
    }

    private void tickFlight() {
        if (this.tardis.isGrowth()) {
            return;
        }
        TravelHandler travel = this.tardis.travel();
        this.removeFuel(20.0 * FuelHandler.getPerTickFuelCost(travel));
        if (!this.tardis.fuel().hasPower()) {
            travel.crash();
        }
    }

    private void tickIdle() {
        if (((Boolean)this.refueling().get()).booleanValue() && this.getCurrentFuel() < 50000.0) {
            TravelHandler travel = this.tardis.travel();
            CachedDirectedGlobalPos pos = travel.position();
            class_3218 world = pos.getWorld();
            RiftChunkManager manager = RiftChunkManager.getInstance(world);
            class_1923 chunk = new class_1923(pos.getPos());
            double toAdd = 7.0;
            if (manager.getArtron(chunk) > 0.0 && !TardisServerWorld.isTardisDimension(world)) {
                manager.removeFuel(chunk, 2.0);
                toAdd += 2.0;
            }
            this.addFuel(20.0 * toAdd);
        }
        if (!((Boolean)this.refueling().get()).booleanValue() && this.tardis.fuel().hasPower() && !this.tardis.isGrowth()) {
            double instability = this.tardis.travel().instability();
            this.removeFuel(5.0 * instability < 1.0 ? 1.0 : instability);
        }
    }

    public BoolValue refueling() {
        return this.refueling;
    }

    public boolean hasPower() {
        return (Boolean)this.power.get();
    }

    public void togglePower() {
        if (((Boolean)this.power.get()).booleanValue()) {
            this.disablePower();
        } else {
            this.enablePower();
        }
    }

    public void disablePower() {
        if (!((Boolean)this.power.get()).booleanValue()) {
            return;
        }
        this.power.set(false);
        this.updateExteriorState();
        ((TardisEvents.LosePower)TardisEvents.LOSE_POWER.invoker()).onLosePower(this.tardis);
        this.disableProtocols();
    }

    private void disableProtocols() {
        this.tardis.getDesktop().playSoundAtEveryConsole(AITSounds.SHUTDOWN, class_3419.field_15256, 10.0f, 1.0f);
        this.tardis.travel().antigravs().set(false);
        this.tardis.stats().hailMary().set(false);
        ((HadsHandler)this.tardis.handler(TardisComponent.Id.HADS)).enabled().set(false);
    }

    public void enablePower(boolean requiresEngine) {
        if (((Boolean)this.power.get()).booleanValue()) {
            return;
        }
        if (this.tardis.getFuel() <= 500.0) {
            return;
        }
        if (this.tardis.siege().isActive()) {
            return;
        }
        if (requiresEngine && !EngineSystem.hasEngine(this.tardis)) {
            return;
        }
        this.power.set(true);
        this.updateExteriorState();
        this.tardis.getDesktop().playSoundAtEveryConsole(AITSounds.POWERUP, class_3419.field_15256, 10.0f, 1.0f);
        this.tardis.getDesktop().playSoundAtEveryConsole(AITSounds.CONSOLE_BOOTUP, class_3419.field_15256, 0.15f, 1.0f);
        ((TardisEvents.RegainPower)TardisEvents.REGAIN_POWER.invoker()).onRegainPower(this.tardis);
    }

    public void enablePower() {
        this.enablePower(true);
    }

    private void updateExteriorState() {
        TravelHandler travel = this.tardis.travel();
        if (travel.getState() != TravelHandlerBase.State.LANDED) {
            return;
        }
        CachedDirectedGlobalPos pos = travel.position();
        class_3218 world = pos.getWorld();
        if (world == null) {
            return;
        }
        class_2680 state = world.method_8320(pos.getPos());
        if (!(state.method_26204() instanceof ExteriorBlock)) {
            return;
        }
        world.method_8501(pos.getPos(), (class_2680)state.method_11657((class_2769)ExteriorBlock.LEVEL_4, (Comparable)Integer.valueOf((Boolean)this.power.get() != false ? 4 : 0)));
    }

    static {
        TardisEvents.DEMAT.register(tardis -> (Boolean)tardis.fuel().refueling().get() != false ? TardisEvents.Interaction.FAIL : TardisEvents.Interaction.PASS);
        TardisEvents.USE_DOOR.register((tardis, interior, world, player, pos) -> {
            class_1743 axeItem;
            class_1792 patt1$temp;
            if (tardis.fuel().hasPower() || !tardis.door().locked() || player == null) {
                return DoorHandler.InteractionResult.CONTINUE;
            }
            class_1799 stack = player.method_5998(class_1268.field_5808);
            class_1792 patt0$temp = stack.method_7909();
            if (patt0$temp instanceof KeyItem) {
                KeyItem key = (KeyItem)patt0$temp;
                if (tardis.siege().isActive() && key.isOf(stack, tardis) && TardisUtil.isInteriorEmpty(tardis.asServer())) {
                    player.method_6104(class_1268.field_5808);
                    tardis.siege().setActive(false);
                    tardis.door().interactLock(false, player, true);
                }
            }
            if ((patt1$temp = stack.method_7909()) instanceof class_1743 && (axeItem = (class_1743)patt1$temp).method_26366() >= 8.0f && stack.method_7909() != class_1802.field_8062) {
                if (tardis.siege().isActive()) {
                    return DoorHandler.InteractionResult.CANCEL;
                }
                player.method_6104(class_1268.field_5808);
                stack.method_7974(stack.method_7919() - 1);
                if (pos != null) {
                    world.method_8396(null, pos, class_3417.field_14742, class_3419.field_15245, 1.0f, 1.0f);
                }
                interior.method_45447(null, tardis.getDesktop().getDoorPos().getPos(), class_3417.field_14742, class_3419.field_15245);
                tardis.door().interactLock(false, player, true);
                tardis.door().openDoors();
                ((TardisEvents.OnForcedEntry)TardisEvents.FORCED_ENTRY.invoker()).onForcedEntry(tardis, (class_1297)player);
                return DoorHandler.InteractionResult.SUCCESS;
            }
            return DoorHandler.InteractionResult.KNOCK;
        });
    }
}

