/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.tardis.handler;

import dev.amble.ait.api.tardis.KeyedTardisComponent;
import dev.amble.ait.api.tardis.TardisComponent;
import dev.amble.ait.api.tardis.TardisTickable;
import dev.amble.ait.core.tardis.handler.ServerAlarmHandler;
import dev.amble.ait.core.tardis.handler.travel.TravelHandler;
import dev.amble.ait.core.tardis.handler.travel.TravelHandlerBase;
import dev.amble.ait.data.properties.bool.BoolProperty;
import dev.amble.ait.data.properties.bool.BoolValue;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1541;
import net.minecraft.class_1548;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.server.MinecraftServer;

public class HadsHandler
extends KeyedTardisComponent
implements TardisTickable {
    private static final BoolProperty HADS_ENABLED = new BoolProperty("enabled", false);
    private static final BoolProperty IS_IN_ACTIVE_DANGER = new BoolProperty("is_in_active_danger", false);
    private final BoolValue enabled = HADS_ENABLED.create(this);
    private final BoolValue inDanger = IS_IN_ACTIVE_DANGER.create(this);

    public HadsHandler() {
        super(TardisComponent.Id.HADS);
    }

    public boolean isActive() {
        return (Boolean)this.enabled.get();
    }

    public void setIsInDanger(boolean bool) {
        this.inDanger.set(bool);
    }

    public boolean isInDanger() {
        return (Boolean)this.inDanger.get();
    }

    @Override
    public void onLoaded() {
        this.enabled.of(this, HADS_ENABLED);
        this.inDanger.of(this, IS_IN_ACTIVE_DANGER);
    }

    @Override
    public void tick(MinecraftServer server) {
        if (this.isActive()) {
            this.tickingForDanger((class_1937)this.tardis.travel().position().getWorld());
        }
    }

    public void tickingForDanger(class_1937 world) {
        List listOfEntities = world.method_8333(null, new class_238(this.tardis.travel().position().getPos()).method_1014(3.0), class_1301.field_6156);
        for (class_1297 entity : listOfEntities) {
            if (entity instanceof class_1548) {
                class_1548 creeperEntity = (class_1548)entity;
                if (creeperEntity.method_7007() > 0) {
                    this.setIsInDanger(true);
                    break;
                }
            } else if (entity instanceof class_1541) {
                this.setIsInDanger(true);
                break;
            }
            this.setIsInDanger(false);
        }
        this.dematerialiseWhenInDanger();
    }

    public void dematerialiseWhenInDanger() {
        TravelHandler travel = this.tardis.travel();
        TravelHandlerBase.State state = travel.getState();
        ServerAlarmHandler alarm = this.tardis.alarm();
        if (this.isInDanger()) {
            if (state == TravelHandlerBase.State.LANDED) {
                travel.dematerialize();
            }
            alarm.enable();
            return;
        }
        if (state == TravelHandlerBase.State.FLIGHT) {
            travel.rematerialize();
        }
        if (state == TravelHandlerBase.State.MAT) {
            alarm.disable();
        }
    }

    public BoolValue enabled() {
        return this.enabled;
    }
}

