/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.tardis.handler;

import dev.amble.ait.AITMod;
import dev.amble.ait.api.tardis.KeyedTardisComponent;
import dev.amble.ait.api.tardis.TardisComponent;
import dev.amble.ait.api.tardis.TardisEvents;
import dev.amble.ait.api.tardis.TardisTickable;
import dev.amble.ait.core.AITDamageTypes;
import dev.amble.ait.core.AITItems;
import dev.amble.ait.core.advancement.TardisCriterions;
import dev.amble.ait.core.blockentities.ConsoleBlockEntity;
import dev.amble.ait.core.engine.SubSystem;
import dev.amble.ait.core.tardis.handler.ServerAlarmHandler;
import dev.amble.ait.core.tardis.handler.travel.TravelHandler;
import dev.amble.ait.core.tardis.handler.travel.TravelHandlerBase;
import dev.amble.ait.core.tardis.manager.ServerTardisManager;
import dev.amble.ait.core.tardis.util.TardisUtil;
import dev.amble.ait.core.util.SafePosSearch;
import dev.amble.ait.core.world.TardisServerWorld;
import dev.amble.ait.data.Exclude;
import dev.amble.ait.data.properties.Property;
import dev.amble.ait.data.properties.bool.BoolProperty;
import dev.amble.ait.data.properties.bool.BoolValue;
import dev.amble.ait.data.properties.integer.IntProperty;
import dev.amble.ait.data.properties.integer.IntValue;
import dev.amble.ait.data.schema.desktop.TardisDesktopSchema;
import dev.amble.ait.registry.impl.CategoryRegistry;
import dev.amble.ait.registry.impl.DesktopRegistry;
import dev.amble.ait.registry.impl.exterior.ExteriorVariantRegistry;
import dev.amble.lib.data.CachedDirectedGlobalPos;
import dev.amble.lib.data.DirectedBlockPos;
import dev.drtheo.queue.api.util.Value;
import dev.drtheo.scheduler.api.TimeUnit;
import dev.drtheo.scheduler.api.common.Scheduler;
import dev.drtheo.scheduler.api.common.TaskStage;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.server.MinecraftServer;

public class InteriorChangingHandler
extends KeyedTardisComponent
implements TardisTickable {
    public static final class_2960 CHANGE_DESKTOP = AITMod.id("change_desktop");
    private static final Property<class_2960> QUEUED_INTERIOR_PROPERTY = new Property<class_2960>(Property.IDENTIFIER, "queued_interior", new class_2960(""));
    private static final BoolProperty QUEUED = new BoolProperty("queued");
    private static final BoolProperty REGENERATING = new BoolProperty("regenerating");
    private static final int MIN_FUEL_COST = 5000;
    public static final int MAX_PLASMIC_MATERIAL_AMOUNT = 8;
    private static final class_2561 HINT_TEXT = class_2561.method_43471((String)"tardis.message.growth.hint").method_27695(new class_124[]{class_124.field_1063, class_124.field_1056});
    private final dev.amble.ait.data.properties.Value<class_2960> queuedInterior = QUEUED_INTERIOR_PROPERTY.create((class_2960)this);
    private static final IntProperty PLASMIC_MATERIAL_AMOUNT = new IntProperty("plasmic_material_amount");
    private final IntValue plasmicMaterialAmount = PLASMIC_MATERIAL_AMOUNT.create(this);
    private static final BoolProperty HAS_CAGE = new BoolProperty("has_cage");
    private final BoolValue hasCage = HAS_CAGE.create(this);
    private final BoolValue queued = QUEUED.create(this);
    private final BoolValue regenerating = REGENERATING.create(this);
    @Exclude
    private boolean countdownStarted = false;
    @Exclude
    private List<class_1799> restorationChestContents;

    public InteriorChangingHandler() {
        super(TardisComponent.Id.INTERIOR);
    }

    @Override
    public void onLoaded() {
        this.plasmicMaterialAmount.of(this, PLASMIC_MATERIAL_AMOUNT);
        this.hasCage.of(this, HAS_CAGE);
        this.queuedInterior.of(this, QUEUED_INTERIOR_PROPERTY);
        this.queued.of(this, QUEUED);
        this.regenerating.of(this, REGENERATING);
        if (this.isServer() && ((Boolean)this.regenerating.get()).booleanValue()) {
            this.regenerating.set(false);
            TardisDesktopSchema queued = this.getQueuedInterior();
            if (queued == null) {
                return;
            }
            this.tardis.interiorChangingHandler().queueInteriorChange(queued);
        }
    }

    public BoolValue queued() {
        return this.queued;
    }

    public int plasmicMaterialAmount() {
        return (Integer)this.plasmicMaterialAmount.get();
    }

    public boolean hasCage() {
        return (Boolean)this.hasCage.get();
    }

    public void setHasCage(boolean value) {
        this.hasCage.set(value);
    }

    public void setPlasmicMaterialAmount(int amount) {
        this.plasmicMaterialAmount.set(amount);
    }

    public void addPlasmicMaterial(int amount) {
        this.plasmicMaterialAmount.set(Math.min(this.plasmicMaterialAmount() + amount, 8));
    }

    public BoolValue regenerating() {
        return this.regenerating;
    }

    public TardisDesktopSchema getQueuedInterior() {
        return (TardisDesktopSchema)DesktopRegistry.getInstance().get(this.queuedInterior.get());
    }

    public void queueInteriorChange(TardisDesktopSchema schema) {
        if (!this.canQueue()) {
            return;
        }
        if (this.tardis.fuel().getCurrentFuel() < (double)(5000 * this.tardis.travel().instability())) {
            this.tardis.asServer().world().method_18456().forEach(player -> player.method_7353((class_2561)class_2561.method_43471((String)"tardis.message.interiorchange.not_enough_fuel").method_27692(class_124.field_1061), true));
            return;
        }
        if (this.tardis.subsystems().isEnabled()) {
            this.tardis.asServer().world().method_18456().forEach(player -> {
                int count = 0;
                for (SubSystem subSystem : this.tardis.subsystems()) {
                    if (!subSystem.isEnabled()) continue;
                    ++count;
                }
                player.method_7353((class_2561)class_2561.method_43469((String)"tardis.message.interiorchange.subsystems_enabled", (Object[])new Object[]{count}).method_27692(class_124.field_1061), false);
            });
        }
        AITMod.LOGGER.info("Queueing interior change for {} to {}", (Object)this.tardis, (Object)schema);
        this.queuedInterior.set(schema.id());
        this.queued.set(true);
        TravelHandler travel = this.tardis.travel();
        if (travel.getState() == TravelHandlerBase.State.FLIGHT && !travel.isCrashing() && !this.tardis.isGrowth()) {
            travel.crash();
        }
        this.restorationChestContents = new ArrayList<class_1799>();
        for (SubSystem system : this.tardis.subsystems()) {
            if (!system.isReal()) continue;
            this.restorationChestContents.addAll(system.toStacks());
            AITMod.LOGGER.debug("Storing Subsystem, {} ({}) => {}", new Object[]{system.getId(), system.isEnabled(), system.toStacks()});
        }
    }

    private void changeInterior() {
        this.tardis.getDesktop().changeInterior(this.getQueuedInterior(), true, true).thenRun(() -> {
            this.queued.set(false);
            this.regenerating.set(false);
            if (this.tardis.hasGrowthExterior()) {
                TravelHandler travel = this.tardis.travel();
                travel.autopilot(true);
                travel.forceDemat();
                this.replaceAllConsolesWithGrowth();
            } else {
                this.tardis.removeFuel(5000 * this.tardis.travel().instability());
            }
            TardisUtil.sendMessageToLinked(this.tardis.asServer(), (class_2561)class_2561.method_43469((String)"tardis.message.interiorchange.success", (Object[])new Object[]{this.tardis.stats().getName(), this.tardis.getDesktop().getSchema().name()}));
            this.tardis.getDesktop().getConsolePos().stream().findFirst().ifPresent(blockPos -> {
                if (this.restorationChestContents == null || this.restorationChestContents.isEmpty()) {
                    AITMod.LOGGER.debug("No contents to save in recovery inventory in console for {}", (Object)this.tardis);
                    return;
                }
                class_2586 patt0$temp = this.tardis.asServer().world().method_8321((class_2338)blockPos);
                if (patt0$temp instanceof ConsoleBlockEntity) {
                    ConsoleBlockEntity consoleBlockEntity = (ConsoleBlockEntity)patt0$temp;
                    for (int i = 0; i < this.restorationChestContents.size() && i < consoleBlockEntity.getInventory().size(); ++i) {
                        consoleBlockEntity.getInventory().set(i, (Object)this.restorationChestContents.get(i));
                    }
                }
            });
            class_2400 particle = class_2398.field_11204;
            this.tardis.door().setDoorParticles((class_2394)particle);
            Scheduler.get().runTaskLater(() -> this.tardis.door().setDoorParticles(null), TaskStage.END_SERVER_TICK, TimeUnit.SECONDS, 3L);
        }).execute();
    }

    private void replaceConsoleWithGrowth(class_2338 cPos) {
        TardisServerWorld world = this.tardis.asServer().world();
        class_2586 class_25862 = world.method_8321(cPos);
        if (!(class_25862 instanceof ConsoleBlockEntity)) {
            return;
        }
        ConsoleBlockEntity console = (ConsoleBlockEntity)class_25862;
        world.method_8501(cPos, class_2246.field_10124.method_9564());
        world.method_8501(cPos.method_10074(), class_2246.field_10114.method_9564());
        console.onBroken();
    }

    private void replaceAllConsolesWithGrowth() {
        for (class_2338 cPos : this.tardis.getDesktop().getConsolePos()) {
            this.replaceConsoleWithGrowth(cPos);
        }
    }

    private void createChestAtInteriorDoor(List<class_1799> contents) {
        if (contents == null || contents.isEmpty()) {
            AITMod.LOGGER.debug("No contents to save in recovery chest for {}", (Object)this.tardis);
            return;
        }
        DirectedBlockPos door = this.tardis.getDesktop().getDoorPos();
        CachedDirectedGlobalPos safe = CachedDirectedGlobalPos.create((class_3218)this.tardis.asServer().world(), door.getPos().method_10079(door.toMinecraftDirection(), 2), door.getRotation());
        Value ref = new Value(null);
        SafePosSearch.wrapSafe(safe, SafePosSearch.Kind.MEDIAN, true, result -> this.finishCreatingChest((CachedDirectedGlobalPos)((Object)result), contents));
    }

    private void finishCreatingChest(CachedDirectedGlobalPos safe, List<class_1799> contents) {
        if (!safe.getWorld().method_8320(safe.getPos()).method_26215()) {
            AITMod.LOGGER.error("Failed to create recovery chest at {} for {}", (Object)safe, (Object)this.tardis);
            return;
        }
        class_2350 doorDir = this.tardis.getDesktop().getDoorPos().toMinecraftDirection();
        safe.getWorld().method_8652(safe.getPos(), (class_2680)class_2246.field_10034.method_9564().method_11657((class_2769)class_2281.field_10768, (Comparable)doorDir.method_10153()), 3);
        class_2595 chest = (class_2595)safe.getWorld().method_8321(safe.getPos());
        ArrayList<class_1799> overflow = new ArrayList<class_1799>(contents);
        for (int i = 0; i < 27 && !overflow.isEmpty(); ++i) {
            chest.method_5447(i, (class_1799)overflow.remove(0));
        }
        AITMod.LOGGER.debug("Created recovery chest at {} for {}", (Object)safe, (Object)this.tardis);
        if (!overflow.isEmpty()) {
            this.createChestAtInteriorDoor(overflow);
        }
    }

    @Override
    public void tick(MinecraftServer server) {
        boolean isQueued = (Boolean)this.queued.get();
        if (server.method_3780() % 10 == 0 && this.tardis.isGrowth()) {
            this.generateInteriorWithItem();
            if (!isQueued) {
                if (server.method_3780() % 200 == 0 && this.hasEnoughPlasmicMaterial()) {
                    this.tardis.asServer().world().method_18456().forEach(player -> player.method_7353(HINT_TEXT, true));
                }
                if (this.tardis.door().isClosed()) {
                    this.tardis.door().openDoors();
                } else {
                    this.tardis.door().setLocked(false);
                }
            }
        }
        if (!isQueued) {
            return;
        }
        if (!this.canQueue()) {
            this.queued.set(false);
            this.regenerating.set(false);
            this.tardis.alarm().disable();
            return;
        }
        if (!TardisUtil.isInteriorEmpty(this.tardis.asServer()) && ((Boolean)this.regenerating.get()).booleanValue()) {
            class_1657 target = TardisUtil.getAnyPlayerInsideInterior((class_3218)this.tardis.asServer().world());
            if (this.tardis().subsystems().lifeSupport().isEnabled()) {
                TardisUtil.teleportOutside(this.tardis.asServer(), (class_1297)target);
            } else {
                target.method_5643(AITDamageTypes.of(target.method_37908(), AITDamageTypes.INTERIOR_CHANGE), Float.MAX_VALUE);
            }
        }
        if (!((Boolean)this.regenerating.get()).booleanValue() && !this.countdownStarted) {
            this.startRegeneratingCountdown();
        }
    }

    private ServerAlarmHandler.Countdown startRegeneratingCountdown() {
        ServerAlarmHandler.Countdown cd = new ServerAlarmHandler.Countdown.Builder().bellTolls(5).message("tardis.message.interiorchange.regenerating").thenRun(() -> {
            this.tardis.getDesktop().startQueue(true);
            Scheduler.get().runTaskLater(this::changeInterior, TaskStage.END_SERVER_TICK, TimeUnit.SECONDS, 5L);
            this.regenerating.set(true);
            this.countdownStarted = false;
        });
        this.tardis().alarm().enable(cd);
        this.countdownStarted = true;
        return cd;
    }

    public boolean hasEnoughPlasmicMaterial() {
        return this.plasmicMaterialAmount() == 8;
    }

    protected void generateInteriorWithItem() {
        if (!this.hasEnoughPlasmicMaterial()) {
            TardisUtil.sendMessageToInterior(this.tardis.asServer(), (class_2561)class_2561.method_43469((String)"tardis.message.interiorchange.not_enough_plasmic_material", (Object[])new Object[]{this.plasmicMaterialAmount()}).method_27692(class_124.field_1080));
            return;
        }
        TardisUtil.getEntitiesInInterior(this.tardis, 50).stream().filter(entity -> {
            class_1542 item;
            return entity instanceof class_1542 && (item = (class_1542)entity).method_6983().method_7909() == AITItems.PERSONALITY_MATRIX && entity.method_5799();
        }).forEach(entity -> {
            class_2487 nbt;
            class_1542 item = (class_1542)entity;
            class_1799 stack = item.method_6983();
            CachedDirectedGlobalPos position = this.tardis.travel().position();
            if (position == null) {
                return;
            }
            this.tardis.setFuelCount(8000.0);
            entity.method_37908().method_8396(null, entity.method_24515(), class_3417.field_14891, class_3419.field_15245, 10.0f, 0.75f);
            entity.method_37908().method_8396(null, position.getPos(), class_3417.field_14891, class_3419.field_15245, 10.0f, 0.75f);
            this.queueInteriorChange((TardisDesktopSchema)DesktopRegistry.getInstance().get(AITMod.id("cave")));
            if (stack.method_31574(AITItems.PERSONALITY_MATRIX) && (nbt = stack.method_7948()).method_10545("name")) {
                this.tardis.stats().setName(nbt.method_10558("name"));
            }
            if (((Boolean)this.queued.get()).booleanValue()) {
                entity.method_31472();
            }
        });
    }

    private boolean canQueue() {
        return this.tardis.isGrowth() || this.tardis.fuel().hasPower() || this.tardis.crash().isToxic();
    }

    static {
        TardisEvents.DEMAT.register(tardis -> {
            if (tardis.isGrowth() || ((Boolean)tardis.interiorChangingHandler().queued().get()).booleanValue()) {
                return TardisEvents.Interaction.FAIL;
            }
            return TardisEvents.Interaction.PASS;
        });
        TardisEvents.MAT.register(tardis -> {
            if (!tardis.isGrowth()) {
                return TardisEvents.Interaction.PASS;
            }
            tardis.travel().autopilot(false);
            tardis.getExterior().setType(CategoryRegistry.CAPSULE);
            tardis.getExterior().setVariant(ExteriorVariantRegistry.CAPSULE_DEFAULT);
            return TardisEvents.Interaction.SUCCESS;
        });
        TardisEvents.LOSE_POWER.register(tardis -> tardis.interiorChangingHandler().queued.set(false));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)CHANGE_DESKTOP, (ServerPlayNetworking.PlayChannelHandler)ServerTardisManager.receiveTardis((tardis, server, player, handler, buf, responseSender) -> {
            TardisDesktopSchema desktop = (TardisDesktopSchema)DesktopRegistry.getInstance().get(buf.method_10810());
            if (tardis == null || desktop == null) {
                return;
            }
            if (tardis.travel().getState() != TravelHandlerBase.State.LANDED) {
                return;
            }
            TardisCriterions.REDECORATE.trigger(player);
            tardis.interiorChangingHandler().queueInteriorChange(desktop);
            tardis.alarm().enable();
        }));
    }
}

