/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.tardis.handler;

import dev.amble.ait.AITMod;
import dev.amble.ait.api.Nameable;
import dev.amble.ait.api.tardis.TardisComponent;
import dev.amble.ait.api.tardis.TardisTickable;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.advancement.TardisCriterions;
import dev.amble.ait.core.likes.ItemOpinion;
import dev.amble.ait.core.likes.ItemOpinionRegistry;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.data.Loyalty;
import dev.amble.ait.data.schema.console.ConsoleVariantSchema;
import dev.amble.ait.data.schema.desktop.TardisDesktopSchema;
import dev.amble.ait.data.schema.exterior.ExteriorVariantSchema;
import dev.amble.ait.data.schema.sonic.SonicSchema;
import dev.amble.ait.registry.impl.DesktopRegistry;
import dev.amble.ait.registry.impl.SonicRegistry;
import dev.amble.ait.registry.impl.console.variant.ConsoleVariantRegistry;
import dev.amble.ait.registry.impl.exterior.ExteriorVariantRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;

public class LoyaltyHandler
extends TardisComponent
implements TardisTickable {
    private final Map<UUID, Loyalty> data;
    private boolean messageEnabled = true;

    public boolean isMessageEnabled() {
        return this.messageEnabled;
    }

    public void setMessageEnabled(boolean messageEnabled) {
        this.messageEnabled = messageEnabled;
    }

    public LoyaltyHandler(HashMap<UUID, Loyalty> data) {
        super(TardisComponent.Id.LOYALTY);
        this.data = data;
    }

    public LoyaltyHandler() {
        this(new HashMap<UUID, Loyalty>());
    }

    public Map<UUID, Loyalty> data() {
        return this.data;
    }

    public Loyalty get(class_1657 player) {
        return this.data.getOrDefault(player.method_5667(), new Loyalty(Loyalty.Type.NEUTRAL));
    }

    public Loyalty set(class_3222 player, Loyalty loyalty) {
        this.data.put(player.method_5667(), loyalty);
        this.unlock(player, loyalty);
        this.sync();
        return loyalty;
    }

    @Override
    public void tick(MinecraftServer server) {
        if (server.method_3780() % 40 != 0) {
            return;
        }
        for (class_3222 player : this.tardis.asServer().world().method_18456()) {
            Loyalty loyalty = this.get((class_1657)player);
            if (!loyalty.isOf(Loyalty.Type.NEUTRAL)) continue;
            if (ItemOpinionRegistry.getInstance().get(player.method_6047()).isPresent()) {
                ItemOpinion opinion = ItemOpinionRegistry.getInstance().get(player.method_6047()).get();
                this.tardis.opinions().contains(opinion);
                player.method_43496((class_2561)class_2561.method_43469((String)"ait.tardis.likes_item", (Object[])new Object[]{true}));
            }
            if (AITMod.RANDOM.nextInt(0, 20) != 14) continue;
            this.addLevel(player, 1);
        }
    }

    public void update(class_3222 player, Function<Loyalty, Loyalty> consumer) {
        Loyalty current = this.get((class_1657)player);
        current = consumer.apply(current);
        this.set(player, current);
    }

    public void unlock(class_3222 player, Loyalty loyalty) {
        ServerTardis tardis = (ServerTardis)this.tardis;
        boolean playSound = this.messageEnabled;
        if (playSound) {
            playSound = ConsoleVariantRegistry.getInstance().tryUnlock(tardis, loyalty, schema -> this.playUnlockEffects(player, (Nameable)schema));
            playSound = DesktopRegistry.getInstance().tryUnlock(tardis, loyalty, schema -> this.playUnlockEffects(player, (Nameable)schema)) || playSound;
            playSound = ExteriorVariantRegistry.getInstance().tryUnlock(tardis, loyalty, schema -> this.playUnlockEffects(player, (Nameable)schema)) || playSound;
            boolean bl = playSound = SonicRegistry.getInstance().tryUnlock(tardis, loyalty, schema -> this.playUnlockEffects(player, (Nameable)schema)) || playSound;
        }
        if (playSound) {
            player.method_51469().method_8396(null, player.method_24515(), AITSounds.LOYALTY_UP, class_3419.field_15248, 0.2f, 1.0f);
        }
        if (loyalty.isOf(Loyalty.Type.OWNER)) {
            TardisCriterions.REACH_OWNER.trigger(player);
        } else if (loyalty.isOf(Loyalty.Type.PILOT)) {
            TardisCriterions.REACH_PILOT.trigger(player);
        }
    }

    private void playUnlockEffects(class_3222 player, Nameable nameable) {
        class_5250 nameText = nameable.text().method_27661().method_27692(class_124.field_1060);
        class_5250 unlockedMessage = nameable instanceof SonicSchema ? class_2561.method_43469((String)"message.ait.unlocked_sonic", (Object[])new Object[]{nameText}).method_27692(class_124.field_1068) : (nameable instanceof ConsoleVariantSchema ? class_2561.method_43469((String)"message.ait.unlocked_console", (Object[])new Object[]{nameText}).method_27692(class_124.field_1068) : (nameable instanceof TardisDesktopSchema ? class_2561.method_43469((String)"message.ait.unlocked_interior", (Object[])new Object[]{nameText}).method_27692(class_124.field_1068) : (nameable instanceof ExteriorVariantSchema ? class_2561.method_43469((String)"message.ait.unlocked_exterior", (Object[])new Object[]{nameText}).method_27692(class_124.field_1068) : class_2561.method_43469((String)"message.ait.unlocked", (Object[])new Object[]{nameText}).method_27692(class_124.field_1068))));
        player.method_7353((class_2561)unlockedMessage, false);
    }

    public void addLevel(class_3222 player, int level) {
        this.update(player, loyalty -> loyalty.add(level));
    }

    public void subLevel(class_3222 player, int level) {
        this.addLevel(player, -level);
    }

    public class_3222 getLoyalPlayerInside() {
        Tardis tardis = this.tardis;
        if (!(tardis instanceof ServerTardis)) {
            return null;
        }
        ServerTardis serverTardis = (ServerTardis)tardis;
        class_3222 highest = null;
        int highestLoyalty = 0;
        for (class_3222 player : serverTardis.world().method_18456()) {
            if (highest == null) {
                highest = player;
                highestLoyalty = this.get((class_1657)highest).level();
                continue;
            }
            int found = this.get((class_1657)player).level();
            if (found <= highestLoyalty) continue;
            highest = player;
            highestLoyalty = found;
        }
        return highest;
    }

    public void sendMessageToPilot(class_2561 text) {
        class_3222 player = this.getLoyalPlayerInside();
        if (player == null) {
            return;
        }
        player.method_7353(text, true);
    }
}

