/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.tardis.handler;

import dev.amble.ait.AITMod;
import dev.amble.ait.api.tardis.KeyedTardisComponent;
import dev.amble.ait.api.tardis.TardisComponent;
import dev.amble.ait.api.tardis.TardisEvents;
import dev.amble.ait.api.tardis.TardisTickable;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.engine.SubSystem;
import dev.amble.ait.core.engine.impl.GravitationalCircuit;
import dev.amble.ait.core.entities.FallingTardisEntity;
import dev.amble.ait.core.entities.FlightTardisEntity;
import dev.amble.ait.core.tardis.util.TardisUtil;
import dev.amble.ait.data.properties.bool.BoolProperty;
import dev.amble.ait.data.properties.bool.BoolValue;
import dev.drtheo.scheduler.api.TimeUnit;
import dev.drtheo.scheduler.api.common.Scheduler;
import dev.drtheo.scheduler.api.common.TaskStage;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_7718;
import net.minecraft.server.MinecraftServer;

public class RealFlightHandler
extends KeyedTardisComponent
implements TardisTickable {
    private static final class_2960 ENTER_FLIGHT = AITMod.id("enter_flight");
    private static final class_2960 EXIT_FLIGHT = AITMod.id("exit_flight");
    private static final BoolProperty IS_FALLING = new BoolProperty("falling", false);
    private static final BoolProperty FLYING = new BoolProperty("flying", false);
    private static final BoolProperty SHOULD_FALL = new BoolProperty("should_fall", false);
    private final BoolValue falling = IS_FALLING.create(this);
    private final BoolValue flying = FLYING.create(this);
    private final BoolValue shouldFall = SHOULD_FALL.create(this);

    public RealFlightHandler() {
        super(TardisComponent.Id.FLIGHT);
    }

    @Override
    public void onLoaded() {
        this.falling.of(this, IS_FALLING);
        this.flying.of(this, FLYING);
        this.shouldFall.of(this, SHOULD_FALL);
    }

    public boolean isFlying() {
        return (Boolean)this.flying.get();
    }

    @Override
    public void tick(MinecraftServer server) {
        if (((Boolean)this.falling.get()).booleanValue()) {
            this.tardis.door().setLocked(true);
        }
    }

    public void tickFlight(class_3222 player) {
        GravitationalCircuit circuit;
        this.tardis.travel().forcePosition(cached -> cached.pos(player.method_24515()).rotation((byte)class_7718.method_45479((float)player.method_36454())));
        if (player.field_6012 % 20 != 0 && (circuit = (GravitationalCircuit)this.tardis.subsystems().get(SubSystem.Id.GRAVITATIONAL)).isEnabled()) {
            circuit.removeDurability(0.5f);
        }
    }

    public void onLanding(class_3218 world, class_2338 pos) {
        this.tardis.travel().forcePosition(cached -> cached.world(world.method_27983()).pos(pos));
        this.falling.set(false);
        this.tardis.door().setLocked((Boolean)this.tardis.door().previouslyLocked().get());
        this.tardis.door().setDeadlocked(false);
        world.method_45447(null, pos, AITSounds.LAND_THUD, class_3419.field_15245);
        this.tardis.getDesktop().playSoundAtEveryConsole(AITSounds.LAND_THUD, class_3419.field_15245);
        ((TardisEvents.Landed)TardisEvents.LANDED.invoker()).onLanded(this.tardis);
    }

    public void onStartFalling(class_3218 world, class_2680 state, class_2338 pos) {
        this.falling.set(true);
        ((TardisEvents.StartFalling)TardisEvents.START_FALLING.invoker()).onStartFall(this.tardis);
        FallingTardisEntity.spawnFromBlock((class_1937)world, pos, state);
    }

    public void enterFlight(class_3222 player) {
        if (!AITMod.CONFIG.rwfEnabled) {
            return;
        }
        this.tardis.door().closeDoors();
        this.tardis().travel().autopilot(false);
        this.tardis.travel().handbrake(true);
        this.flying.set(true);
        FlightTardisEntity entity = FlightTardisEntity.createAndSpawn(player, this.tardis.asServer());
        TardisUtil.teleportOutside(this.tardis, (class_1297)player);
        Scheduler.get().runTaskLater(() -> {
            player.method_5804((class_1297)entity);
            this.sendEnterFlightPacket(player);
        }, TaskStage.END_SERVER_TICK, TimeUnit.TICKS, 2L);
        this.tardis.travel().finishDemat();
    }

    private void sendEnterFlightPacket(class_3222 player) {
        if (!AITMod.CONFIG.rwfEnabled) {
            return;
        }
        ServerPlayNetworking.send((class_3222)player, (class_2960)ENTER_FLIGHT, (class_2540)PacketByteBufs.create());
    }

    public void exitFlight(class_3222 player) {
        this.flying.set(false);
        player.method_5648(false);
        player.method_5684(false);
        this.sendExitFlightPacket(player);
        this.tardis.travel().forcePosition(cached -> cached.rotation((byte)class_7718.method_45479((float)player.method_36454())));
        this.tardis.travel().placeExterior(false);
        this.tardis.travel().finishRemat();
    }

    private void sendExitFlightPacket(class_3222 player) {
        ServerPlayNetworking.send((class_3222)player, (class_2960)EXIT_FLIGHT, (class_2540)PacketByteBufs.create());
    }

    public BoolValue falling() {
        return this.falling;
    }

    public BoolValue flying() {
        return this.flying;
    }

    public BoolValue shouldFall() {
        return this.shouldFall;
    }

    static {
        TardisEvents.DEMAT.register(tardis -> {
            tardis.flight().flying.set(false);
            return (Boolean)tardis.flight().falling().get() != false ? TardisEvents.Interaction.FAIL : TardisEvents.Interaction.PASS;
        });
    }
}

