/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.core.tardis.handler;

import dev.amble.ait.AITMod;
import dev.amble.ait.api.tardis.KeyedTardisComponent;
import dev.amble.ait.api.tardis.TardisComponent;
import dev.amble.ait.api.tardis.TardisTickable;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.tardis.manager.ServerTardisManager;
import dev.amble.ait.core.tardis.util.TardisUtil;
import dev.amble.ait.data.Exclude;
import dev.amble.ait.data.properties.bool.BoolProperty;
import dev.amble.ait.data.properties.bool.BoolValue;
import dev.amble.lib.data.CachedDirectedGlobalPos;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.server.MinecraftServer;

public class SelfDestructHandler
extends KeyedTardisComponent
implements TardisTickable {
    private static final BoolProperty QUEUED = new BoolProperty("queued");
    private final BoolValue queued = QUEUED.create(this);
    @Exclude
    private boolean destructing;

    public SelfDestructHandler() {
        super(TardisComponent.Id.SELF_DESTRUCT);
    }

    @Override
    public void onLoaded() {
        this.queued.of(this, QUEUED);
        this.destructing = false;
    }

    public void boom() {
        if (this.isQueued() || !this.canSelfDestruct()) {
            return;
        }
        this.queued.set(true);
        this.tardis.alarm().enable();
    }

    private void complete() {
        CachedDirectedGlobalPos exterior = this.tardis.travel().position();
        class_3218 world = exterior.getWorld();
        class_2338 pos = exterior.getPos();
        this.queued.set(false);
        AITMod.LOGGER.warn("Tardis {} has self destructed, expect lag.", (Object)this.tardis.getUuid());
        world.method_8503().method_40000(() -> ServerTardisManager.getInstance().remove(world.method_8503(), this.tardis.asServer()));
        world.method_8454(null, null, TardisUtil.EXPLOSION_BEHAVIOR, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 50.0f, TardisUtil.doCreateFire((class_1937)world), class_1937.class_7867.field_40890);
        world.method_14199((class_2394)class_2398.field_11221, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 10, 1.0, 1.0, 1.0, 1.0);
        world.method_14199((class_2394)class_2398.field_11204, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 100, 1.0, 1.0, 1.0, 1.0);
        world.method_14199((class_2394)class_2398.field_11237, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 250, 1.0, 1.0, 1.0, 1.0);
        world.method_14199((class_2394)class_2398.field_11240, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 50, 1.0, 1.0, 1.0, 1.0);
        world.method_14199((class_2394)class_2398.field_22246, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 25, 1.0, 1.0, 1.0, 1.0);
        world.method_14199((class_2394)class_2398.field_27783, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 10, 1.0, 1.0, 1.0, 1.0);
        world.method_14199((class_2394)class_2398.field_17430, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 500, 1.0, 1.0, 1.0, 1.0);
        world.method_8396(null, pos, AITSounds.GROAN, class_3419.field_15245, 10.0f, 0.7f);
        ServerTardisManager.getInstance().remove(world.method_8503(), this.tardis.asServer());
    }

    public boolean isQueued() {
        return (Boolean)this.queued.get();
    }

    private boolean canSelfDestruct() {
        return this.tardis.travel().isLanded();
    }

    private void warnPlayers() {
        for (class_1657 player : this.tardis.asServer().world().method_18456()) {
            player.method_7353((class_2561)class_2561.method_43471((String)"tardis.message.self_destruct.warning").method_27692(class_124.field_1061), true);
        }
    }

    @Override
    public void tick(MinecraftServer server) {
        if (!this.isQueued()) {
            return;
        }
        if (!this.canSelfDestruct()) {
            this.queued.set(false);
            this.tardis.alarm().disable();
            return;
        }
        if (!TardisUtil.isInteriorEmpty(this.tardis.asServer())) {
            this.warnPlayers();
            return;
        }
        if (!this.destructing) {
            this.tardis.getDesktop().startQueue(true);
            this.tardis.travel().setTemporaryAnimation(AITMod.id("self_destruct"));
            this.tardis.travel().onAnimationComplete(this::complete);
            this.destructing = true;
        }
    }
}

